/*
 * Decompiled with CFR 0.152.
 */
package org.torikiri.xlsapi;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.contrib.HSSFCellUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsContext {
    private HSSFWorkbook workbook;
    private HSSFSheet currentSheet;
    private HSSFRow currentRow;
    private HSSFCell currentCell;

    public XlsContext(HSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public HSSFWorkbook getCurrentBook() {
        return XlsContext.assertNotNull(this.workbook);
    }

    public HSSFSheet getCurrentSheet() {
        return XlsContext.assertNotNull(this.currentSheet);
    }

    public HSSFRow getCurrentRow() {
        return XlsContext.assertNotNull(this.currentRow);
    }

    public HSSFCell getCurrentCellell() {
        return XlsContext.assertNotNull(this.currentCell);
    }

    HSSFSheet nextSheet() {
        this.currentSheet = this.workbook.createSheet();
        return this.currentSheet;
    }

    HSSFSheet nextSheet(String name) {
        this.currentSheet = this.workbook.createSheet(name);
        return this.currentSheet;
    }

    HSSFRow nextRow(int index) {
        this.currentRow = HSSFCellUtil.getRow((int)index, (HSSFSheet)this.getCurrentSheet());
        return this.currentRow;
    }

    HSSFCell nextCell(int index) {
        this.currentCell = this.getCurrentRow().getCell(index, HSSFRow.CREATE_NULL_AS_BLANK);
        return this.currentCell;
    }

    private static <T> T assertNotNull(T o) {
        if (o != null) {
            throw new RuntimeException();
        }
        return o;
    }
}

