/*
 * Decompiled with CFR 0.152.
 */
package org.torikiri.xlsapi;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.torikiri.xlsapi.AbstractElement;
import org.torikiri.xlsapi.Property;
import org.torikiri.xlsapi.PropertySet;
import org.torikiri.xlsapi.Row;
import org.torikiri.xlsapi.XlsContext;
import org.torikiri.xlsapi.sheet.Active;
import org.torikiri.xlsapi.sheet.AlternativeExpression;
import org.torikiri.xlsapi.sheet.AlternativeFormula;
import org.torikiri.xlsapi.sheet.Autobreaks;
import org.torikiri.xlsapi.sheet.ColumnBreak;
import org.torikiri.xlsapi.sheet.ColumnGroupCollapsed;
import org.torikiri.xlsapi.sheet.ColumnHidden;
import org.torikiri.xlsapi.sheet.ColumnWidth;
import org.torikiri.xlsapi.sheet.DefaultColumnStyle;
import org.torikiri.xlsapi.sheet.DefaultColumnWidth;
import org.torikiri.xlsapi.sheet.DefaultRowHeight;
import org.torikiri.xlsapi.sheet.DefaultRowHeightInPoints;
import org.torikiri.xlsapi.sheet.Dialog;
import org.torikiri.xlsapi.sheet.DisplayFormulas;
import org.torikiri.xlsapi.sheet.DisplayGridlines;
import org.torikiri.xlsapi.sheet.DisplayGuts;
import org.torikiri.xlsapi.sheet.DisplayRowColHeadings;
import org.torikiri.xlsapi.sheet.FitToPage;
import org.torikiri.xlsapi.sheet.ForceFormulaRecalculation;
import org.torikiri.xlsapi.sheet.GridsPrinted;
import org.torikiri.xlsapi.sheet.HorizontallyCenter;
import org.torikiri.xlsapi.sheet.Margin;
import org.torikiri.xlsapi.sheet.PrintGridlines;
import org.torikiri.xlsapi.sheet.RowBreak;
import org.torikiri.xlsapi.sheet.RowGroupCollapsed;
import org.torikiri.xlsapi.sheet.RowSumsBelow;
import org.torikiri.xlsapi.sheet.RowSumsRight;
import org.torikiri.xlsapi.sheet.Selected;
import org.torikiri.xlsapi.sheet.VerticallyCenter;
import org.torikiri.xlsapi.sheet.Zoom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sheet
extends AbstractElement<Sheet, Row> {
    private String name;
    private int index = -1;
    private PropertySet<HSSFSheet, Property<HSSFSheet>> properties = new PropertySet();

    public Sheet(String name) {
        this.name = name;
    }

    public Sheet(int index) {
        this.index = index;
    }

    public Sheet(Row ... rows) {
        this.add(rows);
    }

    public Sheet(boolean condition, Row ... rows) {
        this.add(condition, (C[])rows);
    }

    public Sheet active(boolean active) {
        return this.add(new Active(active));
    }

    public Sheet alternativeExpression(boolean b) {
        return this.add(new AlternativeExpression(b));
    }

    public Sheet alternativeFormula(boolean b) {
        return this.add(new AlternativeFormula(b));
    }

    public Sheet autobreaks(boolean b) {
        return this.add(new Autobreaks(b));
    }

    public Sheet columnBreak(short column) {
        return this.add(new ColumnBreak(column));
    }

    public Sheet columnGroupCollapsed(short columnNumber, boolean collapsed) {
        return this.add(new ColumnGroupCollapsed(columnNumber, collapsed));
    }

    public Sheet columnHidden(short column, boolean hidden) {
        return this.add(new ColumnHidden(column, hidden));
    }

    public Sheet columnWidth(short column, short width) {
        return this.add(new ColumnWidth(column, width));
    }

    public Sheet defaultColumnStyle() {
        return this.add(new DefaultColumnStyle());
    }

    public Sheet defaultColumnWidth(short width) {
        return this.add(new DefaultColumnWidth(width));
    }

    public Sheet defaultRowHeight(short height) {
        return this.add(new DefaultRowHeight(height));
    }

    public Sheet defaultRowHeightInPoints(float heightInPoints) {
        return this.add(new DefaultRowHeightInPoints(heightInPoints));
    }

    public Sheet dialog(boolean b) {
        return this.add(new Dialog(b));
    }

    public Sheet displayFormulas(boolean show) {
        return this.add(new DisplayFormulas(show));
    }

    public Sheet displayGridlines(boolean show) {
        return this.add(new DisplayGridlines(show));
    }

    public Sheet displayGuts(boolean b) {
        return this.add(new DisplayGuts(b));
    }

    public Sheet displayRowColHeadings(boolean show) {
        return this.add(new DisplayRowColHeadings(show));
    }

    public Sheet fitToPage(boolean b) {
        return this.add(new FitToPage(b));
    }

    public Sheet forceFormulaRecalculation(boolean b) {
        return this.add(new ForceFormulaRecalculation(b));
    }

    public Sheet gridsPrinted(boolean b) {
        return this.add(new GridsPrinted(b));
    }

    public Sheet horizontallyCenter(boolean b) {
        return this.add(new HorizontallyCenter(b));
    }

    public Sheet margin(short margin, double size) {
        return this.add(new Margin(margin, size));
    }

    public Sheet printGridlines(boolean newPrintGridlines) {
        return this.add(new PrintGridlines(newPrintGridlines));
    }

    public Sheet rowBreak(int row) {
        return this.add(new RowBreak(row));
    }

    public Sheet rowGroupCollapsed(int row, boolean collapsed) {
        return this.add(new RowGroupCollapsed(row, collapsed));
    }

    public Sheet rowSumsBelow(boolean b) {
        return this.add(new RowSumsBelow(b));
    }

    public Sheet rowSumsRight(boolean b) {
        return this.add(new RowSumsRight(b));
    }

    public Sheet selected(boolean sel) {
        return this.add(new Selected(sel));
    }

    public Sheet verticallyCenter(boolean b) {
        return this.add(new VerticallyCenter(b));
    }

    public Sheet zoom(int numerator, int denominator) {
        return this.add(new Zoom(numerator, denominator));
    }

    private Sheet add(Property<HSSFSheet> property) {
        this.properties.add(property);
        return this;
    }

    protected String getName() {
        return this.name;
    }

    protected int getIndex() {
        return this.index;
    }

    protected void build(XlsContext ctx, HSSFSheet sheet) {
        this.properties.build(ctx, sheet);
        int i = 0;
        for (Row r : this.children) {
            i = r.getIndex() < 0 ? i : r.getIndex();
            r.build(ctx, ctx.nextRow(i));
            ++i;
        }
    }

    @Override
    public Sheet getThis() {
        return this;
    }
}

