/*
 * Decompiled with CFR 0.152.
 */
package org.torikiri.xlsapi;

import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.torikiri.xlsapi.AbstractStyle;
import org.torikiri.xlsapi.Property;
import org.torikiri.xlsapi.PropertySet;
import org.torikiri.xlsapi.Style;
import org.torikiri.xlsapi.StyleProperty;
import org.torikiri.xlsapi.XlsContext;
import org.torikiri.xlsapi.cell.AsActive;
import org.torikiri.xlsapi.cell.BooleanCellValue;
import org.torikiri.xlsapi.cell.CalendarCellValue;
import org.torikiri.xlsapi.cell.CellType;
import org.torikiri.xlsapi.cell.DateCellValue;
import org.torikiri.xlsapi.cell.DoubleCellValue;
import org.torikiri.xlsapi.cell.StringCellValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
extends AbstractStyle<Cell> {
    private int index;
    private Style style;
    private PropertySet<HSSFCell, Property<HSSFCell>> properties = new PropertySet();

    public Cell() {
    }

    public Cell(int index) {
        this.index = index;
    }

    public Cell(boolean value) {
        this(-1, value);
    }

    public Cell(Calendar value) {
        this(-1, value);
    }

    public Cell(Date value) {
        this(-1, value);
    }

    public Cell(double value) {
        this(-1, value);
    }

    public Cell(String value) {
        this(-1, value);
    }

    public Cell(int index, boolean value) {
        this(index, value, null);
    }

    public Cell(int index, Calendar value) {
        this(index, value, null);
    }

    public Cell(int index, Date value) {
        this(index, value, null);
    }

    public Cell(int index, double value) {
        this(index, value, null);
    }

    public Cell(int index, String value) {
        this(index, value, null);
    }

    public Cell(int index, boolean value, Style style) {
        this(index, new BooleanCellValue(value), style);
    }

    public Cell(int index, Calendar value, Style style) {
        this(index, new CalendarCellValue(value), style);
    }

    public Cell(int index, Date value, Style style) {
        this(index, new DateCellValue(value), style);
    }

    public Cell(int index, double value, Style style) {
        this(index, new DoubleCellValue(value), style);
    }

    public Cell(int index, String value, Style style) {
        this(index, new StringCellValue(value), style);
    }

    private Cell(int index, Property<HSSFCell> value, Style style) {
        this.index = index;
        this.style = style;
        this.add(value);
    }

    public Cell active(boolean active) {
        return this.add(new AsActive());
    }

    public Cell style(Style style) {
        this.style = style;
        return this;
    }

    public Cell cellType(int cellType) {
        return this.add(new CellType(cellType));
    }

    protected int getIndex() {
        return this.index;
    }

    protected void build(XlsContext ctx, HSSFCell cell) {
        this.properties.build(ctx, cell);
        if (this.style != null) {
            this.style.build(ctx, cell.getCellStyle());
        }
    }

    protected Cell add(Property<HSSFCell> property) {
        this.properties.add(property);
        return this;
    }

    @Override
    protected Cell add(StyleProperty a) {
        if (this.style == null) {
            this.style = new Style();
        }
        this.style.add(a);
        return this;
    }
}

