/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.cf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.hssf.util.Region;

public final class CellRange {
    private static final int LAST_ROW_INDEX = 65535;
    private static final int LAST_COLUMN_INDEX = 255;
    private static final Region[] EMPTY_REGION_ARRAY = new Region[0];
    private int _firstRow;
    private int _lastRow;
    private int _firstColumn;
    private int _lastColumn;
    public static final int NO_INTERSECTION = 1;
    public static final int OVERLAP = 2;
    public static final int INSIDE = 3;
    public static final int ENCLOSES = 4;

    public CellRange(int firstRow, int lastRow, int firstColumn, int lastColumn) {
        if (!CellRange.isValid(firstRow, lastRow, firstColumn, lastColumn)) {
            throw new IllegalArgumentException("invalid cell range (" + firstRow + ", " + lastRow + ", " + firstColumn + ", " + lastColumn + ")");
        }
        this._firstRow = firstRow;
        this._lastRow = CellRange.convertM1ToMax(lastRow, 65535);
        this._firstColumn = firstColumn;
        this._lastColumn = CellRange.convertM1ToMax(lastColumn, 255);
    }

    private static int convertM1ToMax(int lastIx, int maxIndex) {
        if (lastIx < 0) {
            return maxIndex;
        }
        return lastIx;
    }

    public boolean isFullColumnRange() {
        return this._firstRow == 0 && this._lastRow == 65535;
    }

    public boolean isFullRowRange() {
        return this._firstColumn == 0 && this._lastColumn == 255;
    }

    private static CellRange createFromRegion(Region r) {
        return new CellRange(r.getRowFrom(), r.getRowTo(), r.getColumnFrom(), r.getColumnTo());
    }

    private static boolean isValid(int firstRow, int lastRow, int firstColumn, int lastColumn) {
        if (lastRow < 0 || lastRow > 65535) {
            return false;
        }
        if (firstRow < 0 || firstRow > 65535) {
            return false;
        }
        if (lastColumn < 0 || lastColumn > 255) {
            return false;
        }
        return firstColumn >= 0 && firstColumn <= 255;
    }

    public int getFirstRow() {
        return this._firstRow;
    }

    public int getLastRow() {
        return this._lastRow;
    }

    public int getFirstColumn() {
        return this._firstColumn;
    }

    public int getLastColumn() {
        return this._lastColumn;
    }

    public int intersect(CellRange another) {
        int firstRow = another.getFirstRow();
        int lastRow = another.getLastRow();
        int firstCol = another.getFirstColumn();
        int lastCol = another.getLastColumn();
        if (CellRange.gt(this.getFirstRow(), lastRow) || CellRange.lt(this.getLastRow(), firstRow) || CellRange.gt(this.getFirstColumn(), lastCol) || CellRange.lt(this.getLastColumn(), firstCol)) {
            return 1;
        }
        if (this.contains(another)) {
            return 3;
        }
        if (another.contains(this)) {
            return 4;
        }
        return 2;
    }

    public static CellRange[] mergeCellRanges(CellRange[] cellRanges) {
        if (cellRanges.length < 1) {
            return cellRanges;
        }
        List temp = CellRange.mergeCellRanges(Arrays.asList(cellRanges));
        return CellRange.toArray(temp);
    }

    private static List mergeCellRanges(List cellRangeList) {
        while (cellRangeList.size() > 1) {
            boolean somethingGotMerged = false;
            for (int i = 0; i < cellRangeList.size(); ++i) {
                CellRange range1 = (CellRange)cellRangeList.get(i);
                for (int j = i + 1; j < cellRangeList.size(); ++j) {
                    CellRange range2 = (CellRange)cellRangeList.get(j);
                    CellRange[] mergeResult = CellRange.mergeRanges(range1, range2);
                    if (mergeResult == null) continue;
                    somethingGotMerged = true;
                    cellRangeList.set(i, mergeResult[0]);
                    cellRangeList.remove(j--);
                    for (int k = 1; k < mergeResult.length; ++k) {
                        cellRangeList.add(++j, mergeResult[k]);
                    }
                }
            }
            if (somethingGotMerged) continue;
            break;
        }
        return cellRangeList;
    }

    private static CellRange[] mergeRanges(CellRange range1, CellRange range2) {
        int x = range1.intersect(range2);
        switch (x) {
            case 1: {
                if (range1.hasExactSharedBorder(range2)) {
                    return new CellRange[]{range1.createEnclosingCellRange(range2)};
                }
                return null;
            }
            case 2: {
                return CellRange.resolveRangeOverlap(range1, range2);
            }
            case 3: {
                return new CellRange[]{range1};
            }
            case 4: {
                return new CellRange[]{range2};
            }
        }
        throw new RuntimeException("unexpected intersection result (" + x + ")");
    }

    static CellRange[] resolveRangeOverlap(CellRange rangeA, CellRange rangeB) {
        if (rangeA.isFullColumnRange()) {
            if (rangeB.isFullRowRange()) {
                return null;
            }
            return rangeA.sliceUp(rangeB);
        }
        if (rangeA.isFullRowRange()) {
            if (rangeB.isFullColumnRange()) {
                return null;
            }
            return rangeA.sliceUp(rangeB);
        }
        if (rangeB.isFullColumnRange()) {
            return rangeB.sliceUp(rangeA);
        }
        if (rangeB.isFullRowRange()) {
            return rangeB.sliceUp(rangeA);
        }
        return rangeA.sliceUp(rangeB);
    }

    private CellRange[] sliceUp(CellRange range) {
        List<CellRange> temp = new ArrayList<CellRange>();
        temp.add(range);
        if (!this.isFullColumnRange()) {
            temp = CellRange.cutHorizontally(this._firstRow, temp);
            temp = CellRange.cutHorizontally(this._lastRow + 1, temp);
        }
        if (!this.isFullRowRange()) {
            temp = CellRange.cutVertically(this._firstColumn, temp);
            temp = CellRange.cutVertically(this._lastColumn + 1, temp);
        }
        CellRange[] crParts = CellRange.toArray(temp);
        temp.clear();
        temp.add(this);
        for (int i = 0; i < crParts.length; ++i) {
            CellRange crPart = crParts[i];
            if (this.intersect(crPart) == 4) continue;
            temp.add(crPart);
        }
        return CellRange.toArray(temp);
    }

    private static List cutHorizontally(int cutRow, List input) {
        ArrayList<CellRange> result = new ArrayList<CellRange>();
        CellRange[] crs = CellRange.toArray(input);
        for (int i = 0; i < crs.length; ++i) {
            CellRange cr = crs[i];
            if (cr._firstRow < cutRow && cutRow < cr._lastRow) {
                result.add(new CellRange(cr._firstRow, cutRow, cr._firstColumn, cr._lastColumn));
                result.add(new CellRange(cutRow + 1, cr._lastRow, cr._firstColumn, cr._lastColumn));
                continue;
            }
            result.add(cr);
        }
        return result;
    }

    private static List cutVertically(int cutColumn, List input) {
        ArrayList<CellRange> result = new ArrayList<CellRange>();
        CellRange[] crs = CellRange.toArray(input);
        for (int i = 0; i < crs.length; ++i) {
            CellRange cr = crs[i];
            if (cr._firstColumn < cutColumn && cutColumn < cr._lastColumn) {
                result.add(new CellRange(cr._firstRow, cr._lastRow, cr._firstColumn, cutColumn));
                result.add(new CellRange(cr._firstRow, cr._lastRow, cutColumn + 1, cr._lastColumn));
                continue;
            }
            result.add(cr);
        }
        return result;
    }

    private static CellRange[] toArray(List temp) {
        CellRange[] result = new CellRange[temp.size()];
        temp.toArray(result);
        return result;
    }

    public static CellRange[] convertRegionsToCellRanges(Region[] regions) {
        CellRange[] result = new CellRange[regions.length];
        for (int i = 0; i < regions.length; ++i) {
            result[i] = CellRange.createFromRegion(regions[i]);
        }
        return result;
    }

    public static Region[] convertCellRangesToRegions(CellRange[] cellRanges) {
        int size = cellRanges.length;
        if (size < 1) {
            return EMPTY_REGION_ARRAY;
        }
        Region[] result = new Region[size];
        for (int i = 0; i != size; ++i) {
            result[i] = cellRanges[i].convertToRegion();
        }
        return result;
    }

    private Region convertToRegion() {
        return new Region(this._firstRow, (short)this._firstColumn, this._lastRow, (short)this._lastColumn);
    }

    public boolean contains(CellRange range) {
        int firstRow = range.getFirstRow();
        int lastRow = range.getLastRow();
        int firstCol = range.getFirstColumn();
        int lastCol = range.getLastColumn();
        return CellRange.le(this.getFirstRow(), firstRow) && CellRange.ge(this.getLastRow(), lastRow) && CellRange.le(this.getFirstColumn(), firstCol) && CellRange.ge(this.getLastColumn(), lastCol);
    }

    public boolean contains(int row, short column) {
        return CellRange.le(this.getFirstRow(), row) && CellRange.ge(this.getLastRow(), row) && CellRange.le(this.getFirstColumn(), column) && CellRange.ge(this.getLastColumn(), column);
    }

    public boolean hasExactSharedBorder(CellRange range) {
        int oFirstRow = range._firstRow;
        int oLastRow = range._lastRow;
        int oFirstCol = range._firstColumn;
        int oLastCol = range._lastColumn;
        if (this._firstRow > 0 && this._firstRow - 1 == oLastRow || oFirstRow > 0 && oFirstRow - 1 == this._lastRow) {
            return this._firstColumn == oFirstCol && this._lastColumn == oLastCol;
        }
        if (this._firstColumn > 0 && this._firstColumn - 1 == oLastCol || oFirstCol > 0 && this._lastColumn == oFirstCol - 1) {
            return this._firstRow == oFirstRow && this._lastRow == oLastRow;
        }
        return false;
    }

    public CellRange createEnclosingCellRange(CellRange range) {
        if (range == null) {
            return this.cloneCellRange();
        }
        CellRange cellRange = new CellRange(CellRange.lt(range.getFirstRow(), this.getFirstRow()) ? range.getFirstRow() : this.getFirstRow(), CellRange.gt(range.getLastRow(), this.getLastRow()) ? range.getLastRow() : this.getLastRow(), CellRange.lt(range.getFirstColumn(), this.getFirstColumn()) ? range.getFirstColumn() : this.getFirstColumn(), CellRange.gt(range.getLastColumn(), this.getLastColumn()) ? range.getLastColumn() : this.getLastColumn());
        return cellRange;
    }

    public CellRange cloneCellRange() {
        return new CellRange(this.getFirstRow(), this.getLastRow(), this.getFirstColumn(), this.getLastColumn());
    }

    private static boolean lt(int a, int b) {
        return a == -1 ? false : (b == -1 ? true : a < b);
    }

    private static boolean le(int a, int b) {
        return a == b || CellRange.lt(a, b);
    }

    private static boolean gt(int a, int b) {
        return CellRange.lt(b, a);
    }

    private static boolean ge(int a, int b) {
        return !CellRange.lt(a, b);
    }

    public String toString() {
        return "(" + this.getFirstRow() + "," + this.getLastRow() + "," + this.getFirstColumn() + "," + this.getLastColumn() + ")";
    }
}

