/*
 * 쐬: 2003/11/10
 *
 * Model̏񂩂\[X𐶐
 * 
 */
package jp.ne.dti.venus.okazaki.xls2src;

import java.io.*;

import java.util.HashMap;
import java.util.ArrayList;

import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HSSFSheet;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author kenichi_okazaki
 *
 * Model̏񂩂\[X𐶐
 * 
 */
public class Xls2src extends Task {
	
	private GeneratorInfo _ginfo ;	//generator̐ݒ
	
	private String _templateDir = "template";
	private String _destDir = "destDir";
	private String _xlsFile = "data/workbook.xls";


	/**
	 * 
	 */
	public Xls2src() {

	}

	public void execute()  {

		XmlLoader xmlloader = new XmlLoader();
		_ginfo = (GeneratorInfo)xmlloader.execute( _templateDir + "/digester.xml", _templateDir + "/generateInfo.xml") ;	//XMLt@C̓ǂݍ

		ArrayList modelCollection;
		
		try {
			modelCollection = getModelCollection();
			excute2( modelCollection);
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
		System.out.println("end");

	}

	private ArrayList getModelCollection() throws IOException{
		ArrayList modelCollection = new ArrayList();
		String sheetName;

		POIFSFileSystem fs      =
				new POIFSFileSystem(new FileInputStream( _xlsFile  ));
		HSSFWorkbook wb = new HSSFWorkbook(fs);	//[NubN̎擾

		//ڎ̎擾
		HSSFSheet indexSheet = wb.getSheet("index");
		Table indexTable = new Table( indexSheet);
		
		//CMR̎擾
		HSSFSheet cmrInfoSheet = wb.getSheet("CMR");	
		Table cmrInfoTable = new Table( cmrInfoSheet);
						
		for( int i = 0 ; i < indexTable.getRows().size()   ; i++ ){
			HashMap info  = (HashMap)indexTable.getRows().get(i);
			info.get("sheet");
			
			//V[g̎擾
			HSSFSheet sheet = wb.getSheet( (String)info.get("sheet") );
			Table table = new Table( sheet);
			
			//f̐
			Model model = new Model();
			model.setInfo(info);
			model.setRows(table.getRows() );
			model.setCmrInfo(cmrInfoTable.getRows() );
				
			
			System.out.println("class" + info.get("NX") + i );
			modelCollection.add( model );
		}
		
		return modelCollection;
		
	}
	
	/**
	 * Java\[X̎s
	 * 
	 * @throws Exception
	 */
	public void excute2( ArrayList modelCollection ) throws Exception ,IOException {

		ArrayList templates = _ginfo.getTemplates() ;
		
		Util util = new Util();

		Velocity.init( _templateDir + "/velocity.properties");
		VelocityContext context = new VelocityContext();

		for (int i = 0; i < modelCollection.size() ; i++) {
			Model model = (Model)modelCollection.get(i);
			
			context.put("info"		, model.getInfo() );
			context.put("rows"		, model.getRows() );
			context.put("cmrInfo"	, model.getCmrInfo() );
			
			context.put("util", util );
			context.put("u", util );	

			//ev[g̃p^[̐[v
			for (int j = 0; j < modelCollection.size() ; j++) {
				write( (HashMap)templates.get(j)  , context, model);
			}
			
		}
	}

	/**
	 * t@Cɏo
	 * 
	 * @param beanData - f[^NX̏
	 * @param writer - Velocityɂăev[gƃ}[WꂽC^[
	 * @throws IOException
	 */
	private void write( HashMap templateInfo , VelocityContext context ,Model model) throws ResourceNotFoundException, ParseErrorException, Exception {
		
		FileWriter fileWriter = null;
		StringWriter writer = new StringWriter();
		
		
		Template template = Velocity.getTemplate( _templateDir  +"/"+ ((String)templateInfo.get("templateFileName")) , "Shift_JIS");
	
		template.merge(context, writer);
		
		//t@CۑtH_̃tH_𐶐
		String packageDirName =  _destDir + "/" + ((String)templateInfo.get("distDir")) ;
		String packageName = ((String)model.getInfo().get( "pbP[W"));
		if( ((String)templateInfo.get("packageDir")).equals("all")  ){ 
			//pbP[W̃fBNgǉ			
			packageDirName = packageDirName + "/" +packageName.replace( '.' , '/' );
		}else if( ((String)templateInfo.get("packageDir")).equals("last")  ){ 
			//pbP[W̍Ō̃tH_gāAfBNgǉ
			//JSPt@C̕ۑ̂ɗp			
			packageDirName = packageDirName + "/" + packageName.substring( packageName.lastIndexOf(".") + 1,  packageName.length()  );
	}
		
		System.out.println("packageDirName[" + packageDirName +"]");
		// pbP[W̃fBNg̐
		File file = new File(packageDirName);
		file.mkdirs();
		Util u = new Util();
						
		try {
			fileWriter = new FileWriter( packageDirName + "/" + ((String)templateInfo.get("fileName")).replaceAll( "\\$1" , u.uCaseFC((String)model.getInfo().get( "NX")) ) );
			fileWriter.write(writer.toString());
		} finally {
			if (fileWriter != null) {
				fileWriter.close();
			}
		}
	}
	
	
	/**
	 * @return
	 */
	public String getTemplateDir() {
		return _templateDir;
	}

	/**
	 * @param string
	 */
	public void setDestDir(String string) {
		_destDir = string;
	}

	/**
	 * @param string
	 */
	public void setTemplateDir(String string) {
		_templateDir = string;
	}

	/**
	 * @param string
	 */
	public void setXlsFile(String string) {
		_xlsFile = string;
	}

}
