/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.dti.venus.okazaki.xls2src;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import jp.ne.dti.venus.okazaki.xls2src.GeneratorInfo;
import jp.ne.dti.venus.okazaki.xls2src.Model;
import jp.ne.dti.venus.okazaki.xls2src.Table;
import jp.ne.dti.venus.okazaki.xls2src.Util;
import jp.ne.dti.venus.okazaki.xls2src.XmlLoader;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tools.ant.Task;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class Xls2src
extends Task {
    private GeneratorInfo _ginfo;
    private String _templateDir = "template";
    private String _destDir = "destDir";
    private String _xlsFile = "data/workbook.xls";

    public void execute() {
        XmlLoader xmlLoader = new XmlLoader();
        this._ginfo = (GeneratorInfo)xmlLoader.execute(this._templateDir + "/digester.xml", this._templateDir + "/generateInfo.xml");
        try {
            ArrayList arrayList = this.getModelCollection();
            this.excute2(arrayList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList getModelCollection() throws IOException {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(this._xlsFile));
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
        HSSFSheet hSSFSheet = hSSFWorkbook.getSheet("index");
        Table table = new Table(hSSFSheet);
        HSSFSheet hSSFSheet2 = hSSFWorkbook.getSheet("CMR");
        Table table2 = new Table(hSSFSheet2);
        for (int i = 0; i < table.getRows().size(); ++i) {
            HashMap hashMap = (HashMap)table.getRows().get(i);
            hashMap.get("sheet");
            HSSFSheet hSSFSheet3 = hSSFWorkbook.getSheet((String)hashMap.get("sheet"));
            Table table3 = new Table(hSSFSheet3);
            Model model = new Model();
            model.setInfo(hashMap);
            model.setRows(table3.getRows());
            model.setCmrInfo(table2.getRows());
            System.out.println("class" + hashMap.get("\u30af\u30e9\u30b9\u540d") + i);
            arrayList.add(model);
        }
        return arrayList;
    }

    public void excute2(ArrayList arrayList) throws Exception, IOException {
        ArrayList arrayList2 = this._ginfo.getTemplates();
        Util util = new Util();
        Velocity.init((String)(this._templateDir + "/velocity.properties"));
        VelocityContext velocityContext = new VelocityContext();
        for (int i = 0; i < arrayList.size(); ++i) {
            Model model = (Model)arrayList.get(i);
            velocityContext.put("info", (Object)model.getInfo());
            velocityContext.put("rows", (Object)model.getRows());
            velocityContext.put("cmrInfo", (Object)model.getCmrInfo());
            velocityContext.put("util", (Object)util);
            velocityContext.put("u", (Object)util);
            for (int j = 0; j < arrayList.size(); ++j) {
                this.write((HashMap)arrayList2.get(j), velocityContext, model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HashMap hashMap, VelocityContext velocityContext, Model model) throws ResourceNotFoundException, ParseErrorException, Exception {
        OutputStreamWriter outputStreamWriter = null;
        StringWriter stringWriter = new StringWriter();
        Template template = Velocity.getTemplate((String)(this._templateDir + "/" + (String)hashMap.get("templateFileName")), (String)"Shift_JIS");
        template.merge((Context)velocityContext, (Writer)stringWriter);
        String string = this._destDir + "/" + (String)hashMap.get("distDir");
        if (((String)hashMap.get("packageDir")).equals("true")) {
            string = string + "/" + ((String)model.getInfo().get("\u30d1\u30c3\u30b1\u30fc\u30b8\u540d")).replace('.', '/');
        }
        File file = new File(string);
        file.mkdirs();
        try {
            System.out.println("fileName[" + ((String)hashMap.get("fileName")).replaceAll("\\$1", (String)model.getInfo().get("name")) + "]");
            outputStreamWriter = new FileWriter(string + "/" + ((String)hashMap.get("fileName")).replaceAll("\\$1", (String)model.getInfo().get("name")));
            outputStreamWriter.write(stringWriter.toString());
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
        }
    }

    public String getTemplateDir() {
        return this._templateDir;
    }

    public void setDestDir(String string) {
        this._destDir = string;
    }

    public void setTemplateDir(String string) {
        this._templateDir = string;
    }

    public void setXlsFile(String string) {
        this._xlsFile = string;
    }
}

