/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.UnknownRecord;

public class ValueRecordsAggregate
extends Record {
    public static final short sid = -1000;
    int firstcell = -1;
    int lastcell = -1;
    TreeMap records = new TreeMap();
    int size = 0;

    public void insertCell(CellValueRecordInterface cell) {
        this.size = this.records.get(cell) == null ? (this.size += ((Record)((Object)cell)).getRecordSize()) : (this.size += ((Record)((Object)cell)).getRecordSize() - ((Record)this.records.get(cell)).getRecordSize());
        this.records.put(cell, cell);
        if (cell.getColumn() < this.firstcell || this.firstcell == -1) {
            this.firstcell = cell.getColumn();
        }
        if (cell.getColumn() > this.lastcell || this.lastcell == -1) {
            this.lastcell = cell.getColumn();
        }
    }

    public void removeCell(CellValueRecordInterface cell) {
        this.size -= ((Record)((Object)cell)).getRecordSize();
        this.records.remove(cell);
    }

    public int getPhysicalNumberOfCells() {
        return this.records.size();
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public int construct(int offset, List records) {
        int k = 0;
        k = offset;
        while (k < records.size()) {
            Record rec = (Record)records.get(k);
            if (!rec.isInValueSection() && !(rec instanceof UnknownRecord)) break;
            if (rec.isValue()) {
                this.insertCell((CellValueRecordInterface)((Object)rec));
            }
            ++k;
        }
        return k;
    }

    public int serialize(int offset, byte[] data) {
        Iterator itr = this.records.values().iterator();
        int pos = offset;
        while (itr.hasNext()) {
            pos += ((Record)itr.next()).serialize(pos, data);
        }
        return pos - offset;
    }

    protected void fillFields(byte[] data, short size, int offset) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1000;
    }

    public int getRecordSize() {
        return this.size;
    }

    public Iterator getIterator() {
        return this.records.values().iterator();
    }
}

