package sample.ejb;

import javax.ejb.*;
import java.sql.Date;
import java.util.Collection;

import sample.ejb.*;

/**
 * ڋq
 * 
 * @author 
 * @since 37918.0
 */
 
 /**
 *  ڋq\GeBeBBeanłB
 *
 * @ejb.bean
 *   description="ڋq\GeBeBBean"
 *   name="Customer"
 *   type="CMP"
 *   view-type="both"
 *   jndi-name="ejb/library/customer"
 *   local-jndi-name="ejb/library/customerLocal"
 *   primkey-field="id"
 *
 * @ejb.transaction type="Required"
 *
 * @ejb.value-object name="Customer"
 *
 * @ejb.persistence table-name="Customer"
 * @jboss.persistence create-table="${jboss.create.table}"
 * @jboss.persistence remove-table="${jboss.remove.table}"
 * @jboss.read-ahead strategy="on-load"
 * @jboss.read-only read-only="false"
 */
public abstract class CustomerBean implements EntityBean {
  protected EntityContext ctx;
	
	/**
	 * ڋqID
	 *
	 * @return ڋqID
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract java.lang.String getId();

	/**
	 * ڋqID
	 *
	 * @param id ڋqID
	 */
	public abstract void setId(java.lang.String id);

	/**
	 * ڋq
	 *
	 * @return ڋq
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract java.lang.String getName();

	/**
	 * ڋq
	 *
	 * @param name ڋq
	 */
	public abstract void setName(java.lang.String name);

	/**
	 * l
	 *
	 * @return l
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract java.lang.String getNote();

	/**
	 * l
	 *
	 * @param note l
	 */
	public abstract void setNote(java.lang.String note);



   	/**
	 * ڋq - Č
	 *
	 * @return ankeñRNV
	 * @ejb.interface-method
	 *    view-type="local"
	 * @ejb.relation
 	 *    name="CustomerAnkens-to-Customer"
	 *    role-name="Customer-recorded-in-CustomerAnkens"
	 */
	public abstract Collection getCustomerAnkens();

	/**
	 * ڋq - Č
	 *
	 * @param Collection  ankeñRNV
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setCustomerAnkens(Collection customerAnkens);

       	/**
	 * Gh[U - Č
	 *
	 * @return ankeñRNV
	 * @ejb.interface-method
	 *    view-type="local"
	 * @ejb.relation
 	 *    name="EndUserAnkens-to-EndUser"
	 *    role-name="Customer-recorded-in-EndUserAnkens"
	 */
	public abstract Collection getEndUserAnkens();

	/**
	 * Gh[U - Č
	 *
	 * @param Collection  ankeñRNV
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setEndUserAnkens(Collection endUserAnkens);

            

  /**
   * @ejb.create-method
   */
  public String ejbCreate(
			java.lang.String id 
				, java.lang.String name 
				, java.lang.String note 
	) throws CreateException {
    if (id == null) {
      throw new CreateException("id is null");
    }
	setId( id );
	setName( name );
	setNote( note );

    return null;
  }

  public void ejbPostCreate(
			java.lang.String id 
				, java.lang.String name 
				, java.lang.String note 
	  ) {}


  public void setEntityContext(EntityContext ctx) { this.ctx = ctx; }
  public void unsetEntityContext() { ctx = null; }
  public void ejbActivate() {}
  public void ejbPassivate() {}
  public void ejbLoad() {}
  public void ejbStore() {}
  public void ejbRemove() throws javax.ejb.RemoveException {}

}
