package sample.ejb;

import javax.ejb.*;
import java.sql.Date;
import java.util.Collection;

import sample.ejb.*;

/**
 * ATC
 * 
 * @author 
 * @since 37918.0
 */
 
 /**
 *  ATC\GeBeBBeanłB
 *
 * @ejb.bean
 *   description="ATC\GeBeBBean"
 *   name="Assign"
 *   type="CMP"
 *   view-type="both"
 *   jndi-name="ejb/library/assign"
 *   local-jndi-name="ejb/library/assignLocal"
 *   primkey-field="id"
 *
 * @ejb.transaction type="Required"
 *
 * @ejb.value-object name="Assign"
 *
 * @ejb.persistence table-name="Assign"
 * @jboss.persistence create-table="${jboss.create.table}"
 * @jboss.persistence remove-table="${jboss.remove.table}"
 * @jboss.read-ahead strategy="on-load"
 * @jboss.read-only read-only="false"
 */
public abstract class AssignBean implements EntityBean {
  protected EntityContext ctx;
	
	/**
	 * ATCID
	 *
	 * @return ATCID
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getId();

	/**
	 * ATCID
	 *
	 * @param id ATCID
	 */
	public abstract void setId(String id);

	/**
	 * o[ID
	 *
	 * @return o[ID
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getMemberId();

	/**
	 * o[ID
	 *
	 * @param MemberId o[ID
	 */
	public abstract void setMemberId(String MemberId);

	/**
	 * ČID
	 *
	 * @return ČID
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getAnkenId();

	/**
	 * ČID
	 *
	 * @param AnkenId ČID
	 */
	public abstract void setAnkenId(String AnkenId);

	/**
	 * Se
	 *
	 * @return Se
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getRole();

	/**
	 * Se
	 *
	 * @param role Se
	 */
	public abstract void setRole(String role);



            	/**
	 * o - ATC
	 *
	 * @return member
	 * @ejb.interface-method
	 *    view-type="local"
	 * @ejb.relation
 	 *    name="Assigns-to-Member"
	 *    role-name="Member-recorded-in-Member"
	 * @jboss.relation
	 *    related-pk-field="id"
	 *    fk-column="member"
	 */
	public abstract MemberLocal getMember();

	/**
	 * o - ATC
	 *
	 * @param member o - ATC
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setMember( MemberLocal member);

      	/**
	 * Č - ATC
	 *
	 * @return anken
	 * @ejb.interface-method
	 *    view-type="local"
	 * @ejb.relation
 	 *    name="Assigns-to-Anken"
	 *    role-name="Anken-recorded-in-Anken"
	 * @jboss.relation
	 *    related-pk-field="id"
	 *    fk-column="anken"
	 */
	public abstract AnkenLocal getAnken();

	/**
	 * Č - ATC
	 *
	 * @param anken Č - ATC
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setAnken( AnkenLocal anken);

  

  /**
   * @ejb.create-method
   */
  public String ejbCreate(
			String id 
				, String MemberId 
				, String AnkenId 
				, String role 
	) throws CreateException {
    if (id == null) {
      throw new CreateException("id is null");
    }
	setId( id );
	setMemberId( MemberId );
	setAnkenId( AnkenId );
	setRole( role );

    return null;
  }

  public void ejbPostCreate(
			String id 
				, String MemberId 
				, String AnkenId 
				, String role 
	  ) {}


  public void setEntityContext(EntityContext ctx) { this.ctx = ctx; }
  public void unsetEntityContext() { ctx = null; }
  public void ejbActivate() {}
  public void ejbPassivate() {}
  public void ejbLoad() {}
  public void ejbStore() {}
  public void ejbRemove() throws javax.ejb.RemoveException {}

}
