package sample.ejb;

import javax.ejb.*;
import java.sql.Date;
import java.util.Collection;

import sample.ejb.*;

/**
 * Č
 * 
 * @author 
 * @since 37918.0
 */
 
 /**
 *  Č\GeBeBBeanłB
 *
 * @ejb.bean
 *   description="Č\GeBeBBean"
 *   name="Anken"
 *   type="CMP"
 *   view-type="both"
 *   jndi-name="ejb/library/anken"
 *   local-jndi-name="ejb/library/ankenLocal"
 *   primkey-field="id"
 *
 * @ejb.transaction type="Required"
 *
 * @ejb.value-object name="Anken"
 *
 * @ejb.persistence table-name="Anken"
 * @jboss.persistence create-table="${jboss.create.table}"
 * @jboss.persistence remove-table="${jboss.remove.table}"
 * @jboss.read-ahead strategy="on-load"
 * @jboss.read-only read-only="false"
 */
public abstract class AnkenBean implements EntityBean {
  protected EntityContext ctx;
	
	/**
	 * ČID
	 *
	 * @return ČID
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getId();

	/**
	 * ČID
	 *
	 * @param id ČID
	 */
	public abstract void setId(String id);

	/**
	 * vWFNg
	 *
	 * @return vWFNg
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getName();

	/**
	 * vWFNg
	 *
	 * @param name vWFNg
	 */
	public abstract void setName(String name);

	/**
	 * Č
	 *
	 * @return Č
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getAnken_type();

	/**
	 * Č
	 *
	 * @param anken_type Č
	 */
	public abstract void setAnken_type(String anken_type);

	/**
	 * Či
	 *
	 * @return Či
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getOperatingStatus();

	/**
	 * Či
	 *
	 * @param operatingStatus Či
	 */
	public abstract void setOperatingStatus(String operatingStatus);

	/**
	 * 󒍗\
	 *
	 * @return 󒍗\
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract Date getOrderReceivedScheduledMonth();

	/**
	 * 󒍗\
	 *
	 * @param orderReceivedScheduledMonth 󒍗\
	 */
	public abstract void setOrderReceivedScheduledMonth(Date orderReceivedScheduledMonth);

	/**
	 * ς(~)
	 *
	 * @return ς(~)
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract int getAmountOfMoney();

	/**
	 * ς(~)
	 *
	 * @param amountOfMoney ς(~)
	 */
	public abstract void setAmountOfMoney(int amountOfMoney);

	/**
	 * l
	 *
	 * @return l
	 * @ejb.interface-method
	 * @ejb.persistent-field
	 */
  	public abstract String getNote();

	/**
	 * l
	 *
	 * @param note l
	 */
	public abstract void setNote(String note);



    	/**
	 * ڋq - Č
	 *
	 * @return customer
	 * @ejb.interface-method
	 *    view-type="local"
	 * @ejb.relation
 	 *    name="CustomerAnkens-to-Customer"
	 *    role-name="Customer-recorded-in-Customer"
	 * @jboss.relation
	 *    related-pk-field="id"
	 *    fk-column="customer"
	 */
	public abstract CustomerLocal getCustomer();

	/**
	 * ڋq - Č
	 *
	 * @param customer ڋq - Č
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setCustomer( CustomerLocal customer);

      	/**
	 * Gh[U - Č
	 *
	 * @return customer
	 * @ejb.interface-method
	 *    view-type="local"
	 * @ejb.relation
 	 *    name="EndUserAnkens-to-EndUser"
	 *    role-name="Customer-recorded-in-EndUser"
	 * @jboss.relation
	 *    related-pk-field="id"
	 *    fk-column="endUser"
	 */
	public abstract CustomerLocal getEndUser();

	/**
	 * Gh[U - Č
	 *
	 * @param endUser Gh[U - Č
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setEndUser( CustomerLocal endUser);

         	/**
	 * Č - ATC
	 *
	 * @return assigñRNV
	 * @ejb.interface-method
	 *    view-type="local"
	 * @ejb.relation
 	 *    name="Assigns-to-Anken"
	 *    role-name="Anken-recorded-in-Assigns"
	 */
	public abstract Collection getAssigns();

	/**
	 * Č - ATC
	 *
	 * @param Collection  assigñRNV
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setAssigns(Collection assigns);

    

  /**
   * @ejb.create-method
   */
  public String ejbCreate(
			String id 
				, String name 
				, String anken_type 
				, String operatingStatus 
				, Date orderReceivedScheduledMonth 
				, int amountOfMoney 
				, String note 
	) throws CreateException {
    if (id == null) {
      throw new CreateException("id is null");
    }
	setId( id );
	setName( name );
	setAnken_type( anken_type );
	setOperatingStatus( operatingStatus );
	setOrderReceivedScheduledMonth( orderReceivedScheduledMonth );
	setAmountOfMoney( amountOfMoney );
	setNote( note );

    return null;
  }

  public void ejbPostCreate(
			String id 
				, String name 
				, String anken_type 
				, String operatingStatus 
				, Date orderReceivedScheduledMonth 
				, int amountOfMoney 
				, String note 
	  ) {}


  public void setEntityContext(EntityContext ctx) { this.ctx = ctx; }
  public void unsetEntityContext() { ctx = null; }
  public void ejbActivate() {}
  public void ejbPassivate() {}
  public void ejbLoad() {}
  public void ejbStore() {}
  public void ejbRemove() throws javax.ejb.RemoveException {}

}
