/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.generator;

import org.apache.poi.generator.RecordUtil;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;

public class FieldIterator {
    protected int offset;

    public void init(XSLProcessorContext context, ElemExtensionCall extElem) {
        this.offset = 0;
    }

    public String fillDecoder(String size, String type) {
        String javaType = RecordUtil.getType(size, type, 0);
        String result = "";
        if (javaType.equals("short")) {
            result = "LittleEndian.getShort(data, 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (javaType.equals("short[]")) {
            result = "LittleEndian.getShortArray(data, 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (javaType.equals("int")) {
            result = "LittleEndian.getInt(data, 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (javaType.equals("byte")) {
            result = "data[ 0x" + Integer.toHexString(this.offset) + " + offset ]";
        } else if (javaType.equals("double")) {
            result = "LittleEndian.getDouble(data, 0x" + Integer.toHexString(this.offset) + " + offset)";
        } else if (javaType.equals("ExcelString")) {
            result = "ExcelStringUtil.decodeExcelString(data, 0x" + Integer.toHexString(this.offset) + " + offset)";
        }
        try {
            this.offset += Integer.parseInt(size);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        return result;
    }

    public String serialiseEncoder(int fieldNumber, String fieldName, String size, String type) {
        String javaType = RecordUtil.getType(size, type, 0);
        String javaFieldName = RecordUtil.getFieldName(fieldNumber, fieldName, 0);
        String result = "";
        if (javaType.equals("short")) {
            result = "LittleEndian.putShort(data, " + (this.offset + 4) + " + offset, " + javaFieldName + ");";
        } else if (javaType.equals("short[]")) {
            result = "LittleEndian.putShortArray(data, " + (this.offset + 4) + " + offset, " + javaFieldName + ");";
        } else if (javaType.equals("int")) {
            result = "LittleEndian.putInt(data, " + (this.offset + 4) + " + offset, " + javaFieldName + ");";
        } else if (javaType.equals("byte")) {
            result = "data[ " + (this.offset + 4) + " + offset ] = " + javaFieldName + ";";
        } else if (javaType.equals("double")) {
            result = "LittleEndian.putDouble(data, " + (this.offset + 4) + " + offset, " + javaFieldName + ");";
        } else if (javaType.equals("ExcelString")) {
            result = "StringUtil.putUncompressedUnicode(getFontName(), data, 20 + offset);";
        }
        try {
            this.offset += Integer.parseInt(size);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        return result;
    }

    public String calcSize(int fieldNumber, String fieldName, String size, String type) {
        String result;
        String string = result = fieldNumber == 1 ? "" : " + ";
        if ("var".equals(size)) {
            String javaFieldName = RecordUtil.getFieldName(fieldNumber, fieldName, 0);
            return result + javaFieldName + ".sizeInBytes()";
        }
        if ("varword".equals(size)) {
            String javaFieldName = RecordUtil.getFieldName(fieldNumber, fieldName, 0);
            return result + javaFieldName + ".length * 2 + 2";
        }
        return result + size;
    }
}

