/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class LegendRecord
extends Record {
    public static final short sid = 4117;
    private int field_1_xPosition;
    private int field_2_yPosition;
    private int field_3_xSize;
    private int field_4_ySize;
    private byte field_5_type;
    public static final byte TYPE_BOTTOM = 0;
    public static final byte TYPE_CORNER = 1;
    public static final byte TYPE_TOP = 2;
    public static final byte TYPE_RIGHT = 3;
    public static final byte TYPE_LEFT = 4;
    public static final byte TYPE_NOT_DOCKED = 7;
    private byte field_6_spacing;
    public static final byte SPACING_CLOSE = 0;
    public static final byte SPACING_MEDIUM = 1;
    public static final byte SPACING_OPEN = 2;
    private short field_7_options;
    private BitField autoPosition = new BitField(1);
    private BitField autoSeries = new BitField(2);
    private BitField autoPosX = new BitField(4);
    private BitField autoPosY = new BitField(8);
    private BitField vert = new BitField(16);
    private BitField containsDataTable = new BitField(32);

    public LegendRecord() {
    }

    public LegendRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public LegendRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4117) {
            throw new RecordFormatException("Not a Legend record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_xPosition = LittleEndian.getInt(data, 0 + offset);
        this.field_2_yPosition = LittleEndian.getInt(data, 4 + offset);
        this.field_3_xSize = LittleEndian.getInt(data, 8 + offset);
        this.field_4_ySize = LittleEndian.getInt(data, 12 + offset);
        this.field_5_type = data[16 + offset];
        this.field_6_spacing = data[17 + offset];
        this.field_7_options = LittleEndian.getShort(data, 18 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Legend]\n");
        buffer.append("    .xPosition            = ").append("0x").append(HexDump.toHex(this.getXPosition())).append(" (").append(this.getXPosition()).append(" )\n");
        buffer.append("    .yPosition            = ").append("0x").append(HexDump.toHex(this.getYPosition())).append(" (").append(this.getYPosition()).append(" )\n");
        buffer.append("    .xSize                = ").append("0x").append(HexDump.toHex(this.getXSize())).append(" (").append(this.getXSize()).append(" )\n");
        buffer.append("    .ySize                = ").append("0x").append(HexDump.toHex(this.getYSize())).append(" (").append(this.getYSize()).append(" )\n");
        buffer.append("    .type                 = ").append("0x").append(HexDump.toHex(this.getType())).append(" (").append(this.getType()).append(" )\n");
        buffer.append("    .spacing              = ").append("0x").append(HexDump.toHex(this.getSpacing())).append(" (").append(this.getSpacing()).append(" )\n");
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )\n");
        buffer.append("         .autoPosition             = ").append(this.isAutoPosition()).append('\n');
        buffer.append("         .autoSeries               = ").append(this.isAutoSeries()).append('\n');
        buffer.append("         .autoPosX                 = ").append(this.isAutoPosX()).append('\n');
        buffer.append("         .autoPosY                 = ").append(this.isAutoPosY()).append('\n');
        buffer.append("         .vert                     = ").append(this.isVert()).append('\n');
        buffer.append("         .containsDataTable        = ").append(this.isContainsDataTable()).append('\n');
        buffer.append("[/Legend]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4117);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putInt(data, 4 + offset, this.field_1_xPosition);
        LittleEndian.putInt(data, 8 + offset, this.field_2_yPosition);
        LittleEndian.putInt(data, 12 + offset, this.field_3_xSize);
        LittleEndian.putInt(data, 16 + offset, this.field_4_ySize);
        data[20 + offset] = this.field_5_type;
        data[21 + offset] = this.field_6_spacing;
        LittleEndian.putShort(data, 22 + offset, this.field_7_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 24;
    }

    public short getSid() {
        return 4117;
    }

    public int getXPosition() {
        return this.field_1_xPosition;
    }

    public void setXPosition(int field_1_xPosition) {
        this.field_1_xPosition = field_1_xPosition;
    }

    public int getYPosition() {
        return this.field_2_yPosition;
    }

    public void setYPosition(int field_2_yPosition) {
        this.field_2_yPosition = field_2_yPosition;
    }

    public int getXSize() {
        return this.field_3_xSize;
    }

    public void setXSize(int field_3_xSize) {
        this.field_3_xSize = field_3_xSize;
    }

    public int getYSize() {
        return this.field_4_ySize;
    }

    public void setYSize(int field_4_ySize) {
        this.field_4_ySize = field_4_ySize;
    }

    public byte getType() {
        return this.field_5_type;
    }

    public void setType(byte field_5_type) {
        this.field_5_type = field_5_type;
    }

    public byte getSpacing() {
        return this.field_6_spacing;
    }

    public void setSpacing(byte field_6_spacing) {
        this.field_6_spacing = field_6_spacing;
    }

    public short getOptions() {
        return this.field_7_options;
    }

    public void setOptions(short field_7_options) {
        this.field_7_options = field_7_options;
    }

    public void setAutoPosition(boolean value) {
        this.field_7_options = this.autoPosition.setShortBoolean(this.field_7_options, value);
    }

    public boolean isAutoPosition() {
        return this.autoPosition.isSet(this.field_7_options);
    }

    public void setAutoSeries(boolean value) {
        this.field_7_options = this.autoSeries.setShortBoolean(this.field_7_options, value);
    }

    public boolean isAutoSeries() {
        return this.autoSeries.isSet(this.field_7_options);
    }

    public void setAutoPosX(boolean value) {
        this.field_7_options = this.autoPosX.setShortBoolean(this.field_7_options, value);
    }

    public boolean isAutoPosX() {
        return this.autoPosX.isSet(this.field_7_options);
    }

    public void setAutoPosY(boolean value) {
        this.field_7_options = this.autoPosY.setShortBoolean(this.field_7_options, value);
    }

    public boolean isAutoPosY() {
        return this.autoPosY.isSet(this.field_7_options);
    }

    public void setVert(boolean value) {
        this.field_7_options = this.vert.setShortBoolean(this.field_7_options, value);
    }

    public boolean isVert() {
        return this.vert.isSet(this.field_7_options);
    }

    public void setContainsDataTable(boolean value) {
        this.field_7_options = this.containsDataTable.setShortBoolean(this.field_7_options, value);
    }

    public boolean isContainsDataTable() {
        return this.containsDataTable.isSet(this.field_7_options);
    }
}

