/*
 * 쐬: 2003/10/23
 *
 * xls2src main
 * 
 */
package jp.ne.dti.venus.okazaki.xls2src;

import java.io.*;

import java.util.HashMap;
import java.util.ArrayList;

import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HSSFSheet;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;

import org.apache.commons.cli.*;

/**
 * @author kenichi_home
 *
 * xls2src main
 * 
 */
public class Xls2src {
	

	public static void main(String[] args) throws IOException,Exception
	{
		String xlsFileName="data/workbook.xls";
		String templateFolderName="template";
		String destDirName="destDir";
		
		Options options = new Options();
		options.addOption(OptionBuilder
					  .withArgName("xlsFileName")
					  .hasArg()
					  .withDescription(  "݌vXlst@C(ftHg:data/workbook.xls)" )
					  .create( "f") );

		options.addOption(OptionBuilder
					  .withArgName("templateFolderName")
					  .hasArg()
					  .withDescription(  "ev[gtH_(ftHg:template)" )
					  .create( "t") );

		options.addOption(OptionBuilder
					  .withArgName("distFolderName")
					  .hasArg()
					  .withDescription(  "otH_(ftHg:destDir)" )
					  .create( "d") );
					  		  
		options.addOption("h", false, "wv\");


		CommandLineParser parser = new BasicParser();
		CommandLine cmd;
		try {
			cmd = parser.parse(options, args); 
		} catch (ParseException pe) {
			displayHelp(options );


			return;
		}
		
		if (cmd.hasOption("h")) {		
			displayHelp(options );
			return;
		}
		
		if (cmd.hasOption("f")) {
			xlsFileName = cmd.getOptionValue('f');
		}
		
		if (cmd.hasOption("t")) {
			templateFolderName = cmd.getOptionValue('t');
		}
		
		if (cmd.hasOption("d")) {
			destDirName = cmd.getOptionValue('d');
		}

		
		ArrayList modelCollection = getModelCollection(xlsFileName);
		excute( templateFolderName ,modelCollection, destDirName);
		

	}
	private static void displayHelp(Options options ){
		HelpFormatter formatter = new HelpFormatter();
		formatter.printHelp( "xls2src", options, true);
	
	} 
	private static ArrayList getModelCollection(String xlsFileName) throws IOException{
		ArrayList modelCollection = new ArrayList();
		String sheetName;

		POIFSFileSystem fs      =
				new POIFSFileSystem(new FileInputStream(xlsFileName));
		HSSFWorkbook wb = new HSSFWorkbook(fs);	//[NubN̎擾

		//ڎ̎擾
		HSSFSheet indexSheet = wb.getSheet("index");
		Table indexTable = new Table( indexSheet);
		
		//CMR̎擾
		HSSFSheet cmrInfoSheet = wb.getSheet("CMR");	
		Table cmrInfoTable = new Table( cmrInfoSheet);
						
		for( int i = 0 ; i < indexTable.getRows().size()   ; i++ ){
			HashMap info  = (HashMap)indexTable.getRows().get(i);
			info.get("sheet");
			
			//V[g̎擾
			HSSFSheet sheet = wb.getSheet( (String)info.get("sheet") );
			Table table = new Table( sheet);
			
			//f̐
			Model model = new Model();
			model.setInfo(info);
			model.setRows(table.getRows() );
			model.setCmrInfo(cmrInfoTable.getRows() );
				
			
			System.out.println("class" + info.get("NX") + i );
			modelCollection.add( model );
		}
		
		return modelCollection;
		
	}
	
	/**
	 * Java\[X̎s
	 * 
	 * @throws Exception
	 */
	public static void excute(String templateFolderName , ArrayList modelCollection ,String dirName) throws Exception {

		Util util = new Util();
		Util u = new Util();
		Velocity.init("velocity.properties");
		VelocityContext context = new VelocityContext();
		Template template = Velocity.getTemplate(templateFolderName +"/CMP.vm", "Shift_JIS");

		for (int i = 0; i < modelCollection.size() ; i++) {
			Model model = (Model)modelCollection.get(i);
			
			context.put("info"		, model.getInfo() );
			context.put("rows"		, model.getRows() );
			context.put("cmrInfo"	, model.getCmrInfo() );
			context.put("util", util );
			context.put("u", u );	
			
			StringWriter writer = new StringWriter();
			template.merge(context, writer);
			FileWriter fileWriter;
			write( model, dirName , writer);
		}
	}

	/**
	 * t@Cɏo
	 * 
	 * @param beanData - f[^NX̏
	 * @param writer - Velocityɂăev[gƃ}[WꂽC^[
	 * @throws IOException
	 */
	private static void write(Model model , String dirName ,StringWriter writer ) throws IOException {
		FileWriter fileWriter = null;
		
		//pbP[W̃fBNg𐶐
		String packageDirName = dirName + "/" +((String)model.getInfo().get( "pbP[W")).replace( '.' , '/' );

		// pbP[W̃fBNg̐
		File file = new File(packageDirName);
		file.mkdirs();
				
		try {
			fileWriter = new FileWriter( packageDirName + "/" + model.getInfo().get( "name") + "Bean.java");
			fileWriter.write(writer.toString());
		} finally {
			if (fileWriter != null) {
				fileWriter.close();
			}
		}
	}
	
	
}
