/*
 * 쐬: 2003/10/23
 *
 * xlst@Csheet̏擾NX
 * 
 */
package jp.ne.dti.venus.okazaki.xls2src;

import java.util.HashMap;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFCell;

/**
 * @author kenichi_home
 *
 * xlst@Csheet̏擾NX
 * 
 */
public class Table {

	public final static int FIELD_NAMES_ROW = 0;
	private ArrayList rows;
	
	public Table(HSSFSheet sheet ){
		rows = new ArrayList();
		HSSFRow row;
		ArrayList fieldNames;
		
		fieldNames = getFieldNames(sheet.getRow(FIELD_NAMES_ROW) );
		
		for(int i = (FIELD_NAMES_ROW + 1 )  ; i < sheet.getLastRowNum() + 1 ; i++ ){
			row = sheet.getRow(i);
			rows.add( getRowData( fieldNames , row ) );
		}
		
	}
	private ArrayList getFieldNames(HSSFRow row){
		ArrayList ret = new ArrayList();
		
		for(short i =0 ; i < row.getLastCellNum() ; i++  ){
			HSSFCell cell = row.getCell(i);
			
			System.out.println("FieldName[" + getCellSring( cell ) +"]"  );
			ret.add( getCellSring( cell ) );
		}
		return ret;
	}
	
	private HashMap getRowData(ArrayList fieldNames , HSSFRow row){
		HashMap ret = new HashMap();
		String value="";
		
		for(short i =0 ; i < fieldNames.size() ; i++  ){
			value = getCellSring( row.getCell(i) );
			
			ret.put(fieldNames.get(i) , value )	;	

			System.out.println("field[" + fieldNames.get(i)  + "] value[" + value +"]"  );
		}
		System.out.println("");
		return ret;
	}
	

	/**
	 * @return
	 */
	public ArrayList getRows() {
		return rows;
	}
	
	public static String getCellSring(HSSFCell cell){

	String sRet="";
	if( cell.getCellType() == HSSFCell.CELL_TYPE_STRING ){
			sRet = cell.getStringCellValue();
		}else if( cell.getCellType() == HSSFCell.CELL_TYPE_NUMERIC ){
			sRet = String.valueOf( cell.getNumericCellValue() );
		}	
		return sRet.trim() ;
	}

}
