/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.model.hdftypes;

import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.util.LittleEndian;

public class TableCellDescriptor
implements HDFType {
    boolean _fFirstMerged;
    boolean _fMerged;
    boolean _fVertical;
    boolean _fBackward;
    boolean _fRotateFont;
    boolean _fVertMerge;
    boolean _fVertRestart;
    short _vertAlign;
    short[] _brcTop = new short[2];
    short[] _brcLeft = new short[2];
    short[] _brcBottom = new short[2];
    short[] _brcRight = new short[2];

    static TableCellDescriptor convertBytesToTC(byte[] array, int offset) {
        TableCellDescriptor tc = new TableCellDescriptor();
        short rgf = LittleEndian.getShort((byte[])array, (int)offset);
        tc._fFirstMerged = (rgf & 1) > 0;
        tc._fMerged = (rgf & 2) > 0;
        tc._fVertical = (rgf & 4) > 0;
        tc._fBackward = (rgf & 8) > 0;
        tc._fRotateFont = (rgf & 0x10) > 0;
        tc._fVertMerge = (rgf & 0x20) > 0;
        tc._fVertRestart = (rgf & 0x40) > 0;
        tc._vertAlign = (short)((rgf & 0x180) >> 7);
        tc._brcTop[0] = LittleEndian.getShort((byte[])array, (int)(offset + 4));
        tc._brcTop[1] = LittleEndian.getShort((byte[])array, (int)(offset + 6));
        tc._brcLeft[0] = LittleEndian.getShort((byte[])array, (int)(offset + 8));
        tc._brcLeft[1] = LittleEndian.getShort((byte[])array, (int)(offset + 10));
        tc._brcBottom[0] = LittleEndian.getShort((byte[])array, (int)(offset + 12));
        tc._brcBottom[1] = LittleEndian.getShort((byte[])array, (int)(offset + 14));
        tc._brcRight[0] = LittleEndian.getShort((byte[])array, (int)(offset + 16));
        tc._brcRight[1] = LittleEndian.getShort((byte[])array, (int)(offset + 18));
        return tc;
    }
}

