/**
 * ŏ̒:: gDC[
 * |Wg:: $Id$
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _XERCESC_UTILS_XMLCH2CHAR_TRANSCODER_HPP_
#define _XERCESC_UTILS_XMLCH2CHAR_TRANSCODER_HPP_

#include <xercesc/util/TransService.hpp>
#include <xercesc/util/XMLString.hpp>

#include <xercesc_utils/CharPtr.hpp>

namespace xercesc_utils {

/**
 * XMLCh*w肵R[hchar*֕ϊ邽߂̃bp[NXłD
 * ̃NX͕ϊʂ̃obt@̊mہEbsO܂B
 */
class XMLCh2CharTranscoder {
#if XERCES_VERSION_MAJOR >= 3
	typedef XMLSize_t SIZE_T;
#else
	typedef unsigned int SIZE_T;
#endif

private:
	/**
	 * gXR[_łB
	 */
	xercesc::XMLTranscoder* transcoder_;

	/**
	 * transcodeۂɎgpobt@̃TCYłB
	 */
	SIZE_T bufferSize_;

	/**
	 * transcodeۂɕKvƂȂobt@łB
	 */
	XMLByte* buffer_;

public:
	/**
	 * gXR[_\z܂B
	 *
	 * @param encoding GR[fBOw肵܂B
	 * @param bufferSize gXR[hۂɎgpobt@̃TCYw肵܂B
	 */
	explicit XMLCh2CharTranscoder(const char* const encoding, unsigned int bufferSize = 1024) :
	bufferSize_(bufferSize), buffer_(new XMLByte[bufferSize + 4]) {
    xercesc::XMLTransService::Codes failReason;
    transcoder_ = xercesc::XMLPlatformUtils::fgTransService->makeNewTranscoderFor(
		encoding, failReason, bufferSize_
#if _XERCES_VERSION == 20300
		, XMLPlatformUtils::fgMemoryManager
#endif
		);
	}

	/**
	 * gXR[_j܂B
	 */
	~XMLCh2CharTranscoder() {
		delete buffer_;
		delete transcoder_;
	}


private:
	// Rs[Ƒ֎~܂B
	explicit XMLCh2CharTranscoder(const XMLCh2CharTranscoder& transcoder);
	XMLCh2CharTranscoder& operator=(const XMLCh2CharTranscoder& transcoder);

public:
	/**
	 * R[hϊ܂B
	 */
	CharPtr transcode(const XMLCh* const toTranscode) const {
		SIZE_T count = xercesc::XMLString::stringLen(toTranscode);
		const XMLCh* srcPtr = toTranscode;
		const XMLCh* endPtr = toTranscode + count;
		SIZE_T charsEaten;
		CharPtr result;

		while (srcPtr < endPtr) {
			const SIZE_T srcCount = endPtr - srcPtr;
			const SIZE_T srcChars = srcCount > bufferSize_ ? bufferSize_ : srcCount;

			const SIZE_T outBytes = transcoder_->transcodeTo(
				srcPtr, srcChars, buffer_, bufferSize_, charsEaten, xercesc::XMLTranscoder::UnRep_Throw
			);

			if (outBytes) {
				buffer_[outBytes] = buffer_[outBytes + 1] = buffer_[outBytes + 2] = buffer_[outBytes + 3] = 0;
			}

			srcPtr += charsEaten;
			result += (char*) buffer_;
		}

		return result;
	}

};

}  // namespace xercesc_utils

#endif
