/**
 * ŏ̒:: gDC[
 * |Wg:: $Id$
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _XERCESC_UTILS_CHAR_PTR_HPP_
#define _XERCESC_UTILS_CHAR_PTR_HPP_

#include <iostream>

#include <xercesc/util/XMLString.hpp>

namespace xercesc_utils {

/**
 * char*̕Ǘ邽߂̃bp[łB
 * ̐Lł܂B
 */
class CharPtr {
private:
  char* buffer_;

public:
  CharPtr() : buffer_(new char[1]) {
    buffer_[0]=0;
  }

  explicit CharPtr(const char* const buffer) {
    copy(buffer);
  }

  ~CharPtr() {
    delete [] buffer_;
  }

  CharPtr(const CharPtr& ptr) {
    if(this!=&ptr) {
      copy(ptr.buffer_);
    }
  }

  CharPtr& operator=(const CharPtr& ptr) {
    if(this!=&ptr) {
      copy(ptr.buffer_);
    }
    return *this;
  }

public:
  /**
   * char*ւ̃LXgZqłB
   */
  operator const char* const () const {
    return buffer_;
  }

private:
  void copy(const char* const buffer) {
    buffer_=new char[xercesc::XMLString::stringLen(buffer)+1];
    xercesc::XMLString::copyString(buffer_, buffer);
  }

public:
  CharPtr& operator+=(const char* const ptr) {
    const unsigned int size=xercesc::XMLString::stringLen(buffer_)+xercesc::XMLString::stringLen(ptr);
    char* newBuffer=new char[size+1];
    xercesc::XMLString::copyString(newBuffer, buffer_);
    xercesc::XMLString::catString(newBuffer, ptr);
    delete [] buffer_;
    buffer_ = newBuffer;

    return *this;
  }
};

/**
 * Xg[֕o͂܂B
 */
inline std::ostream& operator<<(std::ostream& stream, const CharPtr& buffer) {
  return stream << (const char* const) buffer;
}

}  // namespace xercesc_utils

#endif
