<?php
/**
 * @file
 * @package xdbase
 * @version $Id: xdbase_googlemap_block.php,v 1.2 2012/03/05 11:36:04 bluemelon Exp $
 */

if (!defined('_XDBASE_GOOGLEMAP_BLOCK_LOADED'))
{

define('_XDBASE_GOOGLEMAP_BLOCK_LOADED', 1);

include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/include/function.php';
include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/language/'.$GLOBALS['xoopsConfig']['language'].'/blocks.php';
include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/language/'.$GLOBALS['xoopsConfig']['language'].'/main.php';


function b_xdbase_googlemap_block_show($options)
{
	$mydirname = $options[0];
	$data_handler =& xdbaseGetModuleHandler('data', $mydirname);
	$cat_handler =& xdbaseGetModuleHandler('cat', $mydirname);
	$cat_handler->setTree($cat_handler->getCriteria());

	$gmapkey = $options[1];
	$height = $options[2];
	$latitude = $options[3];
	$longitude = $options[4];
	$zoom = $options[5];

	$limit = $options[6];
	$sort = $data_handler->getSort($options[7]);
	$order = $data_handler->getOrder($options[8]);
	$cid = $options[9];
	$include_subcat = $options[10];

	$block = array();

	$criteria =& $data_handler->getCriteria();

	if ($cid != '')
	{
		$catCriteria = new Xdbase_CriteriaCompo();
		$catCriteria->add(new Xdbase_Criteria('cid', $cid));
		if ($include_subcat)
		{
			$cid_array =& $cat_handler->getAllChildId($cid);
			if (count($cid_array) > 0)
			{
				foreach ($cid_array as $chcid)
				{
					$catCriteria->add(new Xdbase_Criteria('cid', $chcid), 'OR');
				}
			}
		}
		$criteria->add($catCriteria);
	}

	$criteria->setOrder($order);
	$criteria->setSort($sort);
	$criteria->setLimit($limit);

	$dataObjectArray =& $data_handler->getObjects($criteria);


	$count = count($dataObjectArray);
	$data = array();
	for ($i = 0; $i < $count; $i++)
	{
		$data[$i] = $dataObjectArray[$i];
	}

	$block['data'] = $data;
	$block['gmapkey'] = $gmapkey;
	$block['height'] = $height;
	$block['latitude'] = $latitude;
	$block['longitude'] = $longitude;
	$block['zoom'] = $zoom;
	$block['limit'] = $limit;
	$block['mydirname'] = $mydirname;
	$block['cat_handler'] = $cat_handler;
	

	return $block;
}


function b_xdbase_googlemap_block_edit($options)
{
	$form = '';
	$form .= '<input type="hidden" name="options[0]" value="'.$options[0].'" />';
	$form .= _MB_XDBASE_GMAPKEY.'&nbsp;:&nbsp;<input type="text" name="options[1]" value="'.$options[1].'" /><br />';
	$form .= _MB_XDBASE_HEIGHT.'&nbsp;:&nbsp;<input type="text" name="options[2]" value="'.$options[2].'" size="10" /><br />';
	$form .= _MB_XDBASE_LATITUDE.'&nbsp;:&nbsp;<input type="text" name="options[3]" value="'.$options[3].'" size="10" /><br />';
	$form .= _MB_XDBASE_LONGITUDE.'&nbsp;:&nbsp;<input type="text" name="options[4]" value="'.$options[4].'" size="10" /><br />';
	$form .= _MB_XDBASE_ZOOM.'&nbsp;:&nbsp;<input type="text" name="options[5]" value="'.$options[5].'" size="6" /><br />';
	$form .= _MB_XDBASE_LIMIT.'&nbsp;:&nbsp;<input type="text" name="options[6]" value="'.$options[6].'" size="6" /><br />';
	$form .= _MB_XDBASE_SORT.'&nbsp;:&nbsp;'.xdbaseBlockRenderColSelect(7, $options).'<br />';
	$form .= _MB_XDBASE_ORDER.'&nbsp;:&nbsp;'.xdbaseBlockRenderOrderSelect(8, $options).'<br />';
	$form .= _MB_XDBASE_CATEGORY.'&nbsp;:&nbsp;'.xdbaseBlockRenderCatSelect(9, $options).'&nbsp;';
	$form .= _MB_XDBASE_INCLUDESUBCAT.'&nbsp;'.xdbaseBlockRenderYesNoRadioButton(10, $options).'<br />';

	return $form;
}


}

?>
