<?php
/**
 * @file
 * @package xdbase
 * @version $Id: module_icon.php,v 1.5 2011/10/10 07:45:14 bluemelon Exp $
 */

$icon_cache_limit = 3600 ; // default 3600sec == 1hour

session_cache_limiter('public');
header("Expires: ".date('r',intval(time()/$icon_cache_limit)*$icon_cache_limit+$icon_cache_limit));
header("Cache-Control: public, max-age=$icon_cache_limit");
header("Last-Modified: ".date('r',intval(time()/$icon_cache_limit)*$icon_cache_limit));
header("Content-type: image/png");


// for Cube 2.1
if (defined('XOOPS_CUBE_LEGACY'))
{
	$icon_fullpath = 'cube_module_icon.png';
	$icon_name = 'cube_module_icon.png';
}
else
{
	$icon_name = 'module_icon.png';
}

if (file_exists($mydirpath.'/images/'.$icon_name))
{
	$use_custom_icon = true;
	$icon_fullpath = $mydirpath.'/images/'.$icon_name;
}
else
{
	$use_custom_icon = false;
	$icon_fullpath = dirname(__FILE__).'/'.$icon_name;
}

if (!$use_custom_icon && function_exists('imagecreatefrompng') && function_exists('imagecolorallocate') && function_exists('imagestring') && function_exists('imagepng'))
{
	$im = imagecreatefrompng($icon_fullpath);
	$color = imagecolorallocate( $im, 10, 10, 9);
	if (defined('XOOPS_CUBE_LEGACY'))
	{
		$x = ((127 - 6 * strlen($mydirname)) / 2) + 16;
		$y = 5;
	}
	else
	{
		$x = (92 - 6 * strlen($mydirname)) / 2;
		$y = 34;
	}
	imagestring($im, 2, $x, $y, $mydirname, $color);
	imagepng($im);
	imagedestroy($im);
}
else
{
	readfile($icon_fullpath);
}


//require_once $mytrustdirpath.'/xoops_version.php';
/*
include_once $mydirpath.'/images/IconGenerator.php';

$icon = new Suin_IconGenerator($mydirname);
if ( $icon->isAvailableGenerator() ) {
	$icon->setIconPath($mydirpath.'/images/cube_module_icon.png');
	$icon->prepareIcon();
	$icon->setFontColor(0, 0, 0);
	$icon->setPosition(38, 6);
	$icon->putString(strtolower($mydirname));
	$icon->setFontColor(100, 100, 100);
	$icon->setPosition(38, 13);
//	$icon->putString(strtolower(sprintf('%.2f / %s', $modversion['version'], $mytrustdirname)));
	$icon->renderIcon();
} else {
	$icon->setIconPath($mydirpath.'/images/cube_module_icon.png');
	$icon->sendCotentType();
	$icon->readIconFile();
}
*/
?>