<?php
class Suin_IconGenerator
{
	protected $character = array();
	protected $iconPath = 'module_icon.png';
	protected $iconImg = null;
	protected $fontColor = null;
	protected $x = 0;
	protected $y = 0;
	protected $contentType = 'image/png';
	protected $mydirname = null;

	function __construct($mydirname)
	{
		$this->mydirname = $mydirname;
		$this->_setCharacterMap();
	}

	public function setFontColor($r = 0, $g = 0, $b = 0)
	{
		$this->fontColor = imagecolorallocate($this->iconImg, $r, $g, $b); // black
	}

	public function setPosition($x, $y)
	{
		$this->x = $x;
		$this->y = $y;
	}

	public function setIconPath($path)
	{
		$this->iconPath = $path;
	}

	public function setContentType($contentType)
	{
		$this->contentType = $contentType;
	}

	protected function _setCharacterMap()
	{
		/*
			*		: dot
			/		: break line
			no mark	: blank
		*/
		$this->character['a'] = '****/*  */****/*  */*  *';
		$this->character['b'] = '****/*  */*** /*  */****';
		$this->character['c'] = '****/*   /*   /*   /****';
		$this->character['d'] = '*** /*  */*  */*  */*** ';
		$this->character['e'] = '****/*   /*** /*   /****';
		$this->character['f'] = '****/*   /*** /*   /*   ';
		$this->character['g'] = '****/*   /* **/*  */****';
		$this->character['h'] = '*  */*  */****/*  */*  *';
		$this->character['i'] = '*/*/*/*/*';
		$this->character['j'] = '****/   */   */*  */****';
		$this->character['k'] = '*  */* * /**  /* * /*  *';
		$this->character['l'] = '*   /*   /*   /*   /****';
		$this->character['m'] = '*****/* * */* * */* * */* * *';
		$this->character['n'] = '*  */** */* **/*  */*  *';
		$this->character['o'] = '****/*  */*  */*  */****';
		$this->character['p'] = '****/*  */****/*   /*   ';
		$this->character['q'] = '****/*  */*  */* **/****';
		$this->character['r'] = '****/*  */*** /*  */*  *';
		$this->character['s'] = '****/*   /****/   */****';
		$this->character['t'] = '*****/  *  /  *  /  *  /  *  ';
		$this->character['u'] = '*  */*  */*  */*  */****';
		$this->character['v'] = '*   */*   */*   */ * * /  *  ';
		$this->character['w'] = '* * */* * */* * */* * */*****';
		$this->character['x'] = '*   */ * * /  *  / * * /*   *';
		$this->character['y'] = '*  */*  */****/  * /  * ';
		$this->character['z'] = '****/  * / *  /*   /****';
		$this->character['1'] = ' */**/ */ */ *';
		$this->character['2'] = '****/   */****/*   /****';
		$this->character['3'] = '****/   */ ***/   */****';
		$this->character['4'] = '*  */*  */****/   */   *';
		$this->character['5'] = '****/*   /****/   */****';
		$this->character['6'] = '****/*   /****/*  */****';
		$this->character['7'] = '****/*  */   */   */   *';
		$this->character['8'] = '****/*  */****/*  */****';
		$this->character['9'] = '****/*  */****/   */****';
		$this->character['0'] = '****/*  */*  */*  */****';
		$this->character['.'] = ' / / / /*';
		$this->character['_'] = '   /   /   /   /***';
		$this->character['-'] = '   /   /***/   /   ';
		$this->character['/'] = '  * /  * /  *  / *  / *  ';
		$this->character[' '] = ' / / / / ';
	}

	protected function _changeMapToArray($c)
	{
		$character = $this->_getCharacter($c);
		$length = strlen($character);
		$ret = array();
		$xDefault = $this->x;
		$yDefault = $this->y;
		for ( $i = 0; $i <= $length; $i++ ) {
			switch ( $character[$i] ) {
			case '*' :
				$ret[] = array('x' => $this->x, 'y' => $this->y);
			case ' ' :
				$this->x++;
				break;
			case '/' :
				$this->x = $xDefault;
				$this->y++;
				break;
			}
		}
		$this->y = $yDefault;
		return $ret;
	}

	protected function _getCharacter($c)
	{
		if ( isset($this->character[$c]) ) {
			return $this->character[$c];
		} else {
			return $this->character[' '];
		}
	}

	public function prepareIcon()
	{
		$forground = $this->getForground();
		$background = $this->getBackground();
		
		imagecolortransparent($forground, imagecolorclosest($forground, 255,0,255));
		imagecopymerge($background, $forground, 0, 0, 0, 0, 127, 24, 100);
		$this->iconImg = $background;
	}

	protected function getForground()
	{
		return imagecreatefrompng($this->iconPath);
	}

	protected function getBackground()
	{
		mt_srand(sprintf('%u', crc32($this->mydirname)));
		$background = imagecreatetruecolor(127, 24);
		$bgc = imagecolorallocate($background, mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
		imagefilledrectangle($background, 0, 0, 127, 24, $bgc);
		return $background;
	}

	public function putString($str)
	{
		$legnth = strlen($str);
		for ( $i = 0; $i <= $legnth; $i++ ) {
			$this->_putCharacter($str[$i]);
		}
	}

	protected function _putCharacter($c)
	{
		$this->x++;
		$map = $this->_changeMapToArray($c);
		foreach ( $map as $position ) {
			imagesetpixel($this->iconImg, $position['x'], $position['y'], $this->fontColor);
		}
	}

	public function renderIcon()
	{
		$this->sendCotentType();
		$this->saveIcon();
		$this->deleteIcon();
	}

	public function sendCotentType()
	{
		header('Content-type: '.$this->contentType);
	}

	public function saveIcon($savePath = null)
	{
		imagepng($this->iconImg, $savePath);
	}

	public function deleteIcon($savePath = null)
	{
		imagedestroy($this->iconImg, $savePath);
	}

	public function addCharacter($c, $data)
	{
		$this->character[$c] = $data;
	}

	public function isAvailableGenerator()
	{
		if ( function_exists('imagecreatefrompng') and function_exists('imagecolorallocate') and function_exists('imagesetpixel') and function_exists('imagepng') and function_exists('imagedestroy') ) {
			return true;
		} else {
			return false;
		}
	}

	public function readIconFile()
	{
		readfile($this->iconPath);
	}
}
?>