<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataEditAction.class.php,v 1.14 2011/10/10 07:45:13 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_Admin_DataEditAction extends Xdbase_AbstractEditAction
{
	/**
	 * @protected
	 */
	function _getId()
	{
		return xdbaseGetRequest('did');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_data');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);
		$this->mTpl->assign('handler', $this->mObjectHandler);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/data_edit.html');
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _MD_XDBASE_MESSAGE_DBUPDATE_SUCCESSED);
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=DataList', 3, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=DataList');
	}

	function _doExecute()
	{
		if ($this->mObjectHandler->insert($this->mObject))
		{
			// image file upload
			$this->saveImageFile();
			$this->saveTag();
			$this->setNotification();
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
		return XDBASE_FRAME_VIEW_ERROR;
	}


	function saveTag()
	{
		$dataHandler =& $this->_getHandler();
		if ($dataHandler->getActive('tag'))
//		if ($this->mActionForm->mHasTag)
		{
			$dataHandler->saveTag();
		}
	}

	function saveImageFile()
	{
		// save image01
		if ($this->mActionForm->mFormImage1 != null)
		{
			// save image01 thumbnail
			if (_MD_XDBASE_CONST_CREATETHUMB)
			{
				if ($err = $this->mActionForm->mFormImage1->saveResizedImage(_MD_XDBASE_CONST_THUMBS_PATH, _MD_XDBASE_CONST_MAXTHUMBSIZE))
				{
					$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
				}
			}

			if ($err = $this->mActionForm->mFormImage1->saveImage(_MD_XDBASE_CONST_PHOTOS_PATH))
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
			}
		}

		// save image02
		if ($this->mActionForm->mFormImage2 != null)
		{
			// save image02 thumbnail
			if (_MD_XDBASE_CONST_CREATETHUMB)
			{
				if ($err = $this->mActionForm->mFormImage2->saveResizedImage(_MD_XDBASE_CONST_THUMBS_PATH, _MD_XDBASE_CONST_MAXTHUMBSIZE))
				{
					$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
				}
			}

			if ($err = $this->mActionForm->mFormImage2->saveImage(_MD_XDBASE_CONST_PHOTOS_PATH))
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
			}
		}
	}

	function saveUploadFile()
	{
		if ($this->mActionForm->mFormFile1 != null)
		{
			// save file
			if (!$this->mActionForm->mFormFile1->saveAs(_MD_XDBASE_CONST_FILES_PATH))
			{
				return XDBASE_FRAME_VIEW_ERROR;
			}

			if ($this->mActionForm->mOldFileName1 != null)
			{
				if (file_exists(_MD_XDBASE_CONST_FILES_PATH.'/'.$this->mActionForm->mOldFileName1))
				{
					@unlink(_MD_XDBASE_CONST_FILES_PATH.'/'.$this->mActionForm->mOldFileName1);
				}
			}
		}
	}

	// Notification
	function setNotification()
	{
		if ($this->mObject->get('status') == 1)
		{
			$notificationHandler =& xoops_gethandler('notification');
			$tags = array();
			$module =& $this->mController->mXoopsModule;
			$tags['DATA_TITLE'] = $this->mObject->getShow('title');
			$tags['DATA_URL']  = XOOPS_URL.'/modules/'. $module->getVar('dirname').'/index.php?action=DataView&amp;did='.$this->mObject->getShow('did');

			if ($this->mActionForm->mIsNew == false && $this->mActionForm->mOldStatus == 0)
			{
				// Data Approved Notification
				$notificationHandler->triggerEvent('data', $this->mObject->getShow('did'), 'approve', $tags);
			}
			if ($this->mActionForm->mIsNew || $this->mActionForm->mOldStatus == 0)
			{
				// Global Notification
				$notificationHandler->triggerEvent('global', 0, 'new_data', $tags);
				// Category Notification
				$notificationHandler->triggerEvent('cat', $this->mObject->get('cid'), 'new_data', $tags);
			}
		}

	}
}

?>
