<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeDeleteAction.class.php,v 1.6 2011/10/10 07:45:13 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractDeleteAction.class.php';

class Xdbase_Data_attributeDeleteAction extends Xdbase_AbstractDeleteAction
{
	/**
	 * @protected
	 */
	function &_getId()
	{
		$ret =& xdbaseGetRequest('aid');
		return $ret;
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_attribute');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'delete_data_attribute');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->checkPerm();

//		$xoopsTpl->fetch('db:'.$this->mController->mDirname.'_data_attribute_delete.html', null, null, false);
		$GLOBALS['xoopsOption']['template_main'] = $this->mController->mDirname.'_data_attribute_delete.html';
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);

		$handler =& $this->mController->load('handler', 'data_attribute');
		$this->mTpl->assign('handler', $handler);
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'));
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'), 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'));
	}


	/**
	 * @protected
	 */
	function _doExecute()
	{
		$this->checkPerm();
		if ($this->mObjectHandler->delete($this->mObject))
		{
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
		return XDBASE_FRAME_VIEW_ERROR;
	}

	function checkPerm()
	{
		$did = $this->mObject->getShow('did');
		$dataHandler =& $this->mController->load('handler', 'data');
		$dataObject =& $dataHandler->get($did);
		$reservation = false;
		if (!is_object($this->mController->mXoopsUser))
		{
			$uid = 0;
		}
		else
		{
			$uid = $this->mController->mXoopsUser->get('uid');
		}

		if (is_object($dataObject))
		{
			$reservation = $dataObject->getShow('reservation');
		}
		if ($reservation)
		{
			if ($dataHandler->getReservationCount($did, $uid) == 0)
			{
				$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
			}
		}
		else
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
		}
	}


}

?>