<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataEditAction.class.php,v 1.8 2011/10/10 07:45:13 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_DataEditAction extends Xdbase_AbstractEditAction
{
	var $mAttributeActionForm = null;

	/**
	 * @protected
	 */
	function _getId()
	{
		return xdbaseGetRequest('did');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'edit_data');
		$this->mActionForm->prepare();
		$this->mAttributeActionForm =& $this->mController->create('form', 'edit_data_attribute');
		$this->mAttributeActionForm->prepare();
	}

	/**
	 * @public
	 */
/*
	function hasPermission()
	{
		return true;
	}
*/

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->checkPerm();

		// for bbs style post form
		if (_MD_XDBASE_CONST_LIST_TPT == 'data_list_bbs_style.html')
		{
			$pid = intval(xdbaseGetRequest('pid'));
			$parentObject =& $this->mObjectHandler->get($pid);
			$this->mTpl->assign('parentObject', $parentObject);
			$GLOBALS['xoopsOption']['template_main'] = $this->mController->mDirname.'_data_edit_bbs_style.html';
		}
		else
		{
			$GLOBALS['xoopsOption']['template_main'] = $this->mController->mDirname.'_data_edit.html';
		}

		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);

		$this->mTpl->assign('handler', $this->mObjectHandler);
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		if (_MD_XDBASE_CONST_LIST_TPT == 'data_list_bbs_style.html')
		{
			$this->mController->executeRedirect('./index.php?action=DataList', 3, _MD_XDBASE_MESSAGE_DBUPDATE_SUCCESSED);
		}
		else
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _MD_XDBASE_MESSAGE_DBUPDATE_SUCCESSED);
		}
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=DataList', 3, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=DataList');
	}


	function _doExecute()
	{
		$this->checkPerm();
//		$this->checkOverlap();
		if ($this->mObjectHandler->insert($this->mObject))
		{
			$this->saveTag();
			// image file upload
			$this->saveImageFile();
			$this->saveUploadFile();
			$this->setNotification();
			$this->checkRedirect();

			return XDBASE_FRAME_VIEW_SUCCESS;
		}

		return XDBASE_FRAME_VIEW_ERROR;
	}

	function checkRedirect()
	{
		$dataHandler =& $this->_getHandler();
		if ($this->mActionForm->mIsNew)
		{
			if (_MD_XDBASE_CONST_SUPERINSERT == false && $dataHandler->getActive('status'))
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, _MD_XDBASE_LANG_PENDING);
			}
		}
		else
		{
			if (_MD_XDBASE_CONST_SUPEREDIT == false && $dataHandler->getActive('status'))
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, _MD_XDBASE_LANG_PENDING);
			}
		}
	}

	function checkPerm()
	{
		$dataHandler =& $this->_getHandler();
		$did = $this->_getId();
		if ($this->mActionForm->mIsNew)
		{
			if (_MD_XDBASE_CONST_INSERTABLE == false && _MD_XDBASE_CONST_SUPERINSERT == false)
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, _NOPERM);
			}
		}
		else
		{
			if (!$dataHandler->checkData($did))
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, _NOPERM);
			}
			if (_MD_XDBASE_CONST_EDITABLE == false && _MD_XDBASE_CONST_SUPEREDIT == false)
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, _NOPERM);
			}
		}
	}
/*
	function checkOverlap()
	{
		if (_MD_XDBASE_CONST_OVERLAPLIMIT == 0) return;
		$dataHandler =& $this->_getHandler();
		if ($dataHandler->checkOverlap($this->mObject->getShow('s_date'),$this->mObject->getShow('e_date'), _MD_XDBASE_CONST_OVERLAPLIMIT))
		{
			$this->mController->executeRedirect('./index.php?action=DataList', 3, sprintf(_MD_XDBASE_LANG_OVERLAP_LIMIT, _MD_XDBASE_CONST_OVERLAPLIMIT));
		}
	}
*/

	function saveTag()
	{
		if ($this->mObjectHandler->getActive('tag'))
//		if ($this->mActionForm->mHasTag)
		{
			$this->mObjectHandler->saveTag();
		}
	}

	function saveImageFile()
	{
		if (!_MD_XDBASE_CONST_CANUPLOAD)
		{
			return;
		}

		// save image01
		if ($this->mActionForm->mFormImage1 != null)
		{
			// save image01 thumbnail
			if (_MD_XDBASE_CONST_CREATETHUMB)
			{
				if ($err = $this->mActionForm->mFormImage1->saveResizedImage(_MD_XDBASE_CONST_THUMBS_PATH, _MD_XDBASE_CONST_MAXTHUMBSIZE))
				{
					$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
				}
			}

			if ($err = $this->mActionForm->mFormImage1->saveImage(_MD_XDBASE_CONST_PHOTOS_PATH))
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
			}
		}

		// save image02
		if ($this->mActionForm->mFormImage2 != null)
		{
			// save image02 thumbnail
			if (_MD_XDBASE_CONST_CREATETHUMB)
			{
				if ($err = $this->mActionForm->mFormImage2->saveResizedImage(_MD_XDBASE_CONST_THUMBS_PATH, _MD_XDBASE_CONST_MAXTHUMBSIZE))
				{
					$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
				}
			}

			if ($err = $this->mActionForm->mFormImage2->saveImage(_MD_XDBASE_CONST_PHOTOS_PATH))
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
			}
		}
	}

	function saveUploadFile()
	{
		if (!_MD_XDBASE_CONST_CANUPLOAD)
		{
			return;
		}

		if ($this->mActionForm->mFormFile1 != null)
		{
			if ($err = xdbaseCheckDir(_MD_XDBASE_CONST_FILES_PATH))
			{
				$this->mController->executeRedirect('./index.php?action=DataList', 3, $err);
			}
			// save file
			if (!$this->mActionForm->mFormFile1->saveAs(_MD_XDBASE_CONST_FILES_PATH))
			{
				return XDBASE_FRAME_VIEW_ERROR;
			}
		}
	}


	// Notification
	function setNotification()
	{
		$notificationHandler =& xoops_gethandler('notification');
		$tags = array();
		$module =& $this->mController->mXoopsModule;
		$tags['DATA_TITLE'] = $this->mObject->getShow('title');
		$tags['DATA_URL']  = XOOPS_URL.'/modules/'. $module->getVar('dirname').'/index.php?action=DataView&amp;did='.$this->mObject->getShow('did');

		if ($this->mObject->get('status') == 0)
		{
			// Waiting Data Notification Admin only
			$notificationHandler->triggerEvent('global', 0, 'waiting', $tags);

			// Subscribe Notification of data approve
			if (!xdbaseIsAdmin() && !xdbaseIsGuest())
			{
				require_once XOOPS_ROOT_PATH.'/include/notification_constants.php';
				$notificationHandler->subscribe('data', $this->mObject->getShow('did'), 'approve', XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE);
			}
		}
		else
		{
			if ($this->mActionForm->mIsNew == false && $this->mActionForm->mOldStatus == 0)
			{
				// Data Approved Notification
				$notificationHandler->triggerEvent('data', $this->mObject->getShow('did'), 'approve', $tags);
			}
			if ($this->mActionForm->mIsNew || $this->mActionForm->mOldStatus == 0)
			{
				// Global Notification
				$notificationHandler->triggerEvent('global', 0, 'new_data', $tags);
				// Category Notification
				$notificationHandler->triggerEvent('cat', $this->mObject->get('cid'), 'new_data', $tags);
			}
		}
	}
}

?>
