/**
 * @file
 * @package xdbase
 * @version $Id: xdbase.js,v 1.2 2011/10/10 07:45:14 bluemelon Exp $
 */

function addEvent(elm,listener,fn){
	if (fn) {

//		try{
//			elm.addEventListener(listener,fn,false); // Firefox
//		}catch(e){
//			elm.attachEvent("on"+listener,fn); // IE
//		}

		if (elm.addEventListener) { /* Firefox */
			elm.addEventListener(listener, fn, false);
		}	else if (elm.attachEvent) { /* IE */
			elm.attachEvent("on"+listener, fn);
		}
	}
}

function xdbaseGetState(elid) 
{
	if (elid != null) {
//		var manager = new CookieManager({shelfLife:30});
		var manager = new CookieManager();
		var flg = manager.getCookie(elid);
		xdbaseSetElement(elid, flg);
	}
}

function xdbaseSetState(elid, flg) 
{
	if (elid != null) {
		xdbaseSetElement(elid, flg);

//		var manager = new CookieManager({shelfLife:30});
		var manager = new CookieManager();
		manager.setCookie(elid, flg);
	}
}

function xdbaseSetElement(elid, flg)
{
	if (!document.getElementById(elid)) return false;

	if (document.getElementById(elid + "Show") && document.getElementById(elid + "Hide")) {
		if (flg == 1) {
			Element.hide(elid + "Show");
			Element.show(elid + "Hide");
			Element.show(elid);
		} else {
			Element.show(elid + "Show");
			Element.hide(elid + "Hide");
			Element.hide(elid);
		}
	}
}

function xdbaseInitState() 
{

	if (showXdbaseCategory) {
		xdbaseGetState('xdbaseCategory');
	}

	if (showXdbaseTagCloud) {
		xdbaseGetState('xdbaseTagCloud');
	}

	if (showXdbaseTextSearchForm) {
		xdbaseGetState('xdbaseTextSearchForm');
	}

	if (showXdbaseMap) {
		xdbaseSetMarker();
		xdbaseGetState('xdbaseMap');
	}
}


/* slide show */
var pict = new Array();
var img;
var count = 1;
var max;
var interval;
var loop = false;
var stop = false;

function xdbaseInitSlideShow(data, interval)
{
	total = data.length;
	interval = interval;
	j = 1;
	for (var i = 1; i <= total; i++) {
		if (data[i] != '') {
			pict[j] = data[i];
			j++;
		}
	}
	max = j - 2;
	xdbaseRunSlideShow();
}

function xdbaseLoadPict(index)
{
	if (pict[index] != '') {
		img = new Image();
		img.src = pict[index];
		document.images.slideShow.src = img.src;
	}
}

function xdbaseRunSlideShow()
{
	if (count > max) {
		if (loop) {
			 count = 1;
		} else {
			stop = true;
		}
	}

	var timer;

	if (!stop) {
		xdbaseLoadPict(count);
		timer = setTimeout('xdbaseRunSlideShow()', interval);
		count++;
	}
}


function xdbaseStartSlideShow()
{
	stop = false;
	count = 1;
	xdbaseRunSlideShow();
}

function xdbaseRestartSlideShow()
{
	if (stop == true) {
		stop = false;
		xdbaseRunSlideShow();
	}
}

function xdbaseStopSlideShow()
{
	stop = true;
}

function xdbasePrevPict()
{
	if (count > 1) count = count - 1;
	xdbaseLoadPict(count);
}

function xdbaseNextPict()
{
	if (count < max) count++;
	xdbaseLoadPict(count);
}




