/**
 * @file
 * @package xdbase
 * @version $Id: gmap.js,v 1.4 2012/03/05 11:36:04 bluemelon Exp $
 */


var map;
var currentInfoWindow;
var currentMarker;
var marker_list = [];

//function initializeGmap(){
function initializeGmap(mapOptions){
	if (!document.getElementById("xdbaseMap")) alert("Failed to initialize the Google Maps.");
	map = new google.maps.Map(document.getElementById("xdbaseMap"),mapOptions);
}


function drawMapListView(option, data) {
	var total = option['total'];
	var imgmaxwidth = 200;
	var latlng = new google.maps.LatLng(option['lat'],option['lng']);
	var mapOptions = {
		zoom: option['zoom'],
		center: latlng,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};

	initializeGmap(mapOptions);

	for (var i=1; i<=total; i++) {
		if (data[i]) {

			if (data[i]['lat'] != 0 && data[i]['lng'] != 0) {
				var point = new google.maps.LatLng(data[i]['lat'], data[i]['lng']);
				var did = data[i]['did'];
				var info = '<div class="infow">';
				info += '<a href="' + data[i]['link'] + '">' + data[i]['title'] + '</a>';
				if (data[i]['body'] != '') {
					info += '<br />' + data[i]['body'];
				}
				if (data[i]['imgsrc'] != '') {
					var image = new Image();
					image.src = data[i]['imgsrc'];
					var imghtml = '';
					if (image.width > imgmaxwidth){
						var image_h = Math.floor(imgmaxwidth / image.width * image.height);
						imghtml = '<br /><img src=' + image.src + ' width="' + imgmaxwidth + '" height="' + image_h + '\">';
					} else {
						imghtml = '<br /><img src=' + image.src + '>';
					}
					info += imghtml;
				}
				info += '</div>';

				if (data[i]['icon'] != '' && data[i]['shadow'] != '') {
					if (data[i]['icon'] != '') {
						var icon = new google.maps.MarkerImage(data[i]['icon'], 
							new google.maps.Size(20,34), 
							new google.maps.Point(0,0) ,
							new google.maps.Point(10,0) 
						);
					}

					if (data[i]['shadow'] != '') {
						var shadow = new google.maps.MarkerImage(data[i]['shadow'], 
							new google.maps.Size(37,34), 
							new google.maps.Point(0,0) ,
							new google.maps.Point(10,0) 
						);
					}

					var marker = new google.maps.Marker({
						position: point,
						map: map,
						icon: icon,
						shadow: shadow,
						title: data[i]['title']
					});
				} else {
					var marker = new google.maps.Marker({
						position: point,
						map: map,
						title: data[i]['title']
					});
				}
				marker_list[did] = marker;
				marker_list[did]['info'] = info;
			}

			setInfoWindow(marker, info, point);

		}
	}

}

function setInfoWindow(marker, info, point) {
	var infoWindow = new google.maps.InfoWindow({
			content: info,
			position: point
	})

	google.maps.event.addListener(marker, 'click', function() {
		if (currentInfoWindow) {
			currentInfoWindow.close();
		}
		infoWindow.open(map,marker);
		currentInfoWindow = infoWindow;
	});
}


function drawMapView() {

	var lat = document.getElementById("lat").innerHTML;
	var lng = document.getElementById("lng").innerHTML;
	var zoom = Math.floor(document.getElementById("zoom").innerHTML);
	var latlng = new google.maps.LatLng(lat,lng);
	var mapOptions = {
		zoom: zoom,
		center: latlng,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};

	initializeGmap(mapOptions);

	var marker = new google.maps.Marker({position: latlng, map: map});

}

function drawMapEdit() {

	var lat = document.getElementById("legacy_xoopsform_latitude").value;
	var lng = document.getElementById("legacy_xoopsform_longitude").value;
	var zoom = Math.floor(document.getElementById("legacy_xoopsform_zoom").value);
	var height = document.getElementById("xdbaseMap").style.height;
	var latlng = new google.maps.LatLng(lat,lng);
	var mapOptions = {
		zoom: zoom,
		center: latlng,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};

	initializeGmap(mapOptions);

	var location
	
	google.maps.event.addListener(map, 'click', function(event) {
		location = event.latLng
		placeMarker(location);
	});

	google.maps.event.addListener(map, 'zoom_changed', function() {
		zoomLevel = map.getZoom();
		document.getElementById("legacy_xoopsform_zoom").value = zoomLevel;
		document.getElementById("zoom").innerHTML = zoomLevel;
		map.setCenter(location);
	});

	showMap();
}

function placeMarker(location) {
	if (currentMarker) {
		currentMarker.setMap(null);
	}

	drawLatLngTxt(location);

	var clickedLocation = new google.maps.LatLng(location);
	var marker = new google.maps.Marker({
		position: location, 
		map: map
	});
	map.setCenter(location);
	currentMarker = marker;
}

function drawMapGeoView(option, data) {

	drawMapListView(option, data);

	var state = option['state'];
	var city = option['city'];
	var search_address = state + city;

	if (search_address == "") return;

	var geo = new google.maps.Geocoder();

	geo.geocode(
		{'address': search_address},
		function(result, status) {
			if (status == google.maps.GeocoderStatus.OK) {
				var latlng = new google.maps.LatLng(result[0].geometry.location.lat(), result[0].geometry.location.lng());

				map.setCenter(latlng);
			}else{
				alert(search_address + ' notfound');
			}
		}
	);
}


function searchMap(state, city, address){
	var search_address = state + city + address;
	var geo = new google.maps.Geocoder();

	if (search_address == "") return;

	geo.geocode(
		{'address': search_address},
		function(result, status) {
			if (status == google.maps.GeocoderStatus.OK) {
				var latlng = new google.maps.LatLng(result[0].geometry.location.lat(), result[0].geometry.location.lng());
				placeMarker(latlng);

			}else{
				alert(search_address + ' notfound');
			}
		}
	);
}

function drawLatLngTxt(location){
	document.getElementById("legacy_xoopsform_latitude").value = location.lat();
	document.getElementById("lat").innerHTML = location.lat();
	document.getElementById("legacy_xoopsform_longitude").value = location.lng();
	document.getElementById("lng").innerHTML = location.lng();
}

function showMap(){
	if (document.getElementById("legacy_xoopsform_show_map").checked){
		document.getElementById("maparea").style.visibility = "visible";
//		document.getElementById("xdbaseMap").style.visibility = "visible";
//		document.getElementById("xdbaseMap").style.height = height;
		if (document.getElementById("search_map")) document.getElementById("search_map").style.visibility = "visible";
	}else{
		document.getElementById("maparea").style.visibility = "hidden";
//		document.getElementById("xdbaseMap").style.visibility = "hidden";
//		document.getElementById("xdbaseMap").style.height = "0px";
		if (document.getElementById("search_map")) document.getElementById("search_map").style.visibility = "hidden";
	}
}

function goTo(did){
	map.panTo(marker_list[did].getPosition());
	var infoWindow = new google.maps.InfoWindow({
			content: marker_list[did]['info'],
			position: marker_list[did].getPosition()
	})

	if (currentInfoWindow) {
		currentInfoWindow.close();
	}
	currentInfoWindow = infoWindow;
	infoWindow.open(map, marker_list[did]);
}


