<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataFilterForm.class.php,v 1.19 2011/08/27 10:38:23 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractFilterForm.class.php';

define('XDBASE_DATA_SORT_KEY_DID', 1);
define('XDBASE_DATA_SORT_KEY_CID', 2);
define('XDBASE_DATA_SORT_KEY_TITLE', 3);
define('XDBASE_DATA_SORT_KEY_TAG', 4);
define('XDBASE_DATA_SORT_KEY_PID', 5);
define('XDBASE_DATA_SORT_KEY_UID', 6);
define('XDBASE_DATA_SORT_KEY_NAME', 7);
define('XDBASE_DATA_SORT_KEY_POSTER_IP', 8);
define('XDBASE_DATA_SORT_KEY_CREATED_DATE', 9);
define('XDBASE_DATA_SORT_KEY_UPDATED_DATE', 10);
define('XDBASE_DATA_SORT_KEY_PUBLISHED_DATE', 11);
define('XDBASE_DATA_SORT_KEY_EXPIRED_DATE', 12);
define('XDBASE_DATA_SORT_KEY_S_DATE', 13);
define('XDBASE_DATA_SORT_KEY_E_DATE', 14);
define('XDBASE_DATA_SORT_KEY_PASSWORD', 15);
define('XDBASE_DATA_SORT_KEY_URL', 16);
define('XDBASE_DATA_SORT_KEY_EMAIL', 17);
define('XDBASE_DATA_SORT_KEY_ZIP', 18);
define('XDBASE_DATA_SORT_KEY_STATE', 19);
define('XDBASE_DATA_SORT_KEY_CITY', 20);
define('XDBASE_DATA_SORT_KEY_STREET', 21);
define('XDBASE_DATA_SORT_KEY_PHONE', 22);
define('XDBASE_DATA_SORT_KEY_MOBILE_PHONE', 23);
define('XDBASE_DATA_SORT_KEY_FAX', 24);
define('XDBASE_DATA_SORT_KEY_SHOW_MAP', 25);
define('XDBASE_DATA_SORT_KEY_LATITUDE', 26);
define('XDBASE_DATA_SORT_KEY_LONGITUDE', 27);
define('XDBASE_DATA_SORT_KEY_ZOOM', 28);
define('XDBASE_DATA_SORT_KEY_IMG01', 29);
define('XDBASE_DATA_SORT_KEY_IMG01_HEIGHT', 30);
define('XDBASE_DATA_SORT_KEY_IMG01_WIDTH', 31);
define('XDBASE_DATA_SORT_KEY_IMG02', 32);
define('XDBASE_DATA_SORT_KEY_IMG02_HEIGHT', 33);
define('XDBASE_DATA_SORT_KEY_IMG02_WIDTH', 34);
define('XDBASE_DATA_SORT_KEY_FILE01', 35);
define('XDBASE_DATA_SORT_KEY_FILE01NAME', 36);
define('XDBASE_DATA_SORT_KEY_FILE01EXT', 37);
define('XDBASE_DATA_SORT_KEY_FILE01SIZE', 38);
define('XDBASE_DATA_SORT_KEY_BODY', 39);
define('XDBASE_DATA_SORT_KEY_INT01', 40);
define('XDBASE_DATA_SORT_KEY_INT02', 41);
define('XDBASE_DATA_SORT_KEY_INT03', 42);
define('XDBASE_DATA_SORT_KEY_INT04', 43);
define('XDBASE_DATA_SORT_KEY_INT05', 44);
define('XDBASE_DATA_SORT_KEY_INT06', 45);
define('XDBASE_DATA_SORT_KEY_INT07', 46);
define('XDBASE_DATA_SORT_KEY_INT08', 47);
define('XDBASE_DATA_SORT_KEY_INT09', 48);
define('XDBASE_DATA_SORT_KEY_INT10', 49);
define('XDBASE_DATA_SORT_KEY_FLOAT01', 50);
define('XDBASE_DATA_SORT_KEY_FLOAT02', 51);
define('XDBASE_DATA_SORT_KEY_VARCHAR01', 52);
define('XDBASE_DATA_SORT_KEY_VARCHAR02', 53);
define('XDBASE_DATA_SORT_KEY_VARCHAR03', 54);
define('XDBASE_DATA_SORT_KEY_VARCHAR04', 55);
define('XDBASE_DATA_SORT_KEY_VARCHAR05', 56);
define('XDBASE_DATA_SORT_KEY_VARCHAR06', 57);
define('XDBASE_DATA_SORT_KEY_VARCHAR07', 58);
define('XDBASE_DATA_SORT_KEY_VARCHAR08', 59);
define('XDBASE_DATA_SORT_KEY_VARCHAR09', 60);
define('XDBASE_DATA_SORT_KEY_VARCHAR10', 61);
define('XDBASE_DATA_SORT_KEY_TEXT01', 62);
define('XDBASE_DATA_SORT_KEY_TEXT02', 63);
define('XDBASE_DATA_SORT_KEY_RESERVATION', 64);
define('XDBASE_DATA_SORT_KEY_OPTION_VALUE', 65);
define('XDBASE_DATA_SORT_KEY_WEIGHT', 66);
define('XDBASE_DATA_SORT_KEY_STATUS', 67);
define('XDBASE_DATA_SORT_KEY_ACCESS', 68);
define('XDBASE_DATA_SORT_KEY_GROUPS', 69);
define('XDBASE_DATA_SORT_KEY_HITS', 70);
define('XDBASE_DATA_SORT_KEY_COMMENTS', 71);
define('XDBASE_DATA_SORT_KEY_RATING', 72);
define('XDBASE_DATA_SORT_KEY_VOTES', 73);
define('XDBASE_DATA_SORT_KEY_DOWNLOADS', 74);
define('XDBASE_DATA_SORT_KEY_TRACKBACKS', 75);
define('XDBASE_DATA_SORT_KEY_PIPE_ID', 76);
define('XDBASE_DATA_SORT_KEY_DOHTML', 77);
define('XDBASE_DATA_SORT_KEY_DOXCODE', 78);
define('XDBASE_DATA_SORT_KEY_DOSMILEY', 79);
define('XDBASE_DATA_SORT_KEY_DOIMAGE', 80);
define('XDBASE_DATA_SORT_KEY_DOBR', 81);

define('XDBASE_DATA_SORT_KEY_DEFAULT', _MD_XDBASE_CONST_DEFAULTSORT * _MD_XDBASE_CONST_DEFAULTORDER);

class Xdbase_DataFilterForm extends Xdbase_AbstractFilterForm
{
	var $mSortKeys = array(
		XDBASE_DATA_SORT_KEY_DID => 'did',
		XDBASE_DATA_SORT_KEY_CID => 'cid',
		XDBASE_DATA_SORT_KEY_TITLE => 'title',
		XDBASE_DATA_SORT_KEY_TAG => 'tag',
		XDBASE_DATA_SORT_KEY_PID => 'pid',
		XDBASE_DATA_SORT_KEY_UID => 'uid',
		XDBASE_DATA_SORT_KEY_NAME => 'name',
		XDBASE_DATA_SORT_KEY_POSTER_IP => 'poster_ip',
		XDBASE_DATA_SORT_KEY_CREATED_DATE => 'created_date',
		XDBASE_DATA_SORT_KEY_UPDATED_DATE => 'updated_date',
		XDBASE_DATA_SORT_KEY_PUBLISHED_DATE => 'published_date',
		XDBASE_DATA_SORT_KEY_EXPIRED_DATE => 'expired_date',
		XDBASE_DATA_SORT_KEY_S_DATE => 's_date',
		XDBASE_DATA_SORT_KEY_E_DATE => 'e_date',
		XDBASE_DATA_SORT_KEY_PASSWORD => 'password',
		XDBASE_DATA_SORT_KEY_URL => 'url',
		XDBASE_DATA_SORT_KEY_EMAIL => 'email',
		XDBASE_DATA_SORT_KEY_ZIP => 'zip',
		XDBASE_DATA_SORT_KEY_STATE => 'state',
		XDBASE_DATA_SORT_KEY_CITY => 'city',
		XDBASE_DATA_SORT_KEY_STREET => 'street',
		XDBASE_DATA_SORT_KEY_PHONE => 'phone',
		XDBASE_DATA_SORT_KEY_MOBILE_PHONE => 'mobile_phone',
		XDBASE_DATA_SORT_KEY_FAX => 'fax',
		XDBASE_DATA_SORT_KEY_IMG01 => 'img01',
		XDBASE_DATA_SORT_KEY_IMG01_HEIGHT => 'img01_height',
		XDBASE_DATA_SORT_KEY_IMG01_WIDTH => 'img01_width',
		XDBASE_DATA_SORT_KEY_IMG02 => 'img02',
		XDBASE_DATA_SORT_KEY_IMG02_HEIGHT => 'img02_height',
		XDBASE_DATA_SORT_KEY_IMG02_WIDTH => 'img02_width',
		XDBASE_DATA_SORT_KEY_FILE01 => 'file01',
		XDBASE_DATA_SORT_KEY_FILE01NAME => 'file01name',
		XDBASE_DATA_SORT_KEY_FILE01EXT => 'file01ext',
		XDBASE_DATA_SORT_KEY_FILE01SIZE => 'file01size',
		XDBASE_DATA_SORT_KEY_DOWNLOADS => 'downloads',
		XDBASE_DATA_SORT_KEY_BODY => 'body',
		XDBASE_DATA_SORT_KEY_INT01 => 'int01',
		XDBASE_DATA_SORT_KEY_INT02 => 'int02',
		XDBASE_DATA_SORT_KEY_INT03 => 'int03',
		XDBASE_DATA_SORT_KEY_INT04 => 'int04',
		XDBASE_DATA_SORT_KEY_INT05 => 'int05',
		XDBASE_DATA_SORT_KEY_INT06 => 'int06',
		XDBASE_DATA_SORT_KEY_INT07 => 'int07',
		XDBASE_DATA_SORT_KEY_INT08 => 'int08',
		XDBASE_DATA_SORT_KEY_INT09 => 'int09',
		XDBASE_DATA_SORT_KEY_INT10 => 'int10',
		XDBASE_DATA_SORT_KEY_FLOAT01 => 'float01',
		XDBASE_DATA_SORT_KEY_FLOAT02 => 'float02',
		XDBASE_DATA_SORT_KEY_VARCHAR01 => 'varchar01',
		XDBASE_DATA_SORT_KEY_VARCHAR02 => 'varchar02',
		XDBASE_DATA_SORT_KEY_VARCHAR03 => 'varchar03',
		XDBASE_DATA_SORT_KEY_VARCHAR04 => 'varchar04',
		XDBASE_DATA_SORT_KEY_VARCHAR05 => 'varchar05',
		XDBASE_DATA_SORT_KEY_VARCHAR06 => 'varchar06',
		XDBASE_DATA_SORT_KEY_VARCHAR07 => 'varchar07',
		XDBASE_DATA_SORT_KEY_VARCHAR08 => 'varchar08',
		XDBASE_DATA_SORT_KEY_VARCHAR09 => 'varchar09',
		XDBASE_DATA_SORT_KEY_VARCHAR10 => 'varchar10',
		XDBASE_DATA_SORT_KEY_TRACKBACKS => 'trackbacks',
		XDBASE_DATA_SORT_KEY_PIPE_ID => 'pipe_id',
		XDBASE_DATA_SORT_KEY_SHOW_MAP => 'show_map',
		XDBASE_DATA_SORT_KEY_LATITUDE => 'latitude',
		XDBASE_DATA_SORT_KEY_LONGITUDE => 'longitude',
		XDBASE_DATA_SORT_KEY_ZOOM => 'zoom',
		XDBASE_DATA_SORT_KEY_TEXT01 => 'text01',
		XDBASE_DATA_SORT_KEY_TEXT02 => 'text02',
		XDBASE_DATA_SORT_KEY_RESERVATION => 'reservation',
		XDBASE_DATA_SORT_KEY_OPTION_VALUE => 'option_value',
		XDBASE_DATA_SORT_KEY_WEIGHT => 'weight',
		XDBASE_DATA_SORT_KEY_STATUS => 'status',
		XDBASE_DATA_SORT_KEY_ACCESS => 'access',
		XDBASE_DATA_SORT_KEY_GROUPS => 'groups',
		XDBASE_DATA_SORT_KEY_HITS => 'hits',
		XDBASE_DATA_SORT_KEY_COMMENTS => 'comments',
		XDBASE_DATA_SORT_KEY_RATING => 'rating',
		XDBASE_DATA_SORT_KEY_VOTES => 'votes',
		XDBASE_DATA_SORT_KEY_DOHTML => 'dohtml',
		XDBASE_DATA_SORT_KEY_DOXCODE => 'doxcode',
		XDBASE_DATA_SORT_KEY_DOSMILEY => 'dosmiley',
		XDBASE_DATA_SORT_KEY_DOIMAGE => 'doimage',
		XDBASE_DATA_SORT_KEY_DOBR => 'dobr'
	);

	var $dataHandler = null;


	/**
	 * @public
	 */
	function getDefaultSortKey()
	{
		return XDBASE_DATA_SORT_KEY_DEFAULT;
	}

	/**
	 * @public
	 */
	function fetch()
	{
		parent::fetch();

		$this->dataHandler =& $this->mController->load('handler', 'data');

		foreach ($this->mSortKeys as $key => $keyName)
		{
			$value = xdbaseGetRequest($keyName);
//			if ($value != null)
			if ($value != "")
			{
				if ($keyName == 'cid')
				{
					$this->mNavi->addExtra($keyName, $value);
					$this->addCatCriteria($value);
				}
				elseif ($keyName == 'title')
				{
					$this->mNavi->addExtra($keyName, $value.'%');
					$this->_mCriteria->add(new Xdbase_Criteria($keyName, $value.'%', 'LIKE'));
				}
				elseif ($keyName == 'name' || $keyName == 'state' || $keyName == 'city' || $keyName == 'street')
				{
					$this->mNavi->addExtra($keyName, $value);
					$this->_mCriteria->add(new Xdbase_Criteria($keyName, $value, 'LIKE'));
				}
				elseif ($keyName == 'tag')
				{
					$dataHandler =& $this->mController->load('handler', 'data');
					$tagOptionArray = $dataHandler->getTagOptionArray();
					if (isset($tagOptionArray[$value]))
					{
						$tagValue = $tagOptionArray[$value]['value'];
						$this->mNavi->addExtra('tag', $value);
						$this->_mCriteria->add(new Xdbase_Criteria('tag', '%|'.$tagValue.'|%', 'LIKE'));
					}
				}
				else
				{
					$this->mNavi->addExtra($keyName, $value);
					$this->_mCriteria->add(new Xdbase_Criteria($keyName, $value));
				}
			}
		}

		if (($value = xdbaseGetRequest('namekey')) !== null)
		{
			$this->_mCriteria->add($this->getNameCriteria());
		}

		$this->setPerpage();
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());

		$this->addDataCriteria();
		$this->addSearchCriteria();
		$this->setTemplate();

	}


	function getTotal()
	{
		return $this->dataHandler->getCount($this->getCriteria());
	}

	function setPerpage()
	{
		$this->mNavi->setPerpage($this->getPerpage());
	}

	function getPerpage()
	{
		$perpage = intval(xdbaseGetRequest('perpage'));
		if (!$perpage)
		{
			$perpage = _MD_XDBASE_CONST_NUMPERPAGE;
		}
		return $perpage;
	}

	function getPerpageArray()
	{
		$perpageArray = array(5=>'5',10=>'10',15=>'15',20=>'20',25=>'25',30=>'30',40=>'40',50=>'50',60=>'60',70=>'70',80=>'80',90=>'90',100=>'100');
		return $perpageArray;
	}

	function addCatCriteria($cid)
	{
		$catHandler =& $this->mController->load('handler', 'cat');
		$catHandler->setTree($catHandler->getCriteria());
		$cidArray = $catHandler->getAllChildId($cid);
		$criteria =& new Xdbase_CriteriaCompo();
		$criteria->add(new Xdbase_Criteria('cid', $cid),'OR');
		if (count($cidArray) > 0)
		{
			foreach ($cidArray as $chCid)
			{
				$criteria->add(new Xdbase_Criteria('cid', $chCid) ,'OR');
			}
		}
		$this->_mCriteria->add($criteria);
	}

	function addDataCriteria()
	{
		$dataCriteria =& $this->dataHandler->getCriteria();
		if ($dataCriteria->hasChildElements())
		{
			$this->_mCriteria->add($this->dataHandler->getCriteria());
		}
	}

	function addSearchCriteria()
	{
		$searchCriteria1 =& $this->getSearchCriteria('key1', 'operator1', 'value1');
		$searchCriteria2 =& $this->getSearchCriteria('key2', 'operator2', 'value2');
		$condition = xdbaseGetRequest('condition');
		if (is_object($searchCriteria1))
		{
			$this->_mCriteria->add($searchCriteria1);
		}
		if (is_object($searchCriteria2))
		{
			$this->_mCriteria->add($searchCriteria2, $this->dataHandler->getCondition($condition));
			$this->mNavi->addExtra('condition', $condition);
		}
	}

	function getSearchCriteria($keyName, $operatorName, $valueName, $conditionName = null)
	{
		$key = xdbaseGetRequest($keyName);
		$operatorValue = xdbaseGetRequest($operatorName);
		$value = xdbaseGetRequest($valueName);
		if ($key != '' && $operatorValue != '' && $value != '')
		{
			$operator = $this->dataHandler->getOperator($operatorValue);
			$criteria =& new Xdbase_CriteriaCompo();
			if (($key !== null) && ($value != '') && ($this->dataHandler->getSearch($key)))
			{
				if (is_null($conditionName))
				{
					if ($operator == 'LIKE')
					{
						$criteria->add(new Xdbase_Criteria($key, '%'.$value.'%', $operator));
					}
					else
					{
						$criteria->add(new Xdbase_Criteria($key, $value, $operator));
					}
				}
				else
				{
					$condition = xdbaseGetRequest($conditionName);
					$criteria->add(new Xdbase_Criteria($key, $value, $operator), $this->dataHandler->getCondition($condition));
				}
				$this->mNavi->addExtra($keyName, $key);
				$this->mNavi->addExtra($operatorName, $operatorValue);
				$this->mNavi->addExtra($valueName, $value);
			}
			return $criteria;
		}
		else
		{
			return false;
		}
	}

// for query by $_GET request
	function get($key)
	{
		$ret = htmlspecialchars(xdbaseGetRequest($key), ENT_QUOTES);
		return $ret;
	}

	function getInt($key)
	{
		$ret = xdbaseGetRequest($key);
//		if (!is_null($ret))
		if ($ret != "")
		{
			$ret = intval($ret);
		}
		return $ret;
	}

	function getCid()
	{
		return intval(xdbaseGetRequest('cid'));
	}

	function getTagValue()
	{
		$tagOptionArray = $this->dataHandler->getTagOptionArray();
		$tagKey = xdbaseGetRequest('tag');
		$tagValue = '';
		if (isset($tagOptionArray[$tagKey]))
		{
			$tagValue = htmlspecialchars($tagOptionArray[$tagKey]['value'], ENT_QUOTES);
		}
		return $tagValue;
	}

	function getDataCount($cid)
	{
		$catHandler =& $this->mController->load('handler', 'cat');
		$criteria =& $this->dataHandler->getCriteria();
		if (is_object($this->getSearchCriteria('key1', 'operator1', 'value1')))
		{
			$criteria->add($this->getSearchCriteria('key1', 'operator1', 'value1'));
		}
		if (is_object($this->getSearchCriteria('key2', 'operator2', 'value2', 'condition')))
		{
			$criteria->add($this->getSearchCriteria('key2', 'operator2', 'value2', 'condition'));
		}
		$dataCount = $catHandler->getDataCount($cid, $criteria);
		return $dataCount;
	}


// for bbs style post form
	function getActionForm()
	{
		$mActionForm =& $this->mController->create('form', 'edit_data');
		$mActionForm->prepare();
		return $mActionForm;
	}

// for bbs style data list
	function addParentCriteria()
	{
		$this->dataHandler->addParentCriteria($this->_mCriteria);
	}


// for address style
	function getSyllableArray()
	{
		$syllableArray = array(
			0 => _MD_XDBASE_SYLLABLE0,
			1 => _MD_XDBASE_SYLLABLE1,
			2 => _MD_XDBASE_SYLLABLE2,
			3 => _MD_XDBASE_SYLLABLE3,
			4 => _MD_XDBASE_SYLLABLE4,
			5 => _MD_XDBASE_SYLLABLE5,
			6 => _MD_XDBASE_SYLLABLE6,
			7 => _MD_XDBASE_SYLLABLE7,
			8 => _MD_XDBASE_SYLLABLE8,
			9 => _MD_XDBASE_SYLLABLE9,
		);
		return $syllableArray;
	}

	function getNameCriteria()
	{
		$namekey = xdbaseGetRequest('namekey');
		$criteria =& new Xdbase_CriteriaCompo();
		switch ($namekey)
		{
			case 0:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE0, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE1, '<'), 'AND');
				break;
			case 1:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE1, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE2, '<'), 'AND');
				break;
			case 2:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE2, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE3, '<'), 'AND');
				break;
			case 3:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE3, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE4, '<'), 'AND');
				break;
			case 4:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE4, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE5, '<'), 'AND');
				break;
			case 5:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE5, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE6, '<'), 'AND');
				break;
			case 6:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE6, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE7, '<'), 'AND');
				break;
			case 7:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE7, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE8, '<'), 'AND');
				break;
			case 8:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE8, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE9, '<'), 'AND');
				break;
			case 9:
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE9, '>='));
				$criteria->add(new Xdbase_Criteria('substring(name, 1, 2)', _MD_XDBASE_SYLLABLE10, '<='), 'AND');
				break;
			default:
				break;
		}
		$this->mNavi->addExtra('namekey', $namekey);
		return $criteria;
	}

// tag cloud
	function getTagCloud()
	{
		$tagOptionArray = $this->dataHandler->getTagOptionArray();

		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/TagCloud/TagCloud.php';
		$obj = new HTML_TagCloud();

		if (is_array($tagOptionArray) && count($tagOptionArray) > 0)
		{
			foreach ($tagOptionArray as $key => $tagOption)
			{
				$tagName = htmlspecialchars($tagOption['value'], ENT_QUOTES);
				$tagLink = './index.php?tag='.$key;
				$tagCount = $tagOption['count'];
				$obj->addElement($tagName, $tagLink, $tagCount);
			}
			return $obj->buildHTML();
		}
	}

	function getTagCloudAjax()
	{
		$tagOptionArray = $this->dataHandler->getTagOptionArray();
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/TagCloud/TagCloud.php';
		$obj = new HTML_TagCloud();

		if (is_array($tagOptionArray) && count($tagOptionArray) > 0)
		{
			foreach ($tagOptionArray as $key => $tagOption)
			{
				$tagName = htmlspecialchars($tagOption['value'], ENT_QUOTES);
//				$tagLink = './index.php?tag='.htmlspecialchars($tag, ENT_QUOTES);
				$tagLink = './index.php';
//				$tagLink = XOOPS_URL.'/modules/'.XDBASE_TRUST_DIRNAME.'/index.php';
				$tagCount = $tagOption['count'];
				$timestamp = null;
				$param = 'tag='.$key;

				$obj->addElementAjax($tagName, $tagLink, $tagCount, $timestamp, $param);
			}
			return $obj->buildHTMLAjax();
		}
	}


	// for weekly style
	function getObjectsFromDate($date, $limit=0)
	{
		$timeStart = intval($date);

		if ($timeStart == 0) return false;

		$timeEnd = $timeStart + 86400;
		$criteria =& new Xdbase_CriteriaCompo();
		$date_criteria_1 =& new Xdbase_CriteriaCompo();
		$date_criteria_2 =& new Xdbase_CriteriaCompo();
		$date_criteria_1->add(new Xdbase_Criteria('s_date', $timeStart, '>='));
		$date_criteria_1->add(new Xdbase_Criteria('s_date', $timeEnd, '<'));
		$date_criteria_2->add(new Xdbase_Criteria('s_date', $timeStart, '<'));
		$date_criteria_2->add(new Xdbase_Criteria('e_date', $timeStart, '>'));
		$criteria->add($date_criteria_1);
		$criteria->add($date_criteria_2,'OR');
		if ($this->_mCriteria->hasChildElements())
		{
			$criteria->add($this->_mCriteria);
		}
		$criteria->setLimit($limit);
		
		$dataObjects = $this->dataHandler->getObjects($criteria);
		return $dataObjects;
	}

	function getObjectsFromTime($stime, $etime, $limit=0)
	{
		$timeStart = intval($stime);
		$timeEnd = intval($etime);
		$criteria =& new Xdbase_CriteriaCompo();
		$date_criteria_1 =& new Xdbase_CriteriaCompo();
		$date_criteria_2 =& new Xdbase_CriteriaCompo();
		$date_criteria_1->add(new Xdbase_Criteria('s_date', $timeStart, '>='));
		$date_criteria_1->add(new Xdbase_Criteria('s_date', $timeEnd, '<'));
		$date_criteria_2->add(new Xdbase_Criteria('s_date', $timeStart, '<'));
		$date_criteria_2->add(new Xdbase_Criteria('e_date', $timeStart, '>'));
		$criteria->add($date_criteria_1);
		$criteria->add($date_criteria_2,'OR');
		if ($this->_mCriteria->hasChildElements())
		{
			$criteria->add($this->_mCriteria);
		}
		$criteria->setLimit($limit);

		
		$dataObjects = $this->dataHandler->getObjects($criteria);
		return $dataObjects;
	}

// for calendar style
	function getCalender()
	{
		$year = intval(xdbaseGetRequest('year'));
		$month = intval(xdbaseGetRequest('month'));

		if ($year == 0) $year = date('Y');
		if ($month == 0) $month = date('n');

		$selectedUnixTime = mktime(0, 0, 0, $month, 1, $year);
		$startWeek = date('w',$selectedUnixTime);
		$daysCount = date('t',$selectedUnixTime);
		$endofMonthUnixTime = mktime(0, 0, 0, $month + 1, 1, $year) - 86400;
		$endWeek = date('w',$endofMonthUnixTime);
		$limit = $startWeek + $daysCount + (7 - $endWeek);

		$dayArray = array();

		$number = 0;
		$week = 0;
		for ($i = 1; $i < $limit; $i++)
		{
			$number = $i - $startWeek;
			if ($i <= $startWeek)
			{
				$dayArray[$i]['day'] = false;
				$dayArray[$i]['week'] = -1;
				$dayArray[$i]['utime'] = false;
				$dayArray[$i]['blank'] = true;
			}
			elseif ($number > $daysCount)
			{
				$dayArray[$i]['day'] = false;
				$dayArray[$i]['week'] = -1;
				$dayArray[$i]['utime'] = false;
				$dayArray[$i]['blank'] = true;
			}
			else
			{
				$dayArray[$i]['day'] = $number;
				if ($number == date('j') && $month == date('n') && $year == date('Y'))
				{
					$dayArray[$i]['week'] = 7;
				}
				else
				{
					$dayArray[$i]['week'] = $week;
				}
				$dayArray[$i]['utime'] = mktime(0, 0, 0, $month, $number, $year);
				$dayArray[$i]['blank'] = false;
			}

			if ($i % 7 == 0)
			{
				$week = 0;
			}
			else
			{
				$week++;
			}

			if (($daysCount <= $number) && ($i % 7 == 0))
			{
				break;
			}
		}
		return $dayArray;
	}

// for yearly & monthly style
	function addMonthCriteria()
	{
		$year = xdbaseGetRequest('year');
		$month = xdbaseGetRequest('month');
		$criteria =& new Xdbase_CriteriaCompo();

		if ($year === null)
		{
			$year = date('Y');
		}

		if ($month === null)
		{
			$month = date('n');
		}

		$this->mNavi->addExtra('year', $year);


		if (_MD_XDBASE_CONST_LIST_TPT == 'data_list_yearly_style.html')
		{
			$dateStart = mktime(0, 0, 0, 1, 1, $year);
			$dateEnd = mktime(0, 0, 0, 1, 1, $year + 1);
		}
		elseif (_MD_XDBASE_CONST_LIST_TPT == 'data_list_monthly_style.html')
		{
			$dateStart = mktime(0, 0, 0, $month, 1, $year);
			$dateEnd = mktime(0, 0, 0, $month + 1, 1, $year);
			$this->mNavi->addExtra('month', $month);
		}

		$criteria->add(new Xdbase_Criteria('s_date', $dateStart, '>='));
		$criteria->add(new Xdbase_Criteria('s_date', $dateEnd, '<'));
		$this->_mCriteria->add($criteria);
	}

// for yearly & monthly style
	function getYears()
	{
		$criteria =& $this->dataHandler->getCriteria();
		$criteria->add(new Xdbase_Criteria('s_date', 0, '<>'));

		$db =& Database::getInstance();
		$tableName = $db->prefix($this->mController->mDirname.'_data');
		$sql ="SELECT DISTINCT FROM_UNIXTIME(s_date,'%Y-%c') AS f_date FROM ".$tableName." WHERE ".$criteria->render()." ORDER BY s_date ASC";

		$result = $db->query($sql);
		if (!$result)
		{
			die('DB Error : '.$db->error());
		}

		if ($db->getRowsNum($result) == 0)
		{
			return false;
		}

		while ($row = $db->fetchArray($result))
		{
			$s_year = preg_match('/(\d+)-(\d+)/', $row['f_date'], $matches);
			$s_year = $matches[1];
			$s_month = $matches[2];
			$years[$s_year][$s_month] = $s_month;
		}
		return $years;
	}

// for weekly style
	function getWeekArray()
	{
		$weekArray = xdbaseGetWeekArray();
		return $weekArray;
	}

// for calendar style
	function getYear()
	{
		return xdbaseGetYear();
	}

	function getYearStr($year=0)
	{
		if ($year === 0)
		{
			$year = xdbaseGetYear();
		}
		return xdbaseGetYearStr($year);
	}

	function getMonth()
	{
		return xdbaseGetMonth();
	}

	function getMonthStr($month=0)
	{
		if ($month === 0)
		{
			$month = xdbaseGetMonth();
		}
		return xdbaseGetMonthStr($month);
	}

	function getWeek()
	{
		return xdbaseGetWeek();
	}

	function getDay()
	{
		return xdbaseGetDay();
	}

	function getThisYear()
	{
		return date('Y');
	}

	function getThisMonth()
	{
		return date('n');
	}

	function getThisDay()
	{
		return date('j');
	}

	function getBaseUrl()
	{
		$view = xdbaseGetRequest('view');
		if (isset($view)) $this->mNavi->addExtra('view', $view);
		return $this->mNavi->renderUrlForPage();
	}

	function getPrevYearUrl()
	{
		$year = $this->getYear() - 1;
		$month = $this->getMonth();
//		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;view=5';
		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month;
		return $ret;
	}

	function getNextYearUrl()
	{
		$year = $this->getYear() + 1;
		$month = $this->getMonth();
//		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;view=5';
		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month;
		return $ret;
	}

	function getPrevMonthUrl()
	{
		$year = $this->getYear();
		$month = $this->getMonth() - 1;
		if ($month < 1)
		{
			$year = $this->getYear() - 1;
			$month = 12;
		}
//		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;view=5';
		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month;
		return $ret;
	}

	function getNextMonthUrl()
	{
		$year = $this->getYear();
		$month = $this->getMonth() + 1;
		if ($month > 12)
		{
			$year = $this->getYear() + 1;
			$month = 1;
		}
//		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;view=5';
		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month;
		return $ret;
	}

	function getSelectMonthUrl()
	{
		$ret = $this->getBaseUrl().'&amp;year='.$this->getYear().'&amp;month='.$this->getMonth();
		return $ret;
	}

	function getPrevWeekUrl()
	{
		$dateArray = getdate(mktime(0, 0, 0, $this->getMonth(), $this->getDay() - 7 , $this->getYear()));
		$year = $dateArray['year'];
		$month = $dateArray['mon'];
		$day = $dateArray['mday'];
//		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;day='.$day.'&amp;view=16';
		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;day='.$day;
		return $ret;
	}

	function getNextWeekUrl()
	{
		$dateArray = getdate(mktime(0, 0, 0, $this->getMonth(), $this->getDay() + 7 , $this->getYear()));
		$year = $dateArray['year'];
		$month = $dateArray['mon'];
		$day = $dateArray['mday'];
//		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;day='.$day.'&amp;view=16';
		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;day='.$day;
		return $ret;
	}

	function getPrevDayUrl()
	{
		$dateArray = getdate(mktime(0, 0, 0, $this->getMonth(), $this->getDay() - 1 , $this->getYear()));
		$year = $dateArray['year'];
		$month = $dateArray['mon'];
		$day = $dateArray['mday'];
//		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;day='.$day.'&amp;view=6';
		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;day='.$day;
		return $ret;
	}

	function getNextDayUrl()
	{
		$dateArray = getdate(mktime(0, 0, 0, $this->getMonth(), $this->getDay() + 1 , $this->getYear()));
		$year = $dateArray['year'];
		$month = $dateArray['mon'];
		$day = $dateArray['mday'];
//		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;day='.$day.'&amp;view=6';
		$ret = $this->getBaseUrl().'&amp;year='.$year.'&amp;month='.$month.'&amp;day='.$day;
		return $ret;
	}

	function getSelectDayUrl()
	{
		$ret = $this->getBaseUrl().'&amp;year='.$this->getYear().'&amp;month='.$this->getMonth().'&amp;day='.$this->getDay();
		return $ret;
	}

	function getToDayUrl()
	{
//		$ret = $this->getBaseUrl().'&amp;year='.$this->getThisYear().'&amp;month='.$this->getThisMonth().'&amp;day='.$this->getThisDay().'&amp;view=6';
		$ret = $this->getBaseUrl().'&amp;year='.$this->getThisYear().'&amp;month='.$this->getThisMonth().'&amp;day='.$this->getThisDay();
		return $ret;
	}

//	function getDateUnixTime($hour=0, $day=0)
	function getDateUnixTime($hour=0)
	{
/*
		if ($day=0)
		{
			$timestamp = mktime($hour, 0, 0, xdbaseGetMonth(), xdbaseGetDay(), xdbaseGetYear());
		}
		else
		{
			$timestamp = mktime($hour, 0, 0, xdbaseGetMonth(), $day, xdbaseGetYear());
		}
*/
		$timestamp = mktime($hour, 0, 0, xdbaseGetMonth(), xdbaseGetDay(), xdbaseGetYear());
		return $timestamp;
	}

	function setTemplate()
	{
		$view = xdbaseGetRequest('view');
		if (isset($view)) $this->mNavi->addExtra('view', $view);

		switch (_MD_XDBASE_CONST_LIST_TPT)
		{
			case 'data_list_monthly_style.html':
			case 'data_list_yearly_style.html':
				$this->addMonthCriteria();
				break;
			case 'data_list_bbs_style.html':
				$this->addParentCriteria();
				break;
			default:
		}
	}



}

?>
