<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_config.class.php,v 1.14 2011/08/27 10:38:23 bluemelon Exp $
 */

require_once dirname(dirname(__FILE__)).'/Xdbase_Object.class.php';
require_once dirname(dirname(__FILE__)).'/Xdbase_ObjectHandler.class.php';


class Xdbase_Data_configObject extends Xdbase_Object
{
	/**
	 * @public
	 */
	function Xdbase_Data_configObject()
	{
		$this->initVar('configid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('col', XOBJ_DTYPE_STRING, '', false, 30);
		$this->initVar('name', XOBJ_DTYPE_STRING, '', false, 100);
		$this->initVar('active', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('search', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('show_list', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('show_article', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('input_type', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('option_value', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('default_value', XOBJ_DTYPE_TEXT, '', false);
	}

	function getRequired()
	{
		if ($this->get('active') === 2)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getInputType($i = -1)
	{
		if ($i == -1)
		{
			$i = $this->get('input_type');
		}
		else
		{
			$i = intval($i);
		}

		switch ($i)
		{
			case 1:
				$ret = 'text';
				break;
			case 2:
				$ret = 'textarea';
				break;
			case 3:
				$ret = 'dhtmltarea';
				break;
			case 4:
				$ret = 'checkbox';
				break;
			case 5:
				$ret = 'radio';
				break;
			case 6:
				$ret = 'select';
				break;
			case 7:
				$ret = 'hidden';
				break;
			default:
				$ret = ' ---- ';
		}
		return $ret;
	}

	function getActiveArray()
	{
		$colArray = array(
				'uid',
				'poster_ip',
				'created_date',
				'updated_date',
				'show_map',
				'reservation',
				'status',
				'access',
				'groups',
				'hits',
				'comments',
				'rating',
				'votes',
				'downloads',
				'trackbacks',
				'pipe_id',
				'dohtml',
				'doxcode',
				'dosmiley',
				'doimage',
				'dobr'
			);

		$activeArray = array();
		$activeArray[0]['value'] = 0;
		$activeArray[0]['label'] = _MD_XDBASE_LANG_DISABLE;
		$activeArray[1]['value'] = 1;
		$activeArray[1]['label'] = _MD_XDBASE_LANG_ENABLE;

		if (!in_array($this->get('col'), $colArray))
		{
			$activeArray[2]['value'] = 2;
			$activeArray[2]['label'] = _MD_XDBASE_LANG_REQUIRED;
		}

		return $activeArray;
	}

	function getInputTypeArray()
	{
		$inputTypeArray = array();
		if ($this->get('col') == 'body' || $this->get('col') == 'text01' || $this->get('col') == 'text02')
		{
			$inputTypeArray[0]['value'] = 0;
			$inputTypeArray[0]['label'] = ' ---- ';
			$inputTypeArray[2]['value'] = 2;
			$inputTypeArray[2]['label'] = 'textarea';
			$inputTypeArray[3]['value'] = 3;
			$inputTypeArray[3]['label'] = 'dhtmltarea';
		}
		else
		{
			$inputTypeArray[0]['value'] = 0;
			$inputTypeArray[0]['label'] = ' ---- ';
			$inputTypeArray[1]['value'] = 1;
			$inputTypeArray[1]['label'] = 'text';
//			$inputTypeArray[4]['value'] = 4;
//			$inputTypeArray[4]['label'] = 'checkbox';
			$inputTypeArray[5]['value'] = 5;
			$inputTypeArray[5]['label'] = 'radio';
			$inputTypeArray[6]['value'] = 6;
			$inputTypeArray[6]['label'] = 'select';
			$inputTypeArray[7]['value'] = 7;
			$inputTypeArray[7]['label'] = 'hidden';
		}
		return $inputTypeArray;
	}

	function getOptionValueArray()
	{
		$optionValueArray = array();
		$optionValueSource = unserialize($this->get('option_value'));

		if (!is_array($optionValueSource)) return $optionValueArray;
		foreach ($optionValueSource as $key=>$optionValue)
		{
			if ($optionValue != '')
			{
				$optionValueArray[$key] = htmlspecialchars($optionValue, ENT_QUOTES);
			}
		}
		return $optionValueArray;
	}

	function getActiveDisabled()
	{
		$activeDisabledArray = array(
			'did',
//			'title',
			'img01_height',
			'img01_width',
			'img02_height',
			'img02_width',
			'file01name',
			'file01ext',
			'file01size',
			'latitude',
			'longitude',
			'zoom',
			'hits',
			'comments',
			'rating',
			'votes',
			'downloads'
		);
		if (in_array($this->get('col'), $activeDisabledArray))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getSearchDisabled()
	{
		$searchDisabledArray = array(
			'password',
			'show_map',
			'latitude',
			'longitude',
			'zoom',
			'img01',
			'img01_height',
			'img01_width',
			'img02',
			'img02_height',
			'img02_width',
			'file01',
			'file01name',
			'file01ext',
			'file01size',
			'option_value',
			'trackbacks',
			'pipe_id',
			'dohtml',
			'doxcode',
			'dosmiley',
			'doimage',
			'dobr'
		);
		if (in_array($this->get('col'), $searchDisabledArray))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getShowDisabled()
	{
		$showDisabledArray = array(
			'img01_height',
			'img01_width',
			'img02_height',
			'img02_width',
			'file01name',
			'file01ext',
			'file01size',
			'latitude',
			'longitude',
			'zoom',
		);
//		if (in_array($this->get('col'), $this->showDisabledArray))
		if (in_array($this->get('col'), $showDisabledArray))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getInputTypeDisabled()
	{
		$inputTypeDisabledArray = array(
			'did',
			'cid',
			'title',
			'tag',
			'pid',
			'uid',
			'name',
			'poster_ip',
			'created_date',
			'updated_date',
			'published_date',
			'expired_date',
			's_date',
			'e_date',
			'password',
			'url',
			'email',
			'zip',
			'state',
			'city',
			'street',
			'phone',
			'mobile_phone',
			'fax',
			'show_map',
			'latitude',
			'longitude',
			'zoom',
			'img01',
			'img01_height',
			'img01_width',
			'img02',
			'img02_height',
			'img02_width',
			'file01',
			'file01name',
			'file01ext',
			'file01size',
			'float01',
			'float02',
			'varchar01',
			'varchar02',
			'varchar03',
			'varchar04',
			'varchar05',
			'varchar06',
			'varchar07',
			'varchar08',
			'varchar09',
			'varchar10',
			'option_value',
			'reservation',
			'weight',
			'status',
			'access',
			'groups',
			'hits',
			'comments',
			'rating',
			'votes',
			'downloads',
			'trackbacks',
			'pipe_id',
			'dohtml',
			'doxcode',
			'dosmiley',
			'doimage',
			'dobr'
		);
		if (in_array($this->get('col'), $inputTypeDisabledArray))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getOptionValueDisabled()
	{
		$optionValueDisabledArray = array(
			'did',
			'cid',
			'title',
			'tag',
			'pid',
			'uid',
			'name',
			'poster_ip',
			'created_date',
			'updated_date',
			'published_date',
			'expired_date',
			's_date',
			'e_date',
			'password',
			'url',
			'email',
			'zip',
			'state',
			'city',
			'street',
			'phone',
			'mobile_phone',
			'fax',
			'show_map',
			'latitude',
			'longitude',
			'zoom',
			'img01',
			'img01_height',
			'img01_width',
			'img02',
			'img02_height',
			'img02_width',
			'file01',
			'file01name',
			'file01ext',
			'file01size',
			'body',
			'float01',
			'float02',
			'varchar01',
			'varchar02',
			'varchar03',
			'varchar04',
			'varchar05',
			'varchar06',
			'varchar07',
			'varchar08',
			'varchar09',
			'varchar10',
			'text01',
			'text02',
			'option_value',
			'reservation',
			'weight',
			'status',
			'access',
			'groups',
			'hits',
			'comments',
			'rating',
			'votes',
			'downloads',
			'trackbacks',
			'pipe_id',
			'dohtml',
			'doxcode',
			'dosmiley',
			'doimage',
			'dobr'
		);
		if (in_array($this->get('col'), $optionValueDisabledArray))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getDefaultValueDisabled()
	{
		$defaultValueDisabledArray = array(
			'did',
			'cid',
			'title',
			'tag',
			'pid',
			'uid',
			'name',
			'poster_ip',
			'created_date',
			'updated_date',
			'password',
			'url',
			'email',
			'latitude',
			'longitude',
			'zoom',
			'img01',
			'img01_height',
			'img01_width',
			'img02',
			'img02_height',
			'img02_width',
			'file01',
			'file01name',
			'file01ext',
			'file01size',
			'body',
			'weight',
			'hits',
			'comments',
			'rating',
			'votes',
			'downloads',
			'trackbacks',
			'pipe_id'
		);
		if (in_array($this->get('col'), $defaultValueDisabledArray))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getKeyDesc()
	{
		$keyDescConst = '_MD_XDBASE_DESC_KEY_'.strtoupper($this->get('col'));
		if (defined($keyDescConst))
		{
			$keyDesc = constant($keyDescConst);
			return $keyDesc;
		}
	}

}


//class Xdbase_Data_configHandler extends XoopsObjectGenericHandler
class Xdbase_Data_configHandler extends Xdbase_ObjectHandler
{
	var $mTable = '{dirname}_data_config';
	var $mPrimary = 'col';
	var $mClass = 'Xdbase_Data_configObject';
	var $mDirName = null;

	function Xdbase_Data_configHandler(&$db, $dirname)
	{
		$this->mDirName = $dirname;
		$this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
		Xdbase_ObjectHandler::Xdbase_ObjectHandler(&$db);
	}


	function defineDataLang()
	{
		if ( !defined('XDBASE_DATA_CONFIG_LOADED') )
		{
			define( 'XDBASE_DATA_CONFIG_LOADED' , 1 );

			define('_MD_XDBASE_LANG_DID', $this->getShowName('did'));
			define('_MD_XDBASE_LANG_CID', $this->getShowName('cid'));
			define('_MD_XDBASE_LANG_TITLE', $this->getShowName('title'));
			define('_MD_XDBASE_LANG_TAG', $this->getShowName('tag'));
			define('_MD_XDBASE_LANG_PID', $this->getShowName('pid'));
			define('_MD_XDBASE_LANG_UID', $this->getShowName('uid'));
			define('_MD_XDBASE_LANG_NAME', $this->getShowName('name'));
			define('_MD_XDBASE_LANG_POSTER_IP', $this->getShowName('poster_ip'));
			define('_MD_XDBASE_LANG_CREATED_DATE', $this->getShowName('created_date'));
			define('_MD_XDBASE_LANG_UPDATED_DATE', $this->getShowName('updated_date'));
			define('_MD_XDBASE_LANG_PUBLISHED_DATE', $this->getShowName('published_date'));
			define('_MD_XDBASE_LANG_EXPIRED_DATE', $this->getShowName('expired_date'));
			define('_MD_XDBASE_LANG_S_DATE', $this->getShowName('s_date'));
			define('_MD_XDBASE_LANG_E_DATE', $this->getShowName('e_date'));
			define('_MD_XDBASE_LANG_PASSWORD', $this->getShowName('password'));
			define('_MD_XDBASE_LANG_EMAIL', $this->getShowName('email'));
			define('_MD_XDBASE_LANG_URL', $this->getShowName('url'));
			define('_MD_XDBASE_LANG_ZIP', $this->getShowName('zip'));
			define('_MD_XDBASE_LANG_STATE', $this->getShowName('state'));
			define('_MD_XDBASE_LANG_CITY', $this->getShowName('city'));
			define('_MD_XDBASE_LANG_STREET', $this->getShowName('street'));
			define('_MD_XDBASE_LANG_PHONE', $this->getShowName('phone'));
			define('_MD_XDBASE_LANG_MOBILE_PHONE', $this->getShowName('mobile_phone'));
			define('_MD_XDBASE_LANG_FAX', $this->getShowName('fax'));
			define('_MD_XDBASE_LANG_IMG01', $this->getShowName('img01'));
			define('_MD_XDBASE_LANG_IMG01_HEIGHT', $this->getShowName('img01_height'));
			define('_MD_XDBASE_LANG_IMG01_WIDTH', $this->getShowName('img01_width'));
			define('_MD_XDBASE_LANG_IMG02', $this->getShowName('img02'));
			define('_MD_XDBASE_LANG_IMG02_HEIGHT', $this->getShowName('img02_height'));
			define('_MD_XDBASE_LANG_IMG02_WIDTH', $this->getShowName('img02_width'));
			define('_MD_XDBASE_LANG_FILE01', $this->getShowName('file01'));
			define('_MD_XDBASE_LANG_FILE01NAME', $this->getShowName('file01name'));
			define('_MD_XDBASE_LANG_FILE01EXT', $this->getShowName('file01ext'));
			define('_MD_XDBASE_LANG_FILE01SIZE', $this->getShowName('file01size'));
			define('_MD_XDBASE_LANG_DOWNLOADS', $this->getShowName('downloads'));
			define('_MD_XDBASE_LANG_BODY', $this->getShowName('body'));
			define('_MD_XDBASE_LANG_INT01', $this->getShowName('int01'));
			define('_MD_XDBASE_LANG_INT02', $this->getShowName('int02'));
			define('_MD_XDBASE_LANG_INT03', $this->getShowName('int03'));
			define('_MD_XDBASE_LANG_INT04', $this->getShowName('int04'));
			define('_MD_XDBASE_LANG_INT05', $this->getShowName('int05'));
			define('_MD_XDBASE_LANG_INT06', $this->getShowName('int06'));
			define('_MD_XDBASE_LANG_INT07', $this->getShowName('int07'));
			define('_MD_XDBASE_LANG_INT08', $this->getShowName('int08'));
			define('_MD_XDBASE_LANG_INT09', $this->getShowName('int09'));
			define('_MD_XDBASE_LANG_INT10', $this->getShowName('int10'));
			define('_MD_XDBASE_LANG_FLOAT01', $this->getShowName('float01'));
			define('_MD_XDBASE_LANG_FLOAT02', $this->getShowName('float02'));
			define('_MD_XDBASE_LANG_VARCHAR01', $this->getShowName('varchar01'));
			define('_MD_XDBASE_LANG_VARCHAR02', $this->getShowName('varchar02'));
			define('_MD_XDBASE_LANG_VARCHAR03', $this->getShowName('varchar03'));
			define('_MD_XDBASE_LANG_VARCHAR04', $this->getShowName('varchar04'));
			define('_MD_XDBASE_LANG_VARCHAR05', $this->getShowName('varchar05'));
			define('_MD_XDBASE_LANG_VARCHAR06', $this->getShowName('varchar06'));
			define('_MD_XDBASE_LANG_VARCHAR07', $this->getShowName('varchar07'));
			define('_MD_XDBASE_LANG_VARCHAR08', $this->getShowName('varchar08'));
			define('_MD_XDBASE_LANG_VARCHAR09', $this->getShowName('varchar09'));
			define('_MD_XDBASE_LANG_VARCHAR10', $this->getShowName('varchar10'));
			define('_MD_XDBASE_LANG_TRACKBACKS', $this->getShowName('trackbacks'));
			define('_MD_XDBASE_LANG_PIPE_ID', $this->getShowName('pipe_id'));
			define('_MD_XDBASE_LANG_SHOW_MAP', $this->getShowName('show_map'));
			define('_MD_XDBASE_LANG_LATITUDE', $this->getShowName('latitude'));
			define('_MD_XDBASE_LANG_LONGITUDE', $this->getShowName('longitude'));
			define('_MD_XDBASE_LANG_ZOOM', $this->getShowName('zoom'));
			define('_MD_XDBASE_LANG_TEXT01', $this->getShowName('text01'));
			define('_MD_XDBASE_LANG_TEXT02', $this->getShowName('text02'));
			define('_MD_XDBASE_LANG_RESERVATION', $this->getShowName('reservation'));
			define('_MD_XDBASE_LANG_OPTION_VALUE', $this->getShowName('option_value'));
			define('_MD_XDBASE_LANG_WEIGHT', $this->getShowName('weight'));
			define('_MD_XDBASE_LANG_STATUS', $this->getShowName('status'));
			define('_MD_XDBASE_LANG_ACCESS', $this->getShowName('access'));
			define('_MD_XDBASE_LANG_GROUPS', $this->getShowName('groups'));
			define('_MD_XDBASE_LANG_HITS', $this->getShowName('hits'));
			define('_MD_XDBASE_LANG_COMMENTS', $this->getShowName('comments'));
			define('_MD_XDBASE_LANG_RATING', $this->getShowName('rating'));
			define('_MD_XDBASE_LANG_VOTES', $this->getShowName('votes'));
			define('_MD_XDBASE_LANG_DOHTML', $this->getShowName('dohtml'));
			define('_MD_XDBASE_LANG_DOXCODE', $this->getShowName('doxcode'));
			define('_MD_XDBASE_LANG_DOSMILEY', $this->getShowName('dosmiley'));
			define('_MD_XDBASE_LANG_DOIMAGE', $this->getShowName('doimage'));
			define('_MD_XDBASE_LANG_DOBR', $this->getShowName('dobr'));
		}
	}

	function getConfigObjectArray()
	{
		static $configObjectArray = array();
		if (count($configObjectArray) == 0)
		{
			$configObjectArray = $this->getObjects(null,null,null,true);
		}
		return $configObjectArray;
	}

	function getConfigObject($key)
	{
		$configObjectArray =& $this->getConfigObjectArray();
		if (isset($configObjectArray[$key]))
		{
			$configObject =& $configObjectArray[$key];
		}
		else
		{
			$configObject = $this->get($key);
		}
		return $configObject;
	}

	function getActive($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
		if ($configObject->get('active') > 0)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getSearch($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
		return $configObject->get('search');
	}

	function getShowList($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
		return $configObject->get('show_list');
	}

	function getShowArticle($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
		return $configObject->get('show_article');
	}

	function getRequired($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
		return $configObject->getRequired();
	}

	function getShowName($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
		return $configObject->getShow('name');
	}

	function getInputType($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
		return $configObject->getInputType();
	}


	function getOptionValueArray($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
		return $configObject->getOptionValueArray();
	}

	function getDefaultValue($key)
	{
		$configObject =& $this->getConfigObject($key);
		if (!is_object($configObject)) return false;
//		return $configObject->getShow('default_value');
		return $configObject->get('default_value');
	}

	function getSearchKeyArray()
	{
		$sql = "SELECT col FROM ".$this->mTable." WHERE search=1";
		$result = $this->db->query($sql);
		if (!$result)
		{
			return false;
		}

		if ($this->db->getRowsNum($result) == 0)
		{
			return false;
		}

		$searchKeyArray = array();
		while ($row = $this->db->fetchArray($result))
		{
			$searchKeyArray[] = $row['col'];
		}
		return $searchKeyArray;
	}

	function getRequiredKeyArray()
	{
		$sql = "SELECT col FROM ".$this->mTable." WHERE active=2";
		$result = $this->db->query($sql);
		if (!$result)
		{
			return false;
		}

		if ($this->db->getRowsNum($result) == 0)
		{
			return false;
		}

		$requiredKeyArray = array();
		while ($row = $this->db->fetchArray($result))
		{
			$requiredKeyArray[] = $row['col'];
		}
		return $requiredKeyArray;
	}

	function getKeyConst($key)
	{
		$keyName = strtoupper($key);
		$keyConst = constant('_MD_XDBASE_LANG_'.$keyName);
		return $keyConst;
	}

}

?>
