<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Xdbase_AbstractAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

class Xdbase_AbstractAction
{
	var $mController = null;
	var $mModule = null;
	var $mTpl = null;

	/**
	 * @public
	 */
	function Xdbase_AbstractAction($controller)
	{
		$this->mController =& $controller;
		$this->mModule =& $this->mController->mModule;
		$this->mTpl =& $this->mController->mTpl;
	}

	/**
	 * @public
	 */
	function isMemberOnly()
	{
		return false;
	}

	/**
	 * @public
	 */
	function isAdminOnly()
	{
		return false;
	}

	/**
	 * @public
	 */
	function prepare()
	{
		$cssFile = XOOPS_ROOT_PATH.'/modules/'.$this->mController->mDirname.'/templates/style.css';
		if (file_exists($cssFile))
		{
			$css_link = "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"".XOOPS_URL."/modules/".$this->mController->mDirname."/templates/style.css\" />\n";
			$this->mTpl->assign('xoops_module_header', $this->mTpl->get_template_vars('xoops_module_header').$css_link);
		}
		return true;
	}

	/**
	 * @public
	 */
	function hasPermission()
	{
		return true;
	}

	/**
	 * @public
	 */
	function getDefaultView()
	{
		return XDBASE_FRAME_VIEW_NONE;
	}

	/**
	 * @public
	 */
	function execute()
	{
		return XDBASE_FRAME_VIEW_NONE;
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
	}

	/**
	 * @public
	 */
	function executeViewIndex()
	{
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
	}

	/**
	 * @public
	 */
	function executeViewPreview()
	{
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
	}
}

?>
