<?php
/**
 * @file
 * @package xdbase
 * @version $Id: xdbase_thumbnail_block.php,v 1.12 2011/08/27 10:38:22 bluemelon Exp $
 */

if (!defined('_XDBASE_THUMBNAIL_BLOCK_LOADED'))
{

define('_XDBASE_THUMBNAIL_BLOCK_LOADED', 1);

include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/include/function.php';
include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/language/'.$GLOBALS['xoopsConfig']['language'].'/blocks.php';
include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/language/'.$GLOBALS['xoopsConfig']['language'].'/main.php';


function b_xdbase_thumbnail_block_show($options)
{
	$mydirname = $options[0];
	$config_handler =& xoops_gethandler('config');
	$moduleConfig =& xdbaseGetConfigsByDirname($mydirname);
	$data_handler =& xdbaseGetModuleHandler('data', $mydirname);
	$cat_handler =& xdbaseGetModuleHandler('cat', $mydirname);
	$cat_handler->setTree($cat_handler->getCriteria());

	$limit = $options[1];
	$column = $options[2];
	if ($limit > 100) $limit = 100;
	$show_random = $options[3];
	$sort = $data_handler->getSort($options[4]);
	$order = $data_handler->getOrder($options[5]);
	$cid = $options[6];
	$include_subcat = $options[7];
	$where1_col = $options[8];
	$where1_operator = $options[9];
	$where1_value = $options[10];
	$where_condition = $options[11];
	$where2_col = $options[12];
	$where2_operator = $options[13];
	$where2_value = $options[14];
	$varchar_length = $options[15];

	$block = array();

	$criteria =& $data_handler->getCriteria();

	if ($cid != '')
	{
		$catCriteria = new Xdbase_CriteriaCompo();
		$catCriteria->add(new Xdbase_Criteria('cid', $cid));
		if ($include_subcat)
		{
			$cid_array =& $cat_handler->getAllChildId($cid);
			if (count($cid_array) > 0)
			{
				foreach ($cid_array as $chcid)
				{
					$catCriteria->add(new Xdbase_Criteria('cid', $chcid), 'OR');
				}
			}
		}
		$criteria->add($catCriteria);
	}

	if ($where1_col != '' && $where1_value != '' && $where1_operator != '')
	{
		$where1 = new Xdbase_CriteriaCompo();
		$where1->add(new Xdbase_Criteria($where1_col, $where1_value, $data_handler->getOperator($where1_operator)));
		$criteria->add($where1);
	}
	if ($where2_col != '' && $where2_value != '' && $where2_operator != '')
	{
		$where2 = new Xdbase_CriteriaCompo();
		$where2->add(new Xdbase_Criteria($where2_col, $where2_value, $data_handler->getOperator($where2_operator)), $data_handler->getCondition($where_condition));
		$criteria->add($where2);
	}

	if ($show_random)
	{
		$db =& Database::getInstance();
		$data_table_name = $db->prefix($mydirname.'_data');

		$sql ="SELECT did FROM `".$data_table_name."`";
		$where = $criteria->render();
		if ($where != '')
		{
			$sql .= " WHERE ".$where;
		}

		$result = $db->query($sql);
		if (!$result)
		{
			return false;
		}

		if ($db->getRowsNum($result) == 0)
		{
			return false;
		}

		$did_array = array();
		while (list($did) = $db->fetchRow($result)) $did_array[] = $did;

		$criteria = new Xdbase_CriteriaCompo();
		$rand_key_array = array_rand($did_array, $limit);
		if(is_array($rand_key_array))
		{
			foreach ($rand_key_array as $rand_key)
			{
				$criteria->add(new Xdbase_Criteria('did', $did_array[$rand_key]), 'OR');
			}
		}

		$dataObjectArray =& $data_handler->getObjects($criteria);

	}
	else
	{
		$criteria->setOrder($order);
		$criteria->setSort($sort);
		$criteria->setLimit($limit);

		$dataObjectArray =& $data_handler->getObjects($criteria);

	}



	$count = count($dataObjectArray);
	$data = array();
	for ($i = 0; $i < $count; $i++)
	{
		$data[$i] = $dataObjectArray[$i];
	}

	if ($moduleConfig['create_thumbnail'])
	{
		$thumbs_path = $moduleConfig['thumbs_path'];
	}
	else
	{
		$thumbs_path = $moduleConfig['photos_path'];
	}

	$block['data'] = $data;
	$block['varchar_length'] = $varchar_length;
	$block['thumbs_path'] = $thumbs_path;
	$block['image_size'] = $moduleConfig['thumbnail_image_size'];
	$block['column'] = $column;
	$block['column_width'] = intval(round(100 / $column));
	$block['mydirname'] = $mydirname;

	return $block;
}


function b_xdbase_thumbnail_block_edit($options)
{
	$form = '';
	$form .= '<input type="hidden" name="options[0]" value="'.$options[0].'" />';
	$form .= _MB_XDBASE_LIMIT.'&nbsp;:&nbsp;<input type="text" name="options[1]" value="'.$options[1].'" size="6" /><br />';
	$form .= _MB_XDBASE_COLUMN.'&nbsp;:&nbsp;<input type="text" name="options[2]" value="'.$options[2].'" size="6" /><br />';
	$form .= _MB_XDBASE_RANDOM.'&nbsp;:&nbsp;'.xdbaseBlockRenderYesNoRadioButton(3, $options).'<br />';
	$form .= _MB_XDBASE_SORT.'&nbsp;:&nbsp;'.xdbaseBlockRenderColSelect(4, $options).'<br />';
	$form .= _MB_XDBASE_ORDER.'&nbsp;:&nbsp;'.xdbaseBlockRenderOrderSelect(5, $options).'<br />';
	$form .= _MB_XDBASE_CATEGORY.'&nbsp;:&nbsp;'.xdbaseBlockRenderCatSelect(6, $options).'&nbsp;';
	$form .= _MB_XDBASE_INCLUDESUBCAT.'&nbsp;'.xdbaseBlockRenderYesNoRadioButton(7, $options).'<br />';
	$form .= _MB_XDBASE_WHERE1.'<br />';
	$form .= _MB_XDBASE_WHERE_COL.'&nbsp;:&nbsp;'.xdbaseBlockRenderColSelect(8, $options, true).'&nbsp;';
	$form .= _MB_XDBASE_WHERE_OPERATOR.'&nbsp;:&nbsp;'.xdbaseBlockRenderOperatorSelect(9, $options).'&nbsp';
	$form .= _MB_XDBASE_WHERE_VALUE.'&nbsp;:&nbsp;<input type="text" name="options[10]" value="'.$options[10].'" /><br />';
	$form .= _MB_XDBASE_WHERE_CONDITION.'&nbsp;:&nbsp;'.xdbaseBlockRenderConditionSelect(11, $options).'<br />';
	$form .= _MB_XDBASE_WHERE2.'<br />';
	$form .= _MB_XDBASE_WHERE_COL.'&nbsp;:&nbsp;'.xdbaseBlockRenderColSelect(12, $options, true).'&nbsp';
	$form .= _MB_XDBASE_WHERE_OPERATOR.'&nbsp;:&nbsp;'.xdbaseBlockRenderOperatorSelect(13, $options).'&nbsp';
	$form .= _MB_XDBASE_WHERE_VALUE.'&nbsp;:&nbsp;<input type="text" name="options[14]" value="'.$options[14].'" /><br />';
	$form .= _MB_XDBASE_VALCHARLENGTH.'&nbsp;:&nbsp;<input type="text" name="options[15]" value="'.$options[15].'" size="6"  />byte<br />';

	return $form;
}


}

?>
