<?php
/**
 * @file
 * @package xdbase
 * @version $Id: MySqlHandler.php,v 1.7 2011/08/27 10:38:22 bluemelon Exp $
 */

if (!defined('XDBASE_TRUST_DIRNAME')) exit;

class MySqlHandler
{
	var $protectedTableList = array(
			'avatar',
			'avatar_user_link',
			'banner',
			'bannerclient',
			'bannerfinish',
			'block_module_link',
			'config',
			'configcategory',
			'configoption',
			'group_permission',
			'groups',
			'groups_users_link',
			'image',
			'imagebody',
			'imagecategory',
			'imgset',
			'imgset_tplset_link',
			'imgsetimg',
			'modules',
			'newblocks',
			'online',
			'priv_msgs',
			'protector_access',
			'protector_log',
			'ranks',
			'session',
			'smiles',
			'tplfile',
			'tplset',
			'tplsource',
			'user_mailjob',
			'user_mailjob_link',
			'users'
		);
	var $message = array();
	var $db = null;
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function MySqlHandler()
	{
		$this->__construct();
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function __construct()
	{
		$this->db =& Database::getInstance();
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getRetArray($value)
	{
		$retArray = array($value, $this->message);
		return $retArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setMessage($str)
	{
		if (!is_null($str))
		{
			array_push($this->message, htmlspecialchars($str, ENT_QUOTES));
		}
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// get all tables list without protected tables
	function getTableList()
	{
		$sql ='SHOW TABLES FROM `'.XOOPS_DB_NAME.'`';
		if (!$result = $this->db->queryF($sql))
		{
			die('DB Error : '.$this->db->error().'   SQL : '.$sql);
		}

		static $tableArray;

		if (is_array($tableArray))
		{
			return $tableArray;
		}

		$i = 0;
		while ($row = $this->db->fetchArray($result))
		{
			$rowName = 'Tables_in_'.XOOPS_DB_NAME;
//			$tableName = htmlspecialchars($row[$rowName], ENT_QUOTES);
			$tableName = $row[$rowName];
			$tablePrefix = $this->db->prefix();
			$checkedTableName = preg_replace('/'.$tablePrefix.'_/', '', $tableName);

			if (!in_array($checkedTableName, $this->protectedTableList))
			{
				$tableArray[$i] = $checkedTableName;
				$i++;
			}
		}
		return $tableArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getTableName($tableName)
	{
		if ($tableName != '')
		{
			if (in_array($tableName, $this->getTableList()))
			{
				return $this->db->prefix($tableName);
			}
			else
			{
				$str = 'Invalid TableName : '.$tableName;
				$this->setMessage($str);
				return false;
			}
		}
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// get column list
	function getColumnOptionArray($tableName)
	{
		$tableName = $this->getTableName($tableName);
		if (!$tableName)
		{
			return $this->getRetArray(false);
		}

		$sql ='SHOW COLUMNS FROM `'.$tableName.'` FROM `'.XOOPS_DB_NAME.'`';
		if (!$result = $this->db->query($sql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$sql;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

		$optionArray = array();
		$i = 0;
		while ($row = $this->db->fetchArray($result))
		{
			$optionArray[$i]['field'] = $row['Field'];
			$optionArray[$i]['value'] = $row['Field'];
			$optionArray[$i]['type'] = $row['Type'];
			$optionArray[$i]['selected'] = '';
			$i++;
		}
		return $this->getRetArray($optionArray);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getCatColumnKeyArray()
	{
		$keyArray = array(
			'cid',
			'pid',
			'title',
			'description',
			'img',
			'img_height',
			'img_width',
			'weight',
			'status',
			'access',
			'groups',
			'created_date',
			'updated_date',
			'show_map',
			'latitude',
			'longitude',
			'zoom',
			'icon',
			'icon_width',
			'icon_height',
			'int01',
			'int02',
			'int03'
		);
		return $keyArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getColumnKeyArray()
	{
		$keyArray = array(
			'did',
			'cid',
			'title',
			'tag',
			'pid',
			'uid',
			'name',
			'poster_ip',
			'created_date',
			'updated_date',
			'published_date',
			'expired_date',
			's_date',
			'e_date',
			'password',
			'url',
			'email',
			'zip',
			'state',
			'city',
			'street',
			'phone',
			'mobile_phone',
			'fax',
			'show_map',
			'latitude',
			'longitude',
			'zoom',
			'img01',
			'img01_height',
			'img01_width',
			'img02',
			'img02_height',
			'img02_width',
			'file01',
			'file01name',
			'file01ext',
			'file01size',
			'body',
			'int01',
			'int02',
			'int03',
			'int04',
			'int05',
			'int06',
			'int07',
			'int08',
			'int09',
			'int10',
			'float01',
			'float02',
			'varchar01',
			'varchar02',
			'varchar03',
			'varchar04',
			'varchar05',
			'varchar06',
			'varchar07',
			'varchar08',
			'varchar09',
			'varchar10',
			'text01',
			'text02',
			'reservation',
			'option_value',
			'weight',
			'status',
			'access',
			'groups',
			'hits',
			'comments',
			'rating',
			'votes',
			'downloads',
			'trackbacks',
			'pipe_id',
			'dohtml',
			'doxcode',
			'dosmiley',
			'doimage',
			'dobr'
		);
		return $keyArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getColumnArray($prefix)
	{
		$myts =& MyTextSanitizer::getInstance();
		if ($prefix == 'cat')
		{
			$keyArray = $this->getCatColumnKeyArray();
		}
		else
		{
			$keyArray = $this->getColumnKeyArray();
		}
		$columnArray = array();

		foreach ($keyArray as $key)
		{
			$prefixKey = $prefix.'_'.$key;
			$value = $myts->addSlashes(xdbaseGetRequest($prefixKey));
			if ($value != '')
			{
				$columnArray[$key] = $value;
			}
		}

		return $columnArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function truncateTable($tableName)
	{
		$tableName = $this->getTableName($tableName);
		if (!$tableName)
		{
			return $this->getRetArray(false);
		}
		$sql = 'TRUNCATE TABLE `'.$tableName.'`';
		if (!$result = $this->db->query($sql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$sql;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}
		else
		{
			return $this->getRetArray(true);
		}
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function importDataFromTable($tableFromName, $tableToName, $prefix='')
	{
		$myts =& MyTextSanitizer::getInstance();
		$tableFromName = $this->getTableName($tableFromName);
		if (!$tableFromName)
		{
			return $this->getRetArray(false);
		}
		$tableToName = $this->getTableName($tableToName);
		if (!$tableToName)
		{
			return $this->getRetArray(false);
		}

		$columnArray = $this->getColumnArray($prefix);
		$columnToArray = array_keys($columnArray);
		$columnFromArray = array_values($columnArray);

		if (count($columnFromArray) == 0 || count($columnToArray) == 0)
		{
			return $this->getRetArray(false);
		}

		$importFromSql = 'SELECT '.implode(',', $columnFromArray).' FROM `'.$tableFromName.'`';
		$importToSql = 'INSERT INTO `'.$tableToName.'` ('.implode(',', $columnToArray).') VALUES ';

		if (!$result = $this->db->query($importFromSql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$importFromSql;;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}
		$rowCount = $this->db->getRowsNum($result);
		$i = 1;
		while ($row = $this->db->fetchArray($result))
		{
			$importFromValueArray = array();
			foreach ($columnFromArray as $importFrom)
			{
				array_push($importFromValueArray, $this->db->quoteString($row[$importFrom]));
			}
			if ($i == $rowCount)
			{
				$importToSql .= '('.implode(',',$importFromValueArray).')';
			}
			else
			{
				$importToSql .= '('.implode(',',$importFromValueArray).'),';
			}
			$i++;
		}
		if (!$result = $this->db->query($importToSql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$importToSql;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}
		$str = $rowCount.' records were inserted from '.$tableFromName.' to '.$tableToName;
		$this->setMessage($str);

		return $this->getRetArray(true);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function updateDataFromTable($tableFromName, $tableToName, $prefix='', $keyColumn='')
	{
		$myts =& MyTextSanitizer::getInstance();
		$tableFromName = $this->getTableName($tableFromName);
		if (!$tableFromName)
		{
			return $this->getRetArray(false);
		}
		$tableToName = $this->getTableName($tableToName);
		if (!$tableToName)
		{
			return $this->getRetArray(false);
		}

		$columnArray = $this->getColumnArray($prefix);
		$columnToArray = array_keys($columnArray);
		$columnFromArray = array_values($columnArray);

		if (!$columnNameToKey = $myts->addSlashes(xdbaseGetRequest($prefix.'_'.$keyColumn)))
		{
			$str = 'Key Field is not found : '.$columnNameToKey;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

		$updateFromSql = 'SELECT '.implode(',', $columnFromArray).' FROM `'.$tableFromName.'`';

		if (!$result = $this->db->query($updateFromSql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$updateFromSql;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}
		$rowCount = $this->db->getRowsNum($result);
		$i = 0;
		$updateToSqlArray = array();
		while ($row = $this->db->fetchArray($result))
		{
			$updateToSql = 'UPDATE '.$tableToName.' SET ';
			$a = 0;
			$toCount = count($columnToArray);
			foreach ($columnToArray as $updateTo)
			{
//				$updateToSql .= $updateTo.'='.$this->db->quoteString($row[$columnFromArray[$a]]);
				$updateToSql .= '`'.$updateTo.'`='.$this->db->quoteString($row[$columnFromArray[$a]]);
				$a++;
				if ($a == $toCount)
				{
					$updateToSql .= ' WHERE '.$myts->addSlashes($keyColumn).'='.intval($row[$columnNameToKey]);
				}
				else
				{
					$updateToSql .= ',';
				}
			}

			$updateToSqlArray[$i] = $updateToSql;
			$i++;
		}

		foreach ($updateToSqlArray as $updateSql)
		{
			if (!$result = $this->db->query($updateSql))
			{
				$str = 'DB Error : '.$this->db->error().'   SQL : '.$updateSql;
				$this->setMessage($str);
				return $this->getRetArray(false);
			}
		}
		$str = $rowCount.' records were updated from '.$tableFromName.' to '.$tableToName;
		$this->setMessage($str);
		return $this->getRetArray(true);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// import from vcf,contact
	function importDataFromArray($tableToName, $dataRowArray)
	{
		$rowCount = count($dataRowArray);
		if ($rowCount == 0)
		{
			return $this->getRetArray(false);
		}

		$columnArray = array_shift($dataRowArray);
		$rowCount = $rowCount -1;
		foreach ($columnArray as $column)
		{
			if (!in_array($column, $this->getColumnKeyArray()))
			{
				$str = 'Invalid column : '.$column;
				$this->setMessage($str);
				return $this->getRetArray(false);
			}
		}

		$tableToName = $this->getTableName($tableToName);
		$importToSql = 'INSERT INTO '.$tableToName.' ('.implode(',', $columnArray).') VALUES ';

		$i = 1;
		foreach ($dataRowArray as $dataRow)
		{
			$importFromValueArray = array();
			foreach ($dataRow as $data)
			{
				array_push($importFromValueArray, $this->db->quoteString($data));
			}

			if ($i == $rowCount)
			{
				$importToSql .= '('.implode(',',$importFromValueArray).')';
			}
			else
			{
				$importToSql .= '('.implode(',',$importFromValueArray).'),';
			}
			$i++;
		}

		unset($dataRowArray);

		$importToSql = mb_convert_encoding($importToSql, _CHARSET, "auto");

		if (!$result = $this->db->query($importToSql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$importToSql;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

		$str = $rowCount.' records were inserted from DataArray to '.$tableToName;
		$this->setMessage($str);

		unset($importToSql);

		return $this->getRetArray(true);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// export to vcf,contact
	function getExportDataArrayFromTable($tableFromName)
	{
		$tableFromName = $this->getTableName($tableFromName);
		if (!$tableFromName)
		{
			return $this->getRetArray(false);
		}

		$importFromSql = 'SELECT * FROM `'.$tableFromName.'`';

		if (!$result = $this->db->query($importFromSql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$importFromSql;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

		$rowCount = $this->db->getRowsNum($result);
		if ($rowCount == 0)
		{
			$str = 'No Record ';
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

		$memory_limit = (ini_get('memory_limit') * 1024 * 1024);
		$dataArray = array();
		$i = 0;

		while ($row = $this->db->fetchArray($result))
		{
			if (memory_get_usage() < $memory_limit - 200000)
			{
				$i++;
				$dataArray[$i] = $row;
			}
			else
			{
				break;
			}
		}

		return $this->getRetArray($dataArray);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// import from csv
	function importCSVDataFromArray($tableToName, $csvArray, $columnArray)
	{
		$columnCount = count($csvArray);

		$tableToName = $this->getTableName($tableToName);
		$importToSql = 'INSERT INTO '.$tableToName.' ('.implode(',', $columnArray).') VALUES ';
		$importToSql .= '(';
		$i = 1;
		foreach ($csvArray as $string)
		{
			$importToSql .= '"'.$string.'"';
			if ($i != $columnCount)
			{
				$importToSql .= ',';
			}
			$i++;
		}
		$importToSql .= ')';
//		$importToSql = mb_convert_encoding($importToSql, _CHARSET, 'auto');

//		if (!$result = $this->db->query($importToSql))
		if (!$result = mysql_unbuffered_query($importToSql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$importToSql;
			return $str;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

//		unset($result);
//		unset($csvArray);
//		unset($importToSql);

		return false;
//		return $this->getRetArray(true);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	// export to csv
	function getExportCSVDataFromTable($tableFromName)
	{
		$tableFromName = $this->getTableName($tableFromName);
		if (!$tableFromName)
		{
			return $this->getRetArray(false);
		}

		$importFromSql = 'SELECT * FROM `'.$tableFromName.'`';

		if (!$result = $this->db->query($importFromSql))
		{
			$str = 'DB Error : '.$this->db->error().'   SQL : '.$importFromSql;
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

		$rowCount = $this->db->getRowsNum($result);
		if ($rowCount == 0)
		{
			$str = 'No Record ';
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

		$memory_limit = (ini_get('memory_limit') * 1024 * 1024);
		$dataArray = array();
		$dataArray[0] = $this->getColumnKeyArray();

		$rowCount = $this->db->getRowsNum($result);
		while ($row = $this->db->fetchArray($result))
		{
			if (memory_get_usage() < $memory_limit - 200000)
			{
				$dataArray[] = array_map('addslashes', $row);
			}
			else
			{
				break;
			}
		}

		return $this->getRetArray($dataArray);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
}

?>
