<?php
/**
 * @file
 * @package xdbase
 * @version $Id: ConvertDataAction.class.php,v 1.11 2011/08/27 10:38:22 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';


class Xdbase_Admin_ConvertDataAction extends Xdbase_AbstractEditAction
{
	var $templateName = null;
	var $tableList = array();
	var $message = array();
	var $datatype = null;
	var $progress = null;

	var $catTableFrom = null;
	var $dataTableFrom = null;
	var $catTableTo = null;
	var $dataTableTo = null;
	var $mySqlHandler = null;


	/**
	 * @protected
	 */
	function _setupActionForm()
	{
	}

	/**
	 * @public
	 */
	function prepare()
	{
//		parent::prepare();
		$this->_setupActionForm();
		$this->_setupTemplateName();
		$this->_setupRequestParameter();
		$this->_setupTableName();
		$this->_setupMySqlHandler();
	}

	/**
	 * @protected
	 */
	function _setupTemplateName()
	{
	}

	function _setupTableName()
	{
	}

	/**
	 * @protected
	 */
	function _setupRequestParameter()
	{
		$this->datatype = intval(xdbaseGetRequest('datatype'));
		$this->progress = intval(xdbaseGetRequest('progress'));
	}

	/**
	 * @protected
	 */
	function _setupMySqlHandler()
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/MySqlHandler.php';
		$this->mySqlHandler =& new MySqlHandler();
	}


	/**
	 * @public
	 */
	function getDefaultView()
	{
		return XDBASE_FRAME_VIEW_INPUT;
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('progress', $this->progress);
		$this->mTpl->assign('datatype', $this->datatype);

		switch ($this->progress)
		{
			case 1:
				switch ($this->datatype)
				{
					case 1:// MySql
						$this->mTpl->assign('tableArray', $this->mySqlHandler->getTableList());
						break;
					default:// CSV, ContactXML, VCard
//						$this->mTpl->assign('filePath', _MD_XDBASE_CONST_FILES_PATH.'/');
						break;
				}
				break;
			case 2:
				switch ($this->datatype)
				{
					case 1:// MySql
						$this->setColumnList();
						break;
					default:// CSV, ContactXML, VCard
						break;
				}
				break;
		}

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/'.$this->templateName);

	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function execute()
	{
		if (xdbaseGetRequest('_form_control_cancel') != null)
		{
			return XDBASE_FRAME_VIEW_CANCEL;
		}

		if ($this->progress < 3)
		{
			return XDBASE_FRAME_VIEW_INPUT;
		}

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if ($this->mActionForm->hasError())
		{
			return XDBASE_FRAME_VIEW_INPUT;
		}
		else
		{
			return $this->_doExecute();
		}
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function _doExecute()
	{
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setColumnList()
	{
		list($catColumnFromArray, $messageArray) = $this->mySqlHandler->getColumnOptionArray($this->catTableFrom);
		$this->setMessage($messageArray);
//		if ($catColumnFromArray === false) return XDBASE_FRAME_VIEW_ERROR;

		list($catColumnToArray, $messageArray) = $this->mySqlHandler->getColumnOptionArray($this->catTableTo);
		$this->setMessage($messageArray);
//		if ($catColumnToArray === false) return XDBASE_FRAME_VIEW_ERROR;

		list($dataColumnFromArray, $messageArray) = $this->mySqlHandler->getColumnOptionArray($this->dataTableFrom);
		$this->setMessage($messageArray);
//		if ($dataColumnFromArray === false) return XDBASE_FRAME_VIEW_ERROR;

		list($dataColumnToArray, $messageArray) = $this->mySqlHandler->getColumnOptionArray($this->dataTableTo);
		$this->setMessage($messageArray);
//		if ($dataColumnToArray === false) return XDBASE_FRAME_VIEW_ERROR;

		$this->mTpl->assign('catColumnFromArray', $catColumnFromArray);
		$this->mTpl->assign('catColumnToArray', $catColumnToArray);
		$this->mTpl->assign('catTableFrom', htmlspecialchars($this->catTableFrom, ENT_QUOTES));
		$this->mTpl->assign('catTableTo', $this->catTableTo);
		$this->mTpl->assign('dataColumnFromArray', $dataColumnFromArray);
		$this->mTpl->assign('dataColumnToArray', $dataColumnToArray);
		$this->mTpl->assign('dataTableFrom', htmlspecialchars($this->dataTableFrom, ENT_QUOTES));
		$this->mTpl->assign('dataTableTo', $this->dataTableTo);
		$this->mTpl->assign('retMessage', $this->getMessage());
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function truncateTable()
	{
		$truncateCat = intval(xdbaseGetRequest('truncate_cat'));
		$truncateData = intval(xdbaseGetRequest('truncate_data'));

		if ($truncateCat)
		{
			list($ret, $messageArray) = $this->mySqlHandler->truncateTable($this->catTableTo);
			$this->setMessage($messageArray);
			if ($ret == false) return false;
		}

		if ($truncateData)
		{
			list($ret, $messageArray) = $this->mySqlHandler->truncateTable($this->dataTableTo);
			$this->setMessage($messageArray);
			if ($ret == false) return false;
		}
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setMessage($message)
	{
		if (is_array($message))
		{
//			array_push($this->message, implode('<br />', $message));
			array_push($this->message, implode('<br />', array_map('htmlspecialchars', $message)));
		}
		elseif (!is_null($message))
		{
//			array_push($this->message, $message);
			array_push($this->message, htmlspecialchars($message));
		}
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getMessage()
	{
		$retMessage = '';
		if (count($this->message) > 0)
		{
			$retMessage = implode('<br />', $this->message);
		}
		return $retMessage;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$retMessage = 'Import Successed<br />'.$this->getMessage();
		$this->mTpl->assign('retMessage', $retMessage);
		$this->mTpl->assign('progress', 5);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/import.html');
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @public
	 */
	function executeViewError()
	{
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @public
	 */
	function executeViewCancel()
	{
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

?>
