<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_configEditForm.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_ActionForm.class.php';

class Xdbase_Admin_Data_configEditForm extends Xdbase_ActionForm
{
	/**
	 * @public
	 */
	function getTokenName()
	{
		return 'module.xdbase.Admin_Data_configEditForm.TOKEN';
	}

	/**
	 * @public
	 */
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['configid'] =& new Xdbase_IntProperty('configid');
		$this->mFormProperties['col'] =& new Xdbase_StringProperty('col');
		$this->mFormProperties['name'] =& new Xdbase_StringProperty('name');
		$this->mFormProperties['active'] =& new Xdbase_IntProperty('active');
		$this->mFormProperties['search'] =& new Xdbase_BoolProperty('search');
		$this->mFormProperties['show_list'] =& new Xdbase_BoolProperty('show_list');
		$this->mFormProperties['show_article'] =& new Xdbase_BoolProperty('show_article');
		$this->mFormProperties['input_type'] =& new Xdbase_IntProperty('input_type');
		$this->mFormProperties['option_value'] =& new Xdbase_TextProperty('option_value');
		$this->mFormProperties['default_value'] =& new Xdbase_TextProperty('default_value');

		$this->mFormProperties['option_list'] =& new Xdbase_TextArrayProperty('option_list');
		$this->mFormProperties['option_value_key'] =& new Xdbase_IntArrayProperty('option_value_key');
		$this->mFormProperties['option_value_value'] =& new Xdbase_TextArrayProperty('option_value_value');

		//
		// Set field properties
		//
//		$this->mFieldProperties['configid'] =& new Xdbase_FieldProperty($this);
//		$this->mFieldProperties['configid']->setDependsByArray(array('required'));
//		$this->mFieldProperties['configid']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CONFIGID);

		$this->mFieldProperties['col'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['col']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['col']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_COL, '30');
		$this->mFieldProperties['col']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_COL, '30');
		$this->mFieldProperties['col']->addVar('maxlength', '30');

		$this->mFieldProperties['name'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['name']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['name']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_COLNAME, '100');
		$this->mFieldProperties['name']->addVar('maxlength', '100');

//		$this->mFieldProperties['input_type'] =& new Xdbase_FieldProperty($this);
//		$this->mFieldProperties['input_type']->setDependsByArray(array('required'));
//		$this->mFieldProperties['input_type']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INPUT_TYPE);

	}

	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('configid', $obj->get('configid'));
		$this->set('col', $obj->get('col'));
		$this->set('name', $obj->get('name'));
		$this->set('active', $obj->get('active'));
		$this->set('search', $obj->get('search'));
		$this->set('show_list', $obj->get('show_list'));
		$this->set('show_article', $obj->get('show_article'));
		$this->set('input_type', $obj->get('input_type'));
		$this->set('option_value', $obj->get('option_value'));
		$this->set('default_value', $obj->get('default_value'));

		$this->set('option_list', $obj->getOptionValueArray());
	}

	/**
	 * @public
	 */
	function update(&$obj)
	{
		$obj->set('configid', $this->get('configid'));
		$obj->set('col', $this->get('col'));
		$obj->set('name', $this->get('name'));
		$obj->set('active', $this->get('active'));
		$obj->set('search', $this->get('search'));
		$obj->set('show_list', $this->get('show_list'));
		$obj->set('show_article', $this->get('show_article'));
		$obj->set('input_type', $this->get('input_type'));
//		$obj->set('option_value', $this->get('option_value'));
		$obj->set('option_value', $this->getOptionValue());
		$obj->set('default_value', $this->get('default_value'));
	}

	function getOptionValue()
	{
		if (!is_array($this->get('option_value_key'))) return '';

		$optionValueArray = array();
		$max = count($this->get('option_value_key'));
		for ($i = 0; $i < $max; $i++)
		{
			$option_value_key = intval($this->get('option_value_key', $i));
			$option_value_value = htmlspecialchars($this->get('option_value_value', $i), ENT_QUOTES);
			if (($option_value_key !== '') && ($option_value_value !== ''))
			{
				$optionValueArray[$option_value_key] = $option_value_value;
			}
		}
		ksort($optionValueArray);
		$optionValue = serialize($optionValueArray);
		return $optionValue;
	}

}

?>
