<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_configListAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractListAction.class.php';

class Xdbase_Admin_Data_configListAction extends Xdbase_AbstractListAction
{
	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_config');
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_getFilterForm()
	{
		$filter =& $this->mController->create('filter', 'admin.data_config');
		$filter->prepare($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	/**
	 * @protected
	 */
	function _getBaseUrl()
	{
		return './index.php?action=Data_configList';
	}


	function prepare()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_data_config_list');
		$this->mActionForm->prepare();
		return true;
	}

	function execute()
	{
		if (xdbaseGetRequest('_form_control_cancel') != null)
		{
			return XDBASE_FRAME_VIEW_CANCEL;
		}

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if ($this->mActionForm->hasError())
		{
			return $this->_processConfirm();
		}
		else
		{
			return $this->_processSave();
		}
	}

	function _processConfirm()
	{
		$handler =& $this->mController->load('handler', 'data_config');
		$configObjectArray =& $handler->getObjects();

		//
		// Do mapping.
		//
		foreach ($configObjectArray as $configObject)
		{
			$this->mObjects[$configObject->get('col')] =& $configObject;
			$col = $configObject->get('col');
			if ($this->mActionForm->get('active', $col) == '')
			{
				$this->mActionForm->set('active', $col, 0);
			}
			if ($this->mActionForm->get('search', $col) == '')
			{
				$this->mActionForm->set('search', $col, 0);
			}
			if ($this->mActionForm->get('show_list', $col) == '')
			{
				$this->mActionForm->set('show_list', $col, 0);
			}
			if ($this->mActionForm->get('show_article', $col) == '')
			{
				$this->mActionForm->set('show_article', $col, 0);
			}
			unset($configObject);
		}

		return XDBASE_FRAME_VIEW_INPUT;
	}

	function _processSave()
	{
		$handler =& $this->mController->load('handler', 'data_config');
		$configObjectArray =& $handler->getObjects();

		$successFlag = true;
		foreach ($configObjectArray as $configObject)
		{
			$col = $configObject->get('col');
			$olddata['name'] = $configObject->get('name');
			$olddata['active'] = $configObject->get('active');
			$olddata['search'] = $configObject->get('search');
			$olddata['show_list'] = $configObject->get('show_list');
			$olddata['show_article'] = $configObject->get('show_article');
			$olddata['input_type'] = $configObject->get('input_type');
			$olddata['default_value'] = $configObject->get('default_value');

			$newdata['name'] = $this->mActionForm->get('name', $col);
			$newdata['active'] = $this->mActionForm->get('active', $col) ? $this->mActionForm->get('active', $col) : 0;
			$newdata['search'] = $this->mActionForm->get('search', $col) ? $this->mActionForm->get('search', $col) : 0;
			$newdata['show_list'] = $this->mActionForm->get('show_list', $col) ? $this->mActionForm->get('show_list', $col) : 0;
			$newdata['show_article'] = $this->mActionForm->get('show_article', $col) ? $this->mActionForm->get('show_article', $col) : 0;
			$newdata['input_type'] = $this->mActionForm->get('input_type', $col);
			$newdata['default_value'] = $this->mActionForm->get('default_value', $col);

			if (count(array_diff_assoc($olddata, $newdata)) > 0 )
			{
				$configObject->set('name', $this->mActionForm->get('name', $col));
				$configObject->set('active', $this->mActionForm->get('active', $col));
				$configObject->set('search', $this->mActionForm->get('search', $col));
				$configObject->set('show_list', $this->mActionForm->get('show_list', $col));
				$configObject->set('show_article', $this->mActionForm->get('show_article', $col));
				$configObject->set('input_type', $this->mActionForm->get('input_type', $col));
				$configObject->set('default_value', $this->mActionForm->get('default_value', $col));

				if ($handler->insert($configObject))
				{
					$successFlag &= true;
				}
				else
				{
					$successFlag = false;
				}
			}
		}
		return $successFlag ? XDBASE_FRAME_VIEW_SUCCESS : XDBASE_FRAME_VIEW_ERROR;
	}

	/**
	 * @public
	 */
	function executeViewIndex()
	{
		$this->mTpl->assign('objects', $this->mObjects);
		$this->mTpl->assign('pageNavi', $this->mFilter->mNavi);
		$this->mTpl->assign('actionForm', $this->mActionForm);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/data_config_list.html');
	}

	function executeViewInput()
	{
		$this->mTpl->assign('objects', $this->mObjects);
		$this->mTpl->assign('actionForm', $this->mActionForm);

		$t_arr = $this->mActionForm->get('name');
		$this->mTpl->assign('cols', array_keys($t_arr));

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/data_config_list_confirm.html');
	}

	function executeViewSuccess()
	{
//		$this->mController->executeRedirect('./index.php?action=Data_configList', 3, _MD_XDBASE_MESSAGE_DBUPDATE_SUCCESSED);
		$this->mController->executeForward('./index.php?action=Data_configList');
	}

	function executeViewError()
	{
//		$this->mController->executeRedirect('./index.php?action=Data_configList', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
		$this->mController->executeForward('./index.php?action=Data_configList');
	}

	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Data_configList');
	}
// added by hiro



}

?>
