<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Xdbase_Controller.class.php,v 1.16 2010/06/16 10:27:09 bluemelon Exp $
 */

include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/include/function.php';
include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_Criteria.class.php';
include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_PageNavigator.class.php';

define('XDBASE_FRAME_PERFORM_SUCCESS', 1);
define('XDBASE_FRAME_PERFORM_FAIL', 2);
define('XDBASE_FRAME_INIT_SUCCESS', 3);

define('XDBASE_FRAME_VIEW_NONE', 'none');
define('XDBASE_FRAME_VIEW_SUCCESS', 'success');
define('XDBASE_FRAME_VIEW_ERROR', 'error');
define('XDBASE_FRAME_VIEW_INDEX', 'index');
define('XDBASE_FRAME_VIEW_INPUT', 'input');
define('XDBASE_FRAME_VIEW_PREVIEW', 'preview');
define('XDBASE_FRAME_VIEW_CANCEL', 'cancel');

class Xdbase_Controller
{
	var $mDirname = '';
	var $mTrustDirname = XDBASE_TRUST_DIRNAME;
	var $mTpl = null;
	var $mXoopsModule = null;
	var $mModuleConfig = null;
	var $mXoopsUser = null;
	var $mActionName = null;
	var $mAction = null;
	var $mAdminFlag = false;
	var $mAssetList = array();
	var $_mCache = array();


	function Xdbase_Controller($dirname)
	{
		$this->mDirname = $dirname;
	}

	function &getInstance($dirname)
	{
		static $instance;
		if(!isset($instance)) 
		{
			$instance = new Xdbase_Controller($dirname);
		}
		return $instance;
	}

	function prepare()
	{
		$this->mXoopsModule = $GLOBALS['xoopsModule'];
		$this->mXoopsUser = $GLOBALS['xoopsUser'];
		if (!isset($GLOBALS['xoopsTpl']))
		{
			require_once XOOPS_ROOT_PATH . '/class/template.php';
			$this->mTpl = new XoopsTpl();
		}
		else
		{
			$this->mTpl = $GLOBALS['xoopsTpl'];
		}
		$this->setModuleConfigConst();
		$this->setActionName();

		// TODO/Insert your initialization code.

	}

	function setAdminMode($flag)
	{
		$this->mAdminFlag = $flag;
	}

	function setActionName()
	{
		if ($this->mActionName == null)
		{
			$this->mActionName = xdbaseGetRequest('action');
			if ($this->mActionName == null)
			{
				if (!$this->mAdminFlag)
				{
					// TODO insert your default action name
					$this->mActionName = 'DataList';
				}
				else
				{
					// for Cube 2.1
					if (defined('XOOPS_CUBE_LEGACY'))
					{
						$this->executeForward(XOOPS_URL.'/modules/legacy/admin/index.php?action=PreferenceEdit&confmod_id='.$this->mXoopsModule->getVar('mid'));
					}
					else
					{
						$this->executeForward(XOOPS_URL.'/modules/system/admin.php?fct=preferences&op=showmod&mod='.$this->mXoopsModule->getVar('mid'));
					}
				}
			}

		}
	}

	function execute()
	{
		if (!preg_match('/^\w+$/', $this->mActionName))
		{
			$this->doActionNotFoundError();
			die();
		}

		$fileName = ucfirst($this->mActionName) . 'Action';
		if ($this->mAdminFlag)
		{
			$className = 'Xdbase_Admin_'.ucfirst($this->mActionName).'Action';
			$fileName = XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/actions/'.$fileName.'.class.php';
		}
		else
		{
			$className = 'Xdbase_'.ucfirst($this->mActionName).'Action';
			$fileName = XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/actions/'.$fileName.'.class.php';
		}

		if (!file_exists($fileName))
		{
			$this->doActionNotFoundError();
			die();
		}

		require_once $fileName;

		if (class_exists($className))
		{
			$this->mAction =& new $className($this);
		}

		if (!is_object($this->mAction))
		{
			$this->doActionNotFoundError();
			die();
		}

		if ($this->mAction->isAdminOnly() && !xdbaseIsAdmin())
		{
			$this->doPermissionError();
			die();
		}

		if ($this->mAction->prepare() === false)
		{
			$this->doPreparationError();
			die();
		}

		if (!$this->mAction->hasPermission())
		{
			$this->doPermissionError();
			die();
		}

		if (xoops_getenv('REQUEST_METHOD') == 'POST')
		{
			$viewStatus = $this->mAction->execute();
		}
		else
		{
			$viewStatus = $this->mAction->getDefaultView();
		}

		switch($viewStatus)
		{
			case XDBASE_FRAME_VIEW_SUCCESS:
				$this->mAction->executeViewSuccess();
				break;
			case XDBASE_FRAME_VIEW_ERROR:
				$this->mAction->executeViewError();
				break;
			case XDBASE_FRAME_VIEW_INDEX:
				$this->mAction->executeViewIndex();
				break;
			case XDBASE_FRAME_VIEW_INPUT:
				$this->mAction->executeViewInput();
				break;
			case XDBASE_FRAME_VIEW_PREVIEW:
				$this->mAction->executeViewPreview();
				break;
			case XDBASE_FRAME_VIEW_CANCEL:
				$this->mAction->executeViewCancel();
				break;
			default:
				break;
		}
	}


	/**
	 * @private
	 */
	function doPermissionError()
	{
		$this->executeForward(XOOPS_URL);
		return;
	}

	/**
	 * @private
	 */
	function doActionNotFoundError()
	{
		$this->executeForward(XOOPS_URL);
		return;
	}

	/**
	 * @private
	 */
	function doPreparationError()
	{
		$this->executeForward(XOOPS_URL);
		return;
	}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setModuleConfigConst()
	{

		$configHandler =& xoops_gethandler('config');
		$this->mModuleConfig =& $configHandler->getConfigsByCat(0,$this->mXoopsModule->getVar('mid'));

		if (!defined('XDBASE_MODULE_CONFIG_CONST_LOADED'))
		{
			define('XDBASE_MODULE_CONFIG_CONST_LOADED', 1);

			define('_MD_XDBASE_CONST_GUEST', $GLOBALS['xoopsConfig']['anonymous']);
			define('_MD_XDBASE_CONST_MODULENAME', $this->mXoopsModule->getVar('name'));
			define('_MD_XDBASE_CONST_MODULEDIRNAME', $this->mXoopsModule->getVar('dirname'));
			define('_MD_XDBASE_CONST_NUMPERPAGE', $this->mModuleConfig['numperpage']);
			define('_MD_XDBASE_CONST_SELECTPERPAGE', $this->mModuleConfig['select_perpage']);
			define('_MD_XDBASE_CONST_DISPBREADCRUMB', $this->mModuleConfig['display_breadcrumb']);
			define('_MD_XDBASE_CONST_DISPLISTPAGENAV', $this->mModuleConfig['display_listpagenavi']);
			define('_MD_XDBASE_CONST_DISPDETAILPAGENAV', $this->mModuleConfig['display_detailpagenavi']);
			define('_MD_XDBASE_CONST_DISPSORTNAV', $this->mModuleConfig['display_sortnavi']);
			define('_MD_XDBASE_CONST_DEFAULTSORT', $this->mModuleConfig['default_sort']);
			define('_MD_XDBASE_CONST_DEFAULTORDER', $this->mModuleConfig['default_order']);
			define('_MD_XDBASE_CONST_LIST_TPT', $this->getListTemplate());
			define('_MD_XDBASE_CONST_VIEW_TPT', $this->getViewTemplate());
//			define('_MD_XDBASE_CONST_LIST_TPT', $this->mModuleConfig['list_template']);
//			define('_MD_XDBASE_CONST_VIEW_TPT', $this->mModuleConfig['view_template']);
			define('_MD_XDBASE_CONST_DISPLAYCATNAV', $this->mModuleConfig['display_catnavi']);
			define('_MD_XDBASE_CONST_DISPLAYSUBCATNUM', $this->mModuleConfig['display_subcatnum'] + 1);
			define('_MD_XDBASE_CONST_DISPLAYCOUNT', $this->mModuleConfig['display_itemcount']);
			define('_MD_XDBASE_CONST_DISPLAYCATROW', $this->mModuleConfig['display_catrow']);
			define('_MD_XDBASE_CONST_CAT_ROW_PERCENTAGE', intval(round(100 / $this->mModuleConfig['display_catrow'])) * (0.96) .'%');
			define('_MD_XDBASE_CONST_DISPLAYTHUMBSROW', $this->mModuleConfig['display_thumbsrow']);
			define('_MD_XDBASE_CONST_DISPLAYEDITBUTTON', $this->mModuleConfig['display_editbutton']);
			define('_MD_XDBASE_CONST_DISPLAYFIELDSEARCH', $this->mModuleConfig['display_fieldsearch']);
			define('_MD_XDBASE_CONST_DISPLAYTAGCLOUD', $this->mModuleConfig['display_tagcloud']);
			define('_MD_XDBASE_CONST_TEXTLENGTH', $this->mModuleConfig['max_textlength']);
			define('_MD_XDBASE_CONST_DATEFMT_LIST', $this->mModuleConfig['date_format_list']);
			define('_MD_XDBASE_CONST_DATEFMT_VIEW', $this->mModuleConfig['date_format_view']);
			define('_MD_XDBASE_CONST_TEXTAREA_COL', $this->mModuleConfig['textarea_col']);
			define('_MD_XDBASE_CONST_TEXTAREA_ROW', $this->mModuleConfig['textarea_row']);
			define('_MD_XDBASE_CONST_USE_SCRIPT', $this->mModuleConfig['use_script']);
			define('_MD_XDBASE_CONST_USE_URLTHUM', $this->mModuleConfig['use_url_thumbnailapi']);
			define('_MD_XDBASE_CONST_CATPERM', $this->mModuleConfig['cat_perm']);
			define('_MD_XDBASE_CONST_DATAPERM', $this->mModuleConfig['data_perm']);
			define('_MD_XDBASE_CONST_CATIMG_PATH', XOOPS_ROOT_PATH.$this->mModuleConfig['cat_image_path']);
			define('_MD_XDBASE_CONST_CATIMG_URL', XOOPS_URL.$this->mModuleConfig['cat_image_path']);
			define('_MD_XDBASE_CONST_PHOTOS_PATH', XOOPS_ROOT_PATH.$this->mModuleConfig['photos_path']);
			define('_MD_XDBASE_CONST_PHOTOS_URL', XOOPS_URL.$this->mModuleConfig['photos_path']);
			define('_MD_XDBASE_CONST_THUMBS_PATH', XOOPS_ROOT_PATH.$this->mModuleConfig['thumbs_path']);
			define('_MD_XDBASE_CONST_THUMBS_URL', XOOPS_URL.$this->mModuleConfig['thumbs_path']);
			define('_MD_XDBASE_CONST_MAXCATIMGSIZE', $this->mModuleConfig['cat_image_size']);
			define('_MD_XDBASE_CONST_MAXIMGSIZE', $this->mModuleConfig['max_image_size']);
			define('_MD_XDBASE_CONST_MAXVIEWSIZE', $this->mModuleConfig['view_image_size']);
			define('_MD_XDBASE_CONST_MAXTHUMBSIZE', $this->mModuleConfig['thumbnail_image_size']);
			define('_MD_XDBASE_CONST_CREATETHUMB', $this->mModuleConfig['create_thumbnail']);
			define('_MD_XDBASE_CONST_FILES_PATH', XOOPS_ROOT_PATH.$this->mModuleConfig['files_path']);
			define('_MD_XDBASE_CONST_FILES_URL', XOOPS_URL.$this->mModuleConfig['files_path']);
			define('_MD_XDBASE_CONST_ALLOWEDEXTS', $this->mModuleConfig['allowed_extension']);
			define('_MD_XDBASE_CONST_MAXFILESIZE', $this->mModuleConfig['max_filesize']);
//			define('_MD_XDBASE_CONST_USEFACILITY', $this->mModuleConfig['use_facility_reservation']);
//			define('_MD_XDBASE_CONST_OVERLAPLIMIT', $this->mModuleConfig['overlap_limit']);
//			define('_MD_XDBASE_CONST_EDATE_AFILL', $this->mModuleConfig['e_date_autofill']);
			define('_MD_XDBASE_CONST_USEGMAP', $this->mModuleConfig['use_gmap']);
			define('_MD_XDBASE_CONST_SHOWGMAPTOP', $this->mModuleConfig['show_gmap_top']);
			define('_MD_XDBASE_CONST_GMAPHEIGHT', $this->mModuleConfig['gmap_height']);
			define('_MD_XDBASE_CONST_GMAPKEY', $this->mModuleConfig['gmap_key']);
			define('_MD_XDBASE_CONST_GMAPLATI', $this->mModuleConfig['gmap_latidefault']);
			define('_MD_XDBASE_CONST_GMAPLONGI', $this->mModuleConfig['gmap_longidefault']);
			define('_MD_XDBASE_CONST_GMAPZOOM', $this->mModuleConfig['gmap_zoomdefault']);
			define('_MD_XDBASE_CONST_USESEARCHADDRESS', $this->mModuleConfig['use_search_address']);
			define('_MD_XDBASE_CONST_PTYPE_PATH', $this->mModuleConfig['ptype_path']);
			define('_MD_XDBASE_CONST_AZIP_PATH', $this->mModuleConfig['azip_path']);
			define('_MD_XDBASE_CONST_COM_TYPE', $this->mModuleConfig['comment_type']);
			define('_MD_XDBASE_CONST_COM_DIRNAME', $this->mModuleConfig['d3forum_dir']);
			define('_MD_XDBASE_CONST_COM_FORUM_ID', $this->mModuleConfig['d3forum_id']);
			define('_MD_XDBASE_CONST_COM_VIEW', $this->mModuleConfig['comment_view']);
			define('_MD_XDBASE_CONST_D3PIPES_DIRNAME', $this->mModuleConfig['d3pipes_dir']);

			define('_MD_XDBASE_CONST_OPTION01', $this->mModuleConfig['option01']);
			define('_MD_XDBASE_CONST_OPTION02', $this->mModuleConfig['option02']);
			define('_MD_XDBASE_CONST_OPTION03', $this->mModuleConfig['option03']);

			define('_MD_XDBASE_CONST_INSERTABLE', $this->checkGroupPerm(1));
			define('_MD_XDBASE_CONST_SUPERINSERT', $this->checkGroupPerm(2));
			define('_MD_XDBASE_CONST_EDITABLE', $this->checkGroupPerm(4));
			define('_MD_XDBASE_CONST_SUPEREDIT', $this->checkGroupPerm(8));
			define('_MD_XDBASE_CONST_SUPERDELETE', $this->checkGroupPerm(32));
			define('_MD_XDBASE_CONST_CANUPLOAD', $this->checkGroupPerm(64));

		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function checkGroupPerm($gperm_itemid)
	{
		$grouppermHandler =& xoops_gethandler('groupperm');

		if (!is_object($this->mXoopsUser))
		{
			$gidArray = array(XOOPS_GROUP_ANONYMOUS);
		}
		else
		{
			$gidArray = $this->mXoopsUser->getGroups();
		}

		if ($grouppermHandler->checkRight('xdbase_global', $gperm_itemid, $gidArray, $this->mXoopsModule->getVar('mid')))
		{
			$ret = true;
		}
		else
		{
			$ret = false;
		}
		return $ret;
	}

	function getListTemplate()
	{
		$view = xdbaseGetRequest('view');
		$templateArray = array(
			'data_list_address_style.html',
			'data_list_album_style.html',
			'data_list_article_style.html',
			'data_list_bbs_style.html',
			'data_list_box_style.html',
			'data_list_calendar_style.html',
			'data_list_daily_style.html',
			'data_list_job_style.html',
			'data_list_map_style.html',
			'data_list_monthly_style.html',
			'data_list_note_style.html',
			'data_list_simple_link_style.html',
			'data_list_slideshow_style.html',
			'data_list_table_style.html',
			'data_list_thumbnail_style.html',
			'data_list_title_style.html',
			'data_list_weekly_style.html',
			'data_list_xigg_style.html',
			'data_list_yearly_style.html'
		);

		if (is_null($view)) return $this->mModuleConfig['list_template'];

		if ($view >= 0 && $view < count($templateArray))
		{
			return $templateArray[$view];
		}
		else
		{
			return $this->mModuleConfig['list_template'];
		}
	}

	function getViewTemplate()
	{
		$listTemplate = $this->getListTemplate();
		switch ($listTemplate)
		{
			case 'data_list_xigg_style.html':
				$template = 'data_view_xigg_style.html';
				break;
			case 'data_list_note_style.html':
				$template = 'data_view_note_style.html';
				break;
			default:
				$template = $this->mModuleConfig['view_template'];
				break;
		}
		return $template;
	}

	function executeForward($url)
	{
		header("location: " . $url);
		exit();
	}

	/**
	 * Redirect to the specified URL with displaying message.
	 * 
	 * @param string  $url      Can't use html tags.
	 * @param int     $time
	 * @param string  $message
	 */
	function executeRedirect($url, $time = 1, $message = null)
	{
		if ($this->mAdminFlag)
		{
			ob_clean();
		}
		redirect_header($url, $time, $message);
		exit();
	}





	/**
	 * @public
	 */
	function &load($type, $name)
	{
		if (isset($this->_mCache[$type][$name]))
		{
			return $this->_mCache[$type][$name];
		}
	
		return $this->create($type, $name);
	}

	/**
	 * @public
	 */
	function &create($type, $name)
	{
		$instance = array();
		if (!isset($instance[$this->mDirname]))
		{
			$instance[$this->mDirname] =& $this->_fallbackCreate($type, $name);
		}
		$this->_mCache[$type][$name] =& $instance[$this->mDirname];
		return $instance[$this->mDirname];
	}

	/**
	 * @private
	 */
	function &_fallbackCreate($type, $name)
	{
		if (isset($this->mAssetList[$type][$name]))
		{
			$className = $this->mAssetList[$type][$name]['class'];
			if (isset($this->mAssetList[$type][$name]['absPath']))
			{
				$filePath = $this->mAssetList[$type][$name]['absPath'];
			}
			else
			{
				$filePath = XOOPS_TRUST_PATH.'/modules/'.$this->mTrustDirname.'/'.$this->mAssetList[$type][$name]['path'];
			}

			$instance =& $this->_createInstance($className, $filePath);
		}
		else
		{
			switch ($type)
			{
				case 'filter':
					$instance =& $this->_createFilter($name);
					break;
				case 'form':
					$instance =& $this->_createActionForm($name);
					break;
				case 'handler':
					$instance =& $this->_createHandler($name);
					break;
			}
		}
	
		return $instance;
	}


	/**
	 * @private
	 */
	function &_createInstance($className, $filePath)
	{
		$instance = null;

		if (file_exists($filePath) && !class_exists($className))
		{
			require_once $filePath;
			$instance =& new $className($this);
		}

		return $instance;
	}

	/**
	 * @private
	 */
	function &_createFilter($name)
	{
		$entity = $name;
		$isAdmin = false;
		$adminToken = '';
	
		if (preg_match('/^admin\.([a-z\_]+)$/i', $name, $matches))
		{
			$entity = $matches[1];
			$isAdmin = true;
			$adminToken = 'Admin_';
		}
	
		$filePath = $this->_getBasePath($isAdmin) . '/forms/' . ucfirst($entity) . 'FilterForm.class.php';
		$className = ucfirst($this->mTrustDirname) . '_' . $adminToken . ucfirst($entity) . 'FilterForm';

		$instance =& $this->_createInstance($className, $filePath);
	
		return $instance;
	}

	/**
	 * @private
	 */
	function &_createActionForm($name)
	{
		$mode = '';
		$entity = $name;
		$isAdmin = false;
		$adminToken = '';
	
		if (preg_match('/^admin\.([a-z\_]+)$/i', $name, $matches))
		{
			$entity = $matches[1];
			$isAdmin = true;
			$adminToken = 'Admin_';
		}
	
		if (preg_match('/^([^\_]+)\_(.+)$/', $entity, $matches))
		{
			$mode = $matches[1];
			$entity = $matches[2];
		}
	
		$className = ucfirst($this->mTrustDirname) . '_'. $adminToken . ucfirst($entity) . ucfirst($mode) . 'Form';
		$filePath = $this->_getBasePath($isAdmin) . '/forms/' . ucfirst($entity) . ucfirst($mode) . 'Form.class.php';
	
		$instance =& $this->_createInstance($className, $filePath);
	
		return $instance;
	}

	/**
	 * @private
	 */
	function &_createHandler($name)
	{
		$instance =& xdbaseGetModuleHandler($name, $this->mDirname);
		return $instance;
	}

	/**
	 * @private
	 */
	function _getBasePath($isAdmin = false)
	{
		$filePath = XOOPS_TRUST_PATH.'/modules/'.$this->mTrustDirname;
		if ($isAdmin)
		{
			$filePath .= '/admin';
		}
		return $filePath;
	}


}

?>
