<?php
/**
 * @file
 * @package xdbase
 * @version $Id: XdbaseD3commentContent.class.php,v 1.4 2010/02/23 02:38:27 bluemelon Exp $
 */

include_once dirname(dirname(__FILE__)).'/include/function.php';

// a class for d3forum comment integration
class XdbaseD3commentContent extends D3commentAbstract
{
	function fetchSummary($external_link_id)
	{
		if (!defined('XDBASE_TRUST_DIRNAME')) define('XDBASE_TRUST_DIRNAME', $this->mytrustdirname);

		$moduleHandler =& xoops_gethandler('module');
		$module =& $moduleHandler->getByDirname($this->mydirname);
		$configHandler =& xoops_gethandler('config');
		$configs = $configHandler->getConfigList($module->mid());
		$dataHandler =& xdbaseGetModuleHandler('data', $this->mydirname);
		$did = intval($external_link_id);
		if ( preg_match('/[^0-9a-zA-Z_-]/', $this->mydirname)) die('Invalid mydirname');

		$dataObject =& $dataHandler->get($did);
		$summary = $dataObject->getShow('body');
		if ($dataObject->getShow('img01') != '')
		{
			$thumbsPath = XOOPS_URL.$configs['thumbs_path'];
			$summary = '<div style="float:left;padding-right:6px;"><img src="'.$thumbsPath.'/'.$dataObject->getShow('img01').'" /></div>'.$summary;
		}

		return array(
			'dirname'     => $this->mydirname,
			'module_name' => $module->getVar('name'),
			'subject'     => $dataObject->getShow('title'),
			'uri'         => XOOPS_URL.'/modules/'.$this->mydirname.'/index.php?action=DataView&amp;did='.$did,
			'summary'     => $summary,
		);
	}


	function validate_id($link_id)
	{
		if (!defined('XDBASE_TRUST_DIRNAME')) define('XDBASE_TRUST_DIRNAME', $this->mytrustdirname);

		$dataHandler =& xdbaseGetModuleHandler('data', $this->mydirname);

		$did = intval($link_id);
		$criteria =& $dataHandler->getCriteria();
		$criteria->add(new Xdbase_Criteria('did', $did));
		$count = $dataHandler->getCount($criteria);
		if ($count == 1)
		{
			return $did;
		}
		else
		{
			return false;
		}
	}

	function onUpdate($mode, $link_id, $forum_id, $topic_id, $post_id = 0)
	{
		if (!defined('XDBASE_TRUST_DIRNAME')) define('XDBASE_TRUST_DIRNAME', $this->mytrustdirname);

		$did = intval($link_id);
		$dataHandler =& xdbaseGetModuleHandler('data', $this->mydirname);
		$com_count = $this->getPostsCount($forum_id, $link_id);

		if ($dataHandler->updateCommentCount($did, $com_count))
		{
			$ret = true;
		}
		else
		{
			$ret = false;
		}
		return $ret;
	}

}

?>
