<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataViewAction.class.php,v 1.7 2010/06/16 10:27:09 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractViewAction.class.php';

class Xdbase_DataViewAction extends Xdbase_AbstractViewAction
{
	/**
	 * @public
	 */
	function _getId()
	{
		return xdbaseGetRequest('did');
	}

	/**
	 * @public
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data');
		return $handler;
	}

	function checkAccessPerm()
	{
		$handler =& $this->_getHandler();
		$criteria =& $handler->getCriteria();
		$criteria->add(new Xdbase_Criteria('did', $this->_getId()));
		$count = $handler->getCount($criteria);
		if ($count != 1)
		{
			$this->mController->executeRedirect('./index.php?action=DataList', 3, _NOPERM);
		}
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->checkAccessPerm();

		$visit = xdbaseGetRequest('visit');
		if ($visit != null)
		{
			$this->executeViewVisit($render, $visit);
		}

		$GLOBALS['xoopsOption']['template_main'] = $this->mController->mDirname.'_'._MD_XDBASE_CONST_VIEW_TPT;

		$this->mTpl->assign('object', $this->mObject);

		$this->mTpl->assign('handler', $this->mObjectHandler);
		$this->mObjectHandler->increaseHitCount($this->_getId());

		$this->setComment();
		$this->setAttributeForm();

		$pageTitle = trim($this->mObject->get('title'));
		if ($pageTitle != '')
		{
			$this->mTpl->assign('xoops_pagetitle', $this->mTpl->get_template_vars('xoops_pagetitle').' - '.$pageTitle);
		}

	}

	// for link site or file
	function executeViewVisit(&$render, $visit)
	{
		$did = intval(xdbaseGetRequest('did'));
		if ($did == null)
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$did , 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
		}

		$handler =& $this->mController->load('handler', 'data');
		$dataObject =& $handler->get($did);

		if (!xoops_refcheck())
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$did , 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
		}

		switch ($visit)
		{
			case 'url': // link
				$url = $dataObject->getShow($visit);
				if (preg_match('/^http/', $url)) // link
				{
					$url = htmlspecialchars(preg_replace('/javascript:/si', 'java script:', $url), ENT_QUOTES);
					header('Location: '.$url);
					echo '<html><head><meta http-equiv="Refresh" content="0; URL='.$url.'"></meta></head><body></body></html>';
					exit();
				}
				else
				{
					$this->mController->executeRedirect('./index.php?action=DataView&did='.$did , 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
				}
				break;

			case 'file01name': // file
				$url = $dataObject->getShow($visit);
				$handler->increaseDownloadCount($did);
				@set_time_limit(0);
				$userAgent = xdbaseGetUserAgent();
				$url = _MD_XDBASE_CONST_FILES_PATH.'/'.$url;
				$fileName = xdbaseEncodName($dataObject->getShow('file01'), $userAgent);
				$fileExt = strtolower($dataObject->getShow('file01ext'));
				$mtype = xdbaseGetMtype($fileExt);
				$size= @filesize($url);
				if (headers_sent()) die('headers are already sent');
				header('Content-Type: '.$mtype);
				header('Content-Disposition: attachment; filename="'.$fileName.'"');
				header('Content-Description: File Transfer');
				header('Content-Length: '.$size);

				if ($userAgent == 'IE')
				{
					header('Pragma: public');
					header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				}
				else
				{
					header('Pragma: no-cache');
				}

				if (isset($mtype) && strstr($mtype, 'text/'))
				{
					$fp = fopen($url, 'r');
				}
				else
				{
					$fp = fopen($url, 'rb');
				}
				fpassthru($fp);
				exit();
				break;

			case 'votes': // vote
				if ($handler->increaseVoteCount($did))
				{
					$this->mController->executeRedirect('./index.php?action=DataView&did='.$did, 1, _MD_XDBASE_LANG_VOTE_APPRECIATED);
				}
				else
				{
					$this->mController->executeRedirect('./index.php?action=DataView&did='.$did, 1, _MD_XDBASE_LANG_ALREADY_VOTED);
				}
				break;
		}
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=DataList', 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
	}


// xoops comment from commentAny
	function setComment()
	{
		$com_itemid = $this->_getId();
		$com_rule = $this->mController->mModuleConfig['com_rule'];

		if ((_MD_XDBASE_CONST_COM_TYPE == 0) && ($com_rule != 0))
		{
			if (xdbaseGetUid() == 0 && !$this->mController->mModuleConfig['com_anonpost'])
			{
				$com_rule = false;
			}
		}

		$this->mTpl->assign('com_rule', $com_rule);

		require_once XOOPS_ROOT_PATH.'/include/comment_constants.php';
		require_once XOOPS_ROOT_PATH.'/language/'.$GLOBALS['xoopsConfig']['language'].'/comment.php';

		$commentArr = array();
		$com_order = 0;
		$commentArr['com_id'] = 0;
		$commentArr['com_itemid'] = $com_itemid;
		$commentArr['com_pid'] = 0;
		$commentArr['com_rootid'] = 0;
		$commentArr['com_modid'] = $this->mController->mXoopsModule->getVar('mid');
//		$commentArr['com_exparams'] = 'action=DataView';
		$commentArr['com_exparams'] = 'DataView';
		$commentArr['com_order'] = $GLOBALS['xoopsConfig']['com_order'];
		$commentArr['com_title'] = 'Re: '.$this->mObject->get('title');

		switch ($this->mController->mModuleConfig['com_rule'])
		{
			case XOOPS_COMMENT_APPROVEALL:
				$commentArr['com_rule'] = _CM_COMAPPROVEALL;
				break;

			case XOOPS_COMMENT_APPROVEUSER:
				$commentArr['com_rule'] = _CM_COMAPPROVEUSER;
				break;

			case XOOPS_COMMENT_APPROVEADMIN:
				default:
				$commentArr['com_rule'] = _CM_COMAPPROVEADMIN;
				break;
		}

		// check com_itemid
//		if (!is_object($xoopsUser) && empty($GLOBALS['xoopsConfig']['com_anonpost'])) $commentArr['com_itemid'] = 0;

		for ($i=1; $i<=7; $i++)
		{
			$commentArr['com_icon'][] = 'icon'.$i.'.gif';
		}

		if (defined('XOOPS_CUBE_LEGACY'))
		{
			require_once XOOPS_ROOT_PATH.'/modules/legacy/forms/CommentEditForm.class.php';
			$commentEditForm =& new Legacy_CommentEditForm();
			$commentArr['xoops_token_request'] = $commentEditForm->getToken();
			$commentArr['token_name'] = 'module.legacy.Legacy_CommentEditForm.TOKEN';
		}
		else
		{
			if (is_object(@$GLOBALS['xoopsSecurity']))
			{
				$commentArr['xoops_token_request'] = $GLOBALS['xoopsSecurity']->createToken() ;
			}
			else
			{
				$commentArr['xoops_token_request'] = '' ;
			}
			$commentArr['token_name'] = 'XOOPS_TOKEN_REQUEST';
		}
		$this->mTpl->assign('commentArr', $commentArr);
		return null;
	}

	function setAttributeForm()
	{
		if ($this->mObjectHandler->getShowArticle('option_value'))
		{
			$attributeForm =& $this->mController->create('form', 'edit_data_attribute');
			$attributeForm->prepare();
			$this->mTpl->assign('attributeForm', $attributeForm);
		}
	}

}

?>
