<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data.class.php,v 1.5 2010/02/23 02:38:27 bluemelon Exp $
 */


require_once dirname(dirname(__FILE__)).'/Xdbase_Criteria.class.php';
require_once dirname(dirname(__FILE__)).'/Xdbase_Object.class.php';
require_once dirname(dirname(__FILE__)).'/Xdbase_ObjectHandler.class.php';


class Xdbase_DataObject extends Xdbase_Object
{
	/**
	 * @public
	 */
	function Xdbase_DataObject()
	{
		$this->initVar('did', XOBJ_DTYPE_INT, '', false);
		$this->initVar('cid', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('title', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('tag', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('pid', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('uid', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('name', XOBJ_DTYPE_STRING, '', false, 60);
		$this->initVar('poster_ip', XOBJ_DTYPE_STRING, '', false, 15);
		$this->initVar('created_date', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('updated_date', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('published_date', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('expired_date', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('s_date', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('e_date', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('password', XOBJ_DTYPE_STRING, '', false, 34);
		$this->initVar('url', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('email', XOBJ_DTYPE_STRING, '', false, 64);
		$this->initVar('zip', XOBJ_DTYPE_STRING, '', false, 20);
		$this->initVar('state', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('city', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('street', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('phone', XOBJ_DTYPE_STRING, '', false, 30);
		$this->initVar('mobile_phone', XOBJ_DTYPE_STRING, '', false, 30);
		$this->initVar('fax', XOBJ_DTYPE_STRING, '', false, 30);
		$this->initVar('show_map', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('latitude', XOBJ_DTYPE_FLOAT, '0.00000000', false);
		$this->initVar('longitude', XOBJ_DTYPE_FLOAT, '0.00000000', false);
		$this->initVar('zoom', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('img01', XOBJ_DTYPE_STRING, '', false, 64);
		$this->initVar('img01_height', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('img01_width', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('img02', XOBJ_DTYPE_STRING, '', false, 64);
		$this->initVar('img02_height', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('img02_width', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('file01', XOBJ_DTYPE_STRING, '', false, 64);
		$this->initVar('file01name', XOBJ_DTYPE_STRING, '', false, 100);
		$this->initVar('file01ext', XOBJ_DTYPE_STRING, '', false, 10);
		$this->initVar('file01size', XOBJ_DTYPE_FLOAT, '0.00', false);
		$this->initVar('body', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('int01', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int02', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int03', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int04', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int05', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int06', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int07', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int08', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int09', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int10', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('float01', XOBJ_DTYPE_FLOAT, '0.0000', false);
		$this->initVar('float02', XOBJ_DTYPE_FLOAT, '0.0000', false);
		$this->initVar('varchar01', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar02', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar03', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar04', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar05', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar06', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar07', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar08', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar09', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('varchar10', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('text01', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('text02', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('reservation', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('option_value', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('weight', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('status', XOBJ_DTYPE_BOOL, '1', false);
		$this->initVar('access', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('groups', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('hits', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('comments', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('rating', XOBJ_DTYPE_FLOAT, '0.0000', false);
		$this->initVar('votes', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('downloads', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('trackbacks', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('pipe_id', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('dohtml', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('doxcode', XOBJ_DTYPE_BOOL, '1', false);
		$this->initVar('dosmiley', XOBJ_DTYPE_BOOL, '1', false);
		$this->initVar('doimage', XOBJ_DTYPE_BOOL, '1', false);
		$this->initVar('dobr', XOBJ_DTYPE_BOOL, '1', false);
	}

	function getKeys()
	{
		$ret = array();
		foreach (array_keys($this->vars) as $key)
		{
			$ret[] = $this->vars[$key];
		}
		return $ret;
	}

	function getShow($key)
	{
		$value = null;
		$myts =& MyTextSanitizer::getInstance();

		switch ($this->mVars[$key]['data_type']) {
			case XOBJ_DTYPE_BOOL:
			case XOBJ_DTYPE_INT:
			case XOBJ_DTYPE_FLOAT:
				$value = $this->mVars[$key]['value'];
				break;

			case XOBJ_DTYPE_STRING:
				$value = $myts->htmlSpecialChars($this->mVars[$key]['value']);
				break;

			case XOBJ_DTYPE_TEXT:
				$value = $myts->displayTarea($this->mVars[$key]['value'], $this->mVars['dohtml']['value'], $this->mVars['dosmiley']['value'], $this->mVars['doxcode']['value'], $this->mVars['doimage']['value'], $this->mVars['dobr']['value']);
				break;
		}

		return $value;
	}

	function getShowStripTags($key)
	{
		$myts =& MyTextSanitizer::getInstance();
		$value = strip_tags($myts->displayTarea(strip_tags($this->mVars[$key]['value']), 0, 1, 1, 1, 1));
		return $value;
	}

	function getAccessGroup()
	{
		$gidArray = explode(',', $this->get('groups'));
		$groupHandler =& xoops_gethandler('group');
		$groups =& $groupHandler->getObjects(null, true);
		if (is_array($gidArray))
		{
			$groupNameArray = array();
			$accessGroups = '';
			foreach ($gidArray as $gid)
			{
				$gid = intval($gid);
				$groupObject =& $groupHandler->get($gid);
				if (is_object($groupObject))
				{
					array_push($groupNameArray, $groupObject->getVar('name'));
				}
			}
			$accessGroups = implode(',', $groupNameArray);
		}
		return $accessGroups;
	}

	function getOptionValueArray()
	{
		return unserialize($this->get('option_value'));
	}

	function renderOptionForm($data=array())
	{
		$optionForm = '';
		$optionFormArray = array();
		$optionValueArray = $this->getOptionValueArray();

		$count = count($data);

		if (!$optionValueArray) return false;

		$i = 0;
		foreach ($optionValueArray as $optionValue)
		{
			$label = htmlspecialchars($optionValue['label'], ENT_QUOTES);
			$name = 'opt'.$i;
			$required = intval($optionValue['required']);
			$type = htmlspecialchars($optionValue['type'], ENT_QUOTES);
			$value = htmlspecialchars($optionValue['value'], ENT_QUOTES);
			$valueArray = explode(',', $value);
			$default = htmlspecialchars($optionValue['default'], ENT_QUOTES);
			if ($count > 0)
			{
				$default = htmlspecialchars($data[$i], ENT_QUOTES);
			}
			$defaultArray = explode(',', $default);

			$optionForm .= $label;
			switch ($type)
			{
				case 'text':
					$optionForm .= '<input type="text" name="'.$name.'" value="'.$default.'" />';
					break;

				case 'checkbox':
					if (count($valueArray) > 0)
					{
						$j = 0;
						foreach ($valueArray as $value)
						{
							$checked = '';

							if (count($defaultArray) > 1)
							{
								foreach ($defaultArray as $default)
								{
									if ($value == $default)
									{
										$checked = ' checked="checked"';
									}
								}
								$optionForm .= '<label><input type="checkbox" name="'.$name.'[]" value="'.$value.'"'.$checked.' />'.$value.'</label>';
								$j++;
							}
							else
							{
								if ($value == $default)
								{
									$checked = ' checked="checked"';
								}
								$optionForm .= '<label><input type="checkbox" name="'.$name.'[]" value="'.$value.'"'.$checked.' />'.$value.'</label>';
								$j++;
							}
						}
					}
					break;

				case 'radio':
					if (count($valueArray) > 0)
					{
						$j = 0;
						foreach ($valueArray as $value)
						{
							$checked = '';
							if ($value == $default)
							{
								$checked = ' checked="checked"';
							}
							$optionForm .= '<label><input type="radio" name="'.$name.'" value="'.$value.'"'.$checked.' />'.$value.'</label>';
							$j++;
						}
					}
					break;

				case 'select':
					if (count($valueArray) > 0)
					{
						$optionForm .= '<select name="'.$name.'">';
						$j = 0;
						foreach ($valueArray as $value)
						{
							$selected = '';
							if ($value == $default)
							{
								$selected = ' selected="selected"';
							}
							$optionForm .= '<option value="'.$value.'"'.$selected.'>'.$value.'</option>';
							$j++;
						}
						$optionForm .= '</select>';
					}
					break;

				case 'hidden':
					$optionForm .= '<input type="hidden" name="'.$name.'" value="'.$value.'" />';
					break;

			}
			$i++;
			$optionForm .= '<br />';
		}
		return $optionForm;
	}

	function getImageWidth($max, $colmn='img01')
	{
		list($width, $height) = xdbaseCalcImageSize($max, $this->get($colmn.'_width'), $this->get($colmn.'_height'));
		return $width;
	}

	function getImageHeight($max, $colmn='img01')
	{
		list($width, $height) = xdbaseCalcImageSize($max, $this->get($colmn.'_width'), $this->get($colmn.'_height'));
		return $height;
	}

}


class Xdbase_DataHandler extends Xdbase_ObjectHandler
{
	var $mTable = '{dirname}_data';
	var $mPrimary = 'did';
	var $mClass = 'Xdbase_DataObject';
	var $mDirName = null;
	var $dataConfigHandler = null;

	function Xdbase_DataHandler(&$db, $dirname)
	{
		$this->mDirName = $dirname;
		$this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
		Xdbase_ObjectHandler::Xdbase_ObjectHandler(&$db);
		$this->prepare();
	}

	function prepare()
	{
		$this->dataConfigHandler =& xdbaseGetModuleHandler('data_config', $this->mDirName);

		if (is_object($this->dataConfigHandler))
		{
			$this->dataConfigHandler->defineDataLang();
		}
	}

	function &getCriteria()
	{
		$moduleConfig =& xdbaseGetConfigsByDirname($this->mDirName);
		$catHandler =& xdbaseGetModuleHandler('cat', $this->mDirName);

		$criteria =& new Xdbase_CriteriaCompo();

		// is admin
		if (xdbaseIsAdmin() == true)
		{
			return $criteria;
		}

		// status
		if ($this->getActive('status'))
		{
			$criteria->add(new Xdbase_Criteria('status', 1));
		}

		// published_date
		if ($this->getActive('published_date'))
		{
			$criteria->add(new Xdbase_Criteria('published_date', time(), '<'));
		}

		//expired_date
		if ($this->getActive('expired_date'))
		{
			$expiredCriteria =& new Xdbase_CriteriaCompo();
			$expiredCriteria->add(new Xdbase_Criteria('expired_date', time(), '>'));
			$expiredCriteria->add(new Xdbase_Criteria('expired_date', 0), 'OR');
			$criteria->add($expiredCriteria);
		}

		// category group permission
		if ($moduleConfig['cat_perm'])
		{
			$catObjectArray =& $catHandler->getObjects($catHandler->getCriteria());
			$cidCriteria =& new Xdbase_CriteriaCompo();
			if (count($catObjectArray) > 0)
			{
				$cidCriteria->add(new Xdbase_Criteria('cid', 0), 'OR');
				foreach ($catObjectArray as $catObject)
				{
					$cid = $catObject->get('cid');
					$cidCriteria->add(new Xdbase_Criteria('cid', $cid), 'OR');
				}
				$criteria->add($cidCriteria);
			}
		}

		// get groups
		$groupCriteria =& new Xdbase_CriteriaCompo();
		$uid = xdbaseGetUid();
		$gidArray = xdbaseGetGroups();

		if (count($gidArray) > 0)
		{
			foreach ($gidArray as $gid)
			{
				$groupCriteria->add(new Xdbase_Criteria('groups', '%'.$gid.'%', 'LIKE'), 'OR');
			}
		}

		// data group permission
		if ($moduleConfig['data_perm'] && $this->dataConfigHandler->getActive('access'))
		{
			$accessCriteria =& new Xdbase_CriteriaCompo();
			// public
			$accessCriteriaA =& new Xdbase_CriteriaCompo();
			$accessCriteriaA->add(new Xdbase_Criteria('access', 0));
			// by group
			$accessCriteriaB =& new Xdbase_CriteriaCompo();
			$accessCriteriaB->add(new Xdbase_Criteria('access', 1));
			$accessCriteriaB->add($groupCriteria);
			// private
			$accessCriteriaC =& new Xdbase_CriteriaCompo();
			$accessCriteriaC =& new Xdbase_CriteriaCompo();
			$accessCriteriaC->add(new Xdbase_Criteria('access', 2));
			$accessCriteriaC->add(new Xdbase_Criteria('uid', $uid));
			$accessCriteria->add($accessCriteriaA, 'OR');
			$accessCriteria->add($accessCriteriaB, 'OR');
			$accessCriteria->add($accessCriteriaC, 'OR');
			$criteria->add($accessCriteria);
		}
		return $criteria;
	}

	function checkData($did)
	{
		// is admin
		if (xdbaseIsAdmin() == true)
		{
			return true;
		}

		$uid = xdbaseGetUid();

		if ($uid == 0)
		{
			return  false;
		}

		$criteria =& $this->getCriteria();
		$criteria->add(new Xdbase_Criteria('did', $did));
		$criteria->add(new Xdbase_Criteria('uid', $uid));
		$count = $this->getCount($criteria);
		if ($count == 1)
		{
			$ret = true;
		}
		else
		{
			$ret = false;
		}
		return $ret;
	}

	function getCount($criteria = null)
	{
		$ret = 0;
		if ($criteria != null)
		{
			$ret = Xdbase_ObjectHandler::getCount($criteria);
		}
		else
		{
			$ret = Xdbase_ObjectHandler::getCount();
		}
		return $ret;
	}

	function getCatTitle($cid)
	{
		$catHandler =& xdbaseGetModuleHandler('cat', $this->mDirName);
		if ($cid == 0) return '';
		return $catHandler->getCatTitle($cid);
	}

	/* for categories selectbox */
	function getCatOptionArray()
	{
		$catHandler =& xdbaseGetModuleHandler('cat', $this->mDirName);
		$catHandler->setTree($catHandler->getCriteria());
		return $catHandler->getCatOptionArray();
	}

	function getNicePathFromIdForDetail($key, $funcURL)
	{
		$catHandler =& xdbaseGetModuleHandler('cat', $this->mDirName);
		$catHandler->setTree($catHandler->getCriteria());
		$ret = $catHandler->_mTree->getNicePathFromIdForDetail($key, $funcURL);
		return $ret;
	}

	// group options
	function getGroupOptionsArray()
	{
		$groupHandler =& xoops_gethandler('group');
		$groups =& $groupHandler->getObjects(null, true);
		$groupOptions = array();
		foreach ($groups as $gid => $group)
		{
			$groupOptions[$gid] = $group->getVar('name');
		}
		return $groupOptions;
	}

	function getKeyArray()
	{
		$keyArray = array(
			'did',
			'cid',
			'title',
			'tag',
			'pid',
			'uid',
			'name',
			'poster_ip',
			'created_date',
			'updated_date',
			'published_date',
			'expired_date',
			's_date',
			'e_date',
			'password',
			'url',
			'email',
			'zip',
			'state',
			'city',
			'street',
			'phone',
			'mobile_phone',
			'fax',
			'show_map',
			'latitude',
			'longitude',
			'zoom',
			'img01',
			'img01_height',
			'img01_width',
			'img02',
			'img02_height',
			'img02_width',
			'file01',
			'file01name',
			'file01ext',
			'file01size',
			'body',
			'int01',
			'int02',
			'int03',
			'int04',
			'int05',
			'int06',
			'int07',
			'int08',
			'int09',
			'int10',
			'float01',
			'float02',
			'varchar01',
			'varchar02',
			'varchar03',
			'varchar04',
			'varchar05',
			'varchar06',
			'varchar07',
			'varchar08',
			'varchar09',
			'varchar10',
			'text01',
			'text02',
			'reservation',
			'option_value',
			'weight',
			'status',
			'access',
			'groups',
			'hits',
			'comments',
			'rating',
			'votes',
			'downloads',
			'trackbacks',
			'pipe_id',
			'dohtml',
			'doxcode',
			'dosmiley',
			'doimage',
			'dobr'
		);
		return $keyArray;
	}

	function getActiveKeyArray()
	{
		$activeKeyArray = array();
		foreach ($this->getKeyArray() as $key)
		{
			if ($this->getActive($key))
			{
				array_push($activeKeyArray, $key);
			}
		}
		return $activeKeyArray;
	}

	function getSearchKeyArray()
	{
		$searchKeyArray = array();
		foreach ($this->getKeyArray() as $key)
		{
			if ($this->getSearch($key))
			{
				$searchKeyArray[$key] = $this->getShowName($key);
			}
		}
		return $searchKeyArray;
	}

	function getGlobalSearchKeyArray()
	{
		return $this->dataConfigHandler->getSearchKeyArray();
	}

	function getShowListKeyArray()
	{
		$showListKeyArray = array();
		foreach ($this->getKeyArray() as $key)
		{
			if ($this->getShowList($key))
			{
				array_push($showListKeyArray, $key);
			}
		}
		return $showListKeyArray;
	}

	function getShowArticleKeyArray()
	{
		$showArticleKeyArray = array();
		foreach ($this->getKeyArray() as $key)
		{
			if ($this->getShowArticle($key))
			{
				array_push($showArticleKeyArray, $key);
			}
		}
		return $showArticleKeyArray;
	}

	function getOperatorArray()
	{
//		$operatorArray = array(0=>'LIKE',1=>'=',2=>'&lt;&gt;',3=>'&lt;',4=>'&gt;',5=>'&lt;=',6=>'&gt;=');
		$operatorArray = array(0=>'LIKE',1=>'=',2=>'<>',3=>'<',4=>'>',5=>'<=',6=>'>=');
		return $operatorArray;
	}

	function getOperator($i)
	{
		$operatorArray = $this->getOperatorArray();
		return $operatorArray[$i];
	}

	function getConditionArray()
	{
		$operatorArray = array(0=>'AND',1=>'OR');
		return $operatorArray;
	}

	function getCondition($i)
	{
		$conditionArray = $this->getConditionArray();
		return $conditionArray[$i];
	}

	function getOrder($i)
	{
		$orderArray = array(0=>'ASC',1=>'DESC');
		return $orderArray[$i];
	}

	function getSort($key)
	{
		$sort = '';
		if (in_array($key, $this->getKeyArray()))
		{
			$sort = $key;
		}
		return $sort;
	}

	function getActive($key)
	{
//return true;
		return $this->dataConfigHandler->getActive($key);
	}

	function getSearch($key)
	{
		return $this->dataConfigHandler->getSearch($key);
	}

	function getShowList($key)
	{
		return $this->dataConfigHandler->getShowList($key);
	}

	function getShowArticle($key)
	{
		return $this->dataConfigHandler->getShowArticle($key);
	}

	function getRequired($key)
	{
		return $this->dataConfigHandler->getRequired($key);
	}

	function getLangRequired($key)
	{
		$ret = '';
		if ($this->dataConfigHandler->getRequired($key))
		{
			$ret = ' <span style="color:#FF0000;">('._MD_XDBASE_LANG_REQUIRED.')</span>';
		}
		return $ret;
	}

	function getShowName($key)
	{
		return $this->dataConfigHandler->getShowName($key);
	}

	function getKeyConst($key)
	{
		$keyName = strtoupper($key);
		$keyConst = constant('_MD_XDBASE_LANG_'.$keyName);
		return $keyConst;
	}

	function getKeySortConst($key)
	{
		$keyName = strtoupper($key);
		$keyConst = constant('XDBASE_DATA_SORT_KEY_'.$keyName);
		return $keyConst;
	}

	function getDistinctValueArray($key)
	{
		if (!in_array($key, $this->getKeyArray()))
		{
			return false;
		}

		$myts =& MyTextSanitizer::getInstance();
		$key4sql = $myts->addSlashes($key);
		$distinctValueArray = array();
		$sql ="SELECT DISTINCT ".$key4sql." FROM ".$this->mTable;

		$result = $this->db->query($sql);
		if (!$result)
		{
			return false;
		}

		if ($this->db->getRowsNum($result) == 0)
		{
			return false;
		}

		$i = 0;
		while ($row = $this->db->fetchArray($result))
		{
			$distinctValueArray[$i] = htmlspecialchars($row[$key], ENT_QUOTES);
			$i++;
		}
		return $distinctValueArray;
	}


	// for Map Style
	function getStateValueArray()
	{
		$myts =& MyTextSanitizer::getInstance();

		$distinctValueArray = array();
		$sql ="SELECT DISTINCT state FROM ".$this->mTable." WHERE state NOT LIKE '' ORDER BY state ASC";

		$result = $this->db->query($sql);
		if (!$result)
		{
			return false;
		}

		if ($this->db->getRowsNum($result) == 0)
		{
			return false;
		}

		$i = 0;
		while ($row = $this->db->fetchArray($result))
		{
			$distinctValueArray[$i] = htmlspecialchars($row['state'], ENT_QUOTES);
			$i++;
		}
		return $distinctValueArray;
	}

	// for Map Style
	function getCityValueArray()
	{
		$state = xdbaseGetRequest('state');
		$myts =& MyTextSanitizer::getInstance();
		if ($state == '')
		{
			$strWhere = " WHERE city NOT LIKE ''";
		}
		else
		{
			$strWhere = " WHERE state LIKE '".$myts->addSlashes($state)."' AND city NOT LIKE ''";
		}
		$distinctValueArray = array();
		$sql ="SELECT DISTINCT city FROM ".$this->mTable.$strWhere." ORDER BY city ASC";

		$result = $this->db->query($sql);
		if (!$result)
		{
			return false;
		}

		if ($this->db->getRowsNum($result) == 0)
		{
			return false;
		}

		$i = 0;
		while ($row = $this->db->fetchArray($result))
		{
			$distinctValueArray[$i] = htmlspecialchars($row['city'], ENT_QUOTES);
			$i++;
		}
		return $distinctValueArray;
	}


	function getTagArray($did)
	{
		$tagOptionArray =& $this->getTagOptionArray();
		if (count($tagOptionArray) < 0 || !is_array($tagOptionArray)) return false;

		$dataObject = $this->get($did);
		$dataTagArray = explode('|', $dataObject->get('tag'));

//exit(var_dump($dataTagArray));

		$tagArray = array();
		if (is_array($dataTagArray))
		{
			foreach ($dataTagArray as $dataTag)
			{
				$dataTag = preg_replace('/\|/', '', $dataTag);
				if ($dataTag != '')
				{
					foreach ($tagOptionArray as $key=>$tagOption)
					{
						if ($tagOption['value'] == $dataTag)
						{
							$tagArray[$key] = htmlspecialchars($dataTag, ENT_QUOTES);
						}
					}
				}
			}
		}
		return $tagArray;
	}

	function getTagOptionArray()
	{
		static $tagOptionArray;

		if (isset($tagOptionArray))
		{
			return $tagOptionArray;
		}

		$data_config_handler =& xdbaseGetModuleHandler('data_config', $this->mDirName);
		$dataConfigObject =& $this->dataConfigHandler->get('tag');
		if (is_object($dataConfigObject))
		{
			$tagOptionArray = unserialize($dataConfigObject->get('option_value'));
		}
		return $tagOptionArray;
	}

	function saveTag()
	{
		$sql ="SELECT tag, COUNT(tag) AS count FROM ".$this->mTable." GROUP BY tag";
		$result = $this->db->query($sql);

		if (!$result)
		{
			die('DB Error : '.$this->db->error());
		}

		if ($this->db->getRowsNum($result) == 0)
		{
			return false;
		}

		$tagArray = array();
		$searchTagArray = array();
		$i = 0;
		while ($row = $this->db->fetchArray($result))
		{
			if ($row['tag'] != '')
			{
				$tags = preg_replace('/^\|([\W|\w]+)\|$/', '$1', $row['tag']);
				$count = $row['count'];
				$dataTagArray = explode('|', $tags);
				if (is_array($dataTagArray))
				{
					foreach ($dataTagArray as $dataTag)
					{
						if ($dataTag != '')
						{
							$key = array_keys($searchTagArray, $dataTag);
							if (isset($key[0]))
							{
								$tagArray[$key[0]]['count'] += 1;
							}
							else
							{
								$tagArray[$i]['value'] = $dataTag;
								$tagArray[$i]['count'] = $count;
								$searchTagArray[$i] = $dataTag;
								$i++;
							}
						}
					}
				}
			}
		}

		asort($tagArray);
		$dataConfigObject =& $this->dataConfigHandler->get('tag');
		$tagValue = serialize($tagArray);
		$dataConfigObject->set('option_value', $tagValue);
		if ($this->dataConfigHandler->insert($dataConfigObject))
		{
			return true;
		}
		else
		{
			return false;
		}
	}


// for bbs style data list
	function addParentCriteria($criteria)
	{
		if (is_object($criteria))
		{
			$criteria->add(new Xdbase_Criteria('pid', 0));
		}
	}


// get d3pipe pipe_id with name
	function getD3pipePipeIds()
	{
		if (!defined('_MD_XDBASE_CONST_D3PIPES_DIRNAME'))
		{
			$moduleConfig =& xdbaseGetConfigsByDirname($this->mDirName);
			define('_MD_XDBASE_CONST_D3PIPES_DIRNAME', $moduleConfig['d3pipes_dir']);
		}

		$result = $this->db->query("SELECT pipe_id, name FROM ".$this->db->prefix(_MD_XDBASE_CONST_D3PIPES_DIRNAME."_pipes")." ORDER BY weight");
		$pipes4assign = array();

		while ($row = $this->db->fetchArray($result))
		{
			$pipe_id = intval($row['pipe_id']);
			$name = htmlspecialchars($row['name'], ENT_QUOTES);
			$pipes4assign[$pipe_id] = $name;
		}

		return $pipes4assign;
	}

	// get d3pipe clippings
	function getD3pipeClippings($pipe_id)
	{
		$pipe_id = intval($pipe_id);
		if (!$pipe_id) return false;

		if (!defined('_MD_XDBASE_CONST_D3PIPES_DIRNAME'))
		{
			$thisModuleConfig =& xdbaseGetConfigsByDirname($this->mDirName);
			define('_MD_XDBASE_CONST_D3PIPES_DIRNAME', $thisModuleConfig['d3pipes_dir']);
		}

		$moduleConfig =& xdbaseGetConfigsByDirname(_MD_XDBASE_CONST_D3PIPES_DIRNAME);
		include_once XOOPS_TRUST_PATH.'/modules/d3pipes/include/main_functions.php';
		// added for d3pipes ver 0.64
		include_once XOOPS_TRUST_PATH.'/modules/d3pipes/include/common_functions.php';

		// fetch pipe_row
		$pipe4assign = d3pipes_common_get_pipe4assign(_MD_XDBASE_CONST_D3PIPES_DIRNAME, $pipe_id);

		// parse the pipe once
		$errors = 0;
		$entries = d3pipes_common_fetch_entries(_MD_XDBASE_CONST_D3PIPES_DIRNAME, $pipe4assign, $moduleConfig['entries_per_eachpipe'], $errors, $moduleConfig);
		return $entries;

		// ¸Ѥߥȥ꡼Τɽǽʰ١ʲ Ի
		//		$pos = 0;
		//		$clips= d3pipes_main_get_clippings_moduledb(_MD_XDBASE_CONST_D3PIPES_DIRNAME, $pipe_id, $moduleConfig['entries_per_eachpipe'], $pos);
		//		return $clips;
	}


	function getChildData($did)
	{
		if ($did == 0) return false;
		$criteria =& $this->getCriteria();
		$criteria->add(new Xdbase_Criteria('pid', $did));
		$criteria->setSort('updated_date', 'DESC');
		$childDataObjectArray =& $this->getObjects($criteria);
		return $childDataObjectArray;
	}

	function increaseHitCount($did=0, $count=1)
	{
//		if (!$this->getActive('hits')) return false;

		$did =intval($did);

		$dataObject =& $this->get($did);
		if (!is_object($dataObject))
		{
			return false;
		}
		$count = $dataObject->getVar('hits') + $count;
		$dataObject->setVar('hits', $count);

		if ($ret = $this->insert($dataObject, true))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function updateCommentCount($did, $com_count)
	{
		$did =intval($did);
		$com_count = intval($com_count);

		$dataObject =& $this->get($did);
		if (!is_object($dataObject))
		{
			return false;
		}

		$dataObject->setVar('comments', $com_count);

		if ($ret = $this->insert($dataObject, true))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function increaseDownloadCount($did=0, $count=1)
	{
		$did =intval($did);

		$dataObject =& $this->get($did);
		if (!is_object($dataObject))
		{
			return false;
		}
		$count = $dataObject->getVar('downloads') + $count;
		$dataObject->setVar('downloads', $count);
		if ($ret = $this->insert($dataObject, true))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function getVoteCount($did)
	{
		$attributeHandler =& xdbaseGetModuleHandler('data_attribute', $this->mDirName);
		return $attributeHandler->getVoteCount($did);
	}

	function increaseVoteCount($did=0, $count=1)
	{
		$did =intval($did);

		$attributeHandler =& xdbaseGetModuleHandler('data_attribute', $this->mDirName);
		if (!$attributeHandler->increaseVoteCount($did))
		{
			return false;
		}

		$dataObject =& $this->get($did);
		if (!is_object($dataObject))
		{
			return false;
		}
		$count += $dataObject->getVar('votes');
		$dataObject->setVar('votes', $count);
		if ($ret = $this->insert($dataObject, true))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

/*
	function getFacilityArray()
	{
		$catHandler =& xdbaseGetModuleHandler('cat', $this->mDirName);
		$criteria =& new Xdbase_CriteriaCompo();
		$criteria->add(new Xdbase_Criteria('int01', 1));
		$catObjectArray =& $catHandler->getObjects($criteria);
		return $catObjectArray;
	}

	function checkOverlap($timeStart, $timeEnd, $limit=0)
	{
		$count = 0;
		$timeStart = intval($timeStart);
		$timeEnd = intval($timeEnd);
		$limit = intval($limit);

		if ($timeStart == 0) return false;
		if ($timeEnd == 0) return false;
		if ($limit == 0) return false;

		$date_criteria =& new Xdbase_CriteriaCompo();
		$date_criteria_1 =& new Xdbase_CriteriaCompo();
		$date_criteria_2 =& new Xdbase_CriteriaCompo();

		$date_criteria_1->add(new Xdbase_Criteria('s_date', $timeStart, '>='));
		$date_criteria_1->add(new Xdbase_Criteria('s_date', $timeEnd, '<'));

		$date_criteria_2->add(new Xdbase_Criteria('s_date', $timeStart, '<'));
		$date_criteria_2->add(new Xdbase_Criteria('e_date', $timeStart, '>'));

		$date_criteria->add($date_criteria_1);
		$date_criteria->add($date_criteria_2,'OR');
		$criteria =& $this->getCriteria();
		$criteria->add($date_criteria);

		$count = $this->getCount($criteria);
		if ($count >= $limit)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
*/

// reservation
	function getOptionCount($did)
	{
		$dataObject =& $this->get($did);
		return count($dataObject->getOptionValueArray());
	}


	function getReservationCount($did, $uid=0)
	{
		$attributeHandler =& xdbaseGetModuleHandler('data_attribute', $this->mDirName);
		return $attributeHandler->getReservationCount($did, $uid);
	}

/*
	function checkMyReservation($did)
	{
		$did = intval($did);
		if (!is_object($xoopsUser))
		{
			return false;
		}
		$dataAttributeHandler =& xdbaseGetModuleHandler('data_attribute', $this->mDirName);
		$uid = $xoopsUser->getVar('uid');
		$criteria =& new Xdbase_CriteriaCompo();
		$criteria->add(new Xdbase_Criteria('did', $did));
		$criteria->add(new Xdbase_Criteria('uid', $uid));
		$criteria->add(new Xdbase_Criteria('type', 1));
		$dataAttributeObject =& $dataAttributeHandler->getObjects($criteria);
		$count =& $dataAttributeHandler->getCount($criteria);

		if ($count == 0)
		{
			return false;
		}
		else
		{
			return true;
		}
	}
*/



	// page navigation in category
	function getPageNavi($s_did, $cid, $extra_arg='', $offset = 3)
	{
		$criteria =& $this->getCriteria();
		$criteria->add(new Xdbase_Criteria('cid', intval($cid)));
		$sortArray = $this->getKeyArray();
		$sortKey = _MD_XDBASE_CONST_DEFAULTSORT -1;
		$order = (_MD_XDBASE_CONST_DEFAULTORDER < 0) ? 'DESC' : 'ASC';
		$sql ="SELECT did FROM ".$this->mTable." WHERE ".$criteria->render()." ORDER BY ".$sortArray[$sortKey]." ".$order;

		$result = $this->db->query($sql);
		if (!$result)
		{
			die('DB Error : '.$this->db->error());
		}

		$total = $this->db->getRowsNum($result);
		$perpage = 1;

		if ($extra_arg != '' && (substr($extra_arg, -5) != '&amp;' || substr($extra_arg, -1) != '&'))
		{
			$extra_arg .= '&amp;';
		}
		$url = xoops_getenv('PHP_SELF').'?'.$extra_arg.'did=';

		$ret = '';
		if ($total <= $perpage)
		{
			return $ret;
		}

		$total_pages = ceil($total / $perpage);

		if ($total_pages > 1)
		{
			$dataArray = array();
			$i = 1;
			while ($row = $this->db->fetchArray($result))
			{
				$did = $row['did'];
				$dataArray[$i] = $did;
				if ($s_did == $did)
				{
					$current = $i;
				}
				$i++;
			}

			$prev = $current - $perpage;
			if ($prev > 0)
			{
				$ret .= '<a href="'.$url.$dataArray[$prev].'"><u>&laquo;</u></a> ';
			}

			$counter = 1;
			while ($counter <= $total_pages)
			{
				if ($counter == $current)
				{
					$ret .= '<strong>('.$counter.')</strong> ';
				}
				elseif (($counter > $current - $offset && $counter < $current + $offset) || $counter == 1 || $counter == $total_pages)
				{
					if ($counter == $total_pages && $current < $total_pages - $offset)
					{
						$ret .= '... ';
					}
					$ret .= '<a href="'.$url.$dataArray[$counter].'">'.$counter.'</a> ';
					if ($counter == 1 && $current > 1 + $offset)
					{
						$ret .= '... ';
					}
					unset($j);
				}
				$counter++;
			}
			$next = $current + $perpage;
			if ($total > $next)
			{
				$ret .= '<a href="'.$url.$dataArray[$next].'"><u>&raquo;</u></a> ';
			}
		}
		return $ret;
	}


// form
	function getInputType($key)
	{
		return $this->dataConfigHandler->getInputType($key);
	}

	function getOptionValue($key)
	{
		return $this->dataConfigHandler->getOptionValueArray($key);
	}

	function getValueFromOption($key, $value)
	{
		$replacedValue = $value;
		$optionValueArray = $this->getOptionValue($key);
		if (is_array($optionValueArray))
		{
			if (array_key_exists($value, $optionValueArray))
			{
				$replacedValue = htmlspecialchars($optionValueArray[$value], ENT_QUOTES);
			}
		}

		return $replacedValue;
	}

	function getInputHtml($key, $value='', $size=80, $maxlength=255)
	{
		$inputHtml = '';
		$type = $this->getInputType($key);
		$optionValueArray = $this->getOptionValue($key);
		switch ($type)
		{
			case 'text':
				$inputHtml = '<input type="text" name="'.$key.'" value="'.$value.'" size="'.$size.'" maxlength="'.$maxlength.'" />';
				break;
			case 'textarea':
				$inputHtml = '<textarea name="'.$key.'">'.$value.'</textarea>';
				break;
			case 'dhtmltarea':
				break;
			case 'checkbox':
				if (is_array($optionValueArray))
				{
					foreach ($optionValueArray as $optionKey => $optionValue)
					{
						if ($optionKey == 1)
						{
							if ($optionKey == $value)
							{
								$checked = ' checked="checked"';
							}
							else
							{
								$checked = '';
							}
							$inputHtml .= '<label><input type="checkbox" name="'.$key.'[]" value="'.$optionKey.'"'.$checked.' />'.$optionValue.'</label>';
						}
					}
				}
				break;
			case 'radio':
				if (is_array($optionValueArray))
				{
					foreach ($optionValueArray as $optionKey => $optionValue)
					{
						if ($optionKey == $value)
						{
							$checked = ' checked="checked"';
						}
						else
						{
							$checked = '';
						}
						$inputHtml .= '<label><input type="radio" name="'.$key.'" value="'.$optionKey.'"'.$checked.' />'.$optionValue.'</label>';
					}
				}
				break;
			case 'select':
				if (is_array($optionValueArray))
				{
					$inputHtml = '<select name="'.$key.'">';
					foreach ($optionValueArray as $optionKey => $optionValue)
					{
						if ($optionKey == $value)
						{
							$selected = ' selected="selected"';
						}
						else
						{
							$selected = '';
						}
						$inputHtml .= '<option value="'.$optionKey.'"'.$selected.'>'.$optionValue.'</option>';
					}
					$inputHtml .= '</select>';
				}
				break;
			case 'hidden':
				$inputHtml = '<input type="hidden" name="'.$key.'" value="'.$value.'" />';
				break;
			default:
				$inputHtml = '';
		}
		return $inputHtml;
	}

}

?>
