<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Xdbase_AbstractEditAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */
require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractAction.class.php';

class Xdbase_AbstractEditAction extends Xdbase_AbstractAction
{
	var $mObject = null;
	var $mObjectHandler = null;
	var $mActionForm = null;

	/**
	 * @protected
	 */
	function _getId()
	{
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
	}

	/**
	 * @protected
	 */
	function _setupObject()
	{
		$id = $this->_getId();

		$this->mObjectHandler =& $this->_getHandler();
		$this->mObject =& $this->mObjectHandler->get($id);

		if ($this->mObject == null && $this->_isEnableCreate())
		{
			$this->mObject =& $this->mObjectHandler->create();
		}
	}

	/**
	 * @protected
	 */
	function _isEnableCreate()
	{
		return true;
	}

	/**
	 * @public
	 */
	function prepare()
	{
		parent::prepare();
		$this->_setupObject();
		$this->_setupActionForm();
	}

	/**
	 * @public
	 */
	function getDefaultView()
	{
		if ($this->mObject == null)
		{
			return XDBASE_FRAME_VIEW_ERROR;
		}
	
		$this->mActionForm->load($this->mObject);
	
		return XDBASE_FRAME_VIEW_INPUT;
	}

	/**
	 * @public
	 */
	function execute()
	{
		if ($this->mObject == null) {
			return XDBASE_FRAME_VIEW_ERROR;
		}
	
		if (xdbaseGetRequest('_form_control_cancel') != null) {
			return XDBASE_FRAME_VIEW_CANCEL;
		}
	
		$this->mActionForm->load($this->mObject);
	
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
	
		if ($this->mActionForm->hasError()) {
			return XDBASE_FRAME_VIEW_INPUT;
		}
	
		$this->mActionForm->update($this->mObject);
	
		return $this->_doExecute($this->mObject);
	}

	/**
	 * @protected
	 */
	function _doExecute()
	{
		if ($this->mObjectHandler->insert($this->mObject)) {
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
	
// debug
//exit(var_dump($this->mObjectHandler->_insert($this->mObject)));
//exit(var_dump($this->mObjectHandler->_update($this->mObject)));
		return XDBASE_FRAME_VIEW_ERROR;
	}

}

?>
