<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeEditForm.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_ActionForm.class.php';

class Xdbase_Admin_Data_attributeEditForm extends Xdbase_ActionForm
{
	var $dataHandler = null;

	/**
	 * @public
	 */
	function getTokenName()
	{
		return 'module.xdbase.Admin_Data_attributeEditForm.TOKEN';
	}

	/**
	 * @public
	 */
	function prepare()
	{
		$this->dataConfigHandler =& $this->mController->load('handler', 'data');
		//
		// Set form properties
		//
		$this->mFormProperties['aid'] =& new Xdbase_IntProperty('aid');
		$this->mFormProperties['did'] =& new Xdbase_IntProperty('did');
		$this->mFormProperties['type'] =& new Xdbase_IntProperty('type');
		$this->mFormProperties['uid'] =& new Xdbase_IntProperty('uid');
		$this->mFormProperties['email'] =& new Xdbase_StringProperty('email');
		$this->mFormProperties['status'] =& new Xdbase_BoolProperty('status');
		$this->mFormProperties['poster_ip'] =& new Xdbase_StringProperty('poster_ip');
		$this->mFormProperties['timestamp'] =& new Xdbase_IntProperty('timestamp');
		$this->mFormProperties['int01'] =& new Xdbase_IntProperty('int01');
		$this->mFormProperties['int02'] =& new Xdbase_IntProperty('int02');
		$this->mFormProperties['int03'] =& new Xdbase_IntProperty('int03');
		$this->mFormProperties['int04'] =& new Xdbase_IntProperty('int04');
		$this->mFormProperties['int05'] =& new Xdbase_IntProperty('int05');
		$this->mFormProperties['option_value'] =& new Xdbase_TextProperty('option_value');

		//
		// Set field properties
		//
/*
		$this->mFieldProperties['aid'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['aid']->setDependsByArray(array('required'));
		$this->mFieldProperties['aid']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_AID);

		$this->mFieldProperties['did'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['did']->setDependsByArray(array('required'));
		$this->mFieldProperties['did']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_DID);

		$this->mFieldProperties['uid'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['uid']->setDependsByArray(array('required'));
		$this->mFieldProperties['uid']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_UID);

		$this->mFieldProperties['email'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['email']->setDependsByArray(array('email'));
		$this->mFieldProperties['email']->addMessage('email', _MD_XDBASE_ERROR_EMAIL, _MD_XDBASE_LANG_EMAIL);
*/
	}


	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('aid', $obj->get('aid'));
		$this->set('did', $obj->get('did'));
		$this->set('type', $obj->get('type'));
		$this->set('uid', $obj->get('uid'));
		$this->set('email', $obj->get('email'));
		$this->set('status', $obj->get('status'));
		$this->set('poster_ip', $obj->get('poster_ip'));
		$this->set('timestamp', $obj->get('timestamp'));
		$this->set('int01', $obj->get('int01'));
		$this->set('int02', $obj->get('int02'));
		$this->set('int03', $obj->get('int03'));
		$this->set('int04', $obj->get('int04'));
		$this->set('int05', $obj->get('int05'));
		$this->set('option_value', $obj->get('option_value'));

	}


	/**
	 * @public
	 */
	function update(&$obj)
	{
		$obj->set('aid', $this->get('aid'));
		$obj->set('did', $this->get('did'));
		$obj->set('type', $this->get('type'));
		$obj->set('uid', $this->get('uid'));
		$obj->set('email', $this->get('email'));
		$obj->set('status', $this->get('status'));
		$obj->set('poster_ip', $_SERVER['REMOTE_ADDR']);
		$obj->set('timestamp', $this->get('timestamp'));
		$obj->set('int01', $this->get('int01'));
		$obj->set('int02', $this->get('int02'));
		$obj->set('int03', $this->get('int03'));
		$obj->set('int04', $this->get('int04'));
		$obj->set('int05', $this->get('int05'));
		$obj->set('option_value', $this->get('option_value'));

		$uid = xdbaseGetUid();
		$offset = xdbaseGetTimeOffset();

		$obj->set('timestamp', time() - $offset);

		if ($obj->isNew())
		{
			$obj->set('uid', $uid);
		}
	}

}

?>
