<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataDeleteForm.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_ActionForm.class.php';

class Xdbase_Admin_DataDeleteForm extends Xdbase_ActionForm
{
	var $mOldImageName1 = null;
	var $mOldImageName2 = null;
	var $mOldFileName1 = null;

	/**
	 * @public
	 */
	function getTokenName()
	{
		return 'module.xdbase.Admin_DataDeleteForm.TOKEN';
	}

	/**
	 * @public
	 */
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['did'] =& new Xdbase_IntProperty('did');

		//
		// Set field properties
		//
		$this->mFieldProperties['did'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['did']->setDependsByArray(array('required'));
		$this->mFieldProperties['did']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_DID);
	}

	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('did', $obj->get('did'));

		$this->mOldImageName1 = $obj->get('img01');
		$this->mOldImageName2 = $obj->get('img02');
		$this->mOldFileName1 = $obj->get('file01');
	}

	/**
	 * @public
	 */
	function update(&$obj)
	{
		$obj->set('did', $this->get('did'));

		$this->deleteImage($this->mOldImageName1);
		$this->deleteImage($this->mOldImageName2);
		$this->deleteFile($this->mOldFileName1);
	}

	function deleteImage($imageName)
	{
		if ($imageName != '')
		{
			if (file_exists(_MD_XDBASE_CONST_PHOTOS_PATH.'/'.$imageName))
			{
				@unlink(_MD_XDBASE_CONST_PHOTOS_PATH.'/'.$imageName);
			}
			if (file_exists(_MD_XDBASE_CONST_THUMBS_PATH.'/'.$imageName))
			{
				@unlink(_MD_XDBASE_CONST_THUMBS_PATH.'/'.$imageName);
			}
		}
	}

	function deleteFile($fileName)
	{
		if ($fileName != '')
		{
			if (file_exists(_MD_XDBASE_CONST_FILES_PATH.'/'.$fileName))
			{
				@unlink(_MD_XDBASE_CONST_FILES_PATH.'/'.$fileName);
			}
		}
	}

}

?>
