<?php
/**
 * @file
 * @package xdbase
 * @version $Id: VcardHandler.php,v 1.3 2010/02/23 02:38:27 bluemelon Exp $
 */


class VCardHandler
{
	function VCardHandler()
	{
		$this->__construct();
	}

	function __construct()
	{
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getColumnKeyArray()
	{
		$keyArray = array(
			'did'=>'',
			'cid'=>'',
			'title'=>'FN',
			'tag'=>'',
			'pid'=>'',
			'uid'=>'UID',
			'name'=>'NICKNAME',
			'poster_ip'=>'',
			'created_date'=>'CREATIONDATE',
			'updated_date'=>'',
			'published_date'=>'',
			'expired_date'=>'',
			's_date'=>'BDAY',
			'e_date'=>'',
			'password'=>'',
			'url'=>'URL',
			'email'=>'EMAIL',
			'zip'=>'ADR_POSTCODE',
			'state'=>'ADR_REGION',
			'city'=>'ADR_LOCALITY',
			'street'=>'ADR_STREET',
			'phone'=>'TEL_HOME',
			'mobile_phone'=>'TEL_CELL',
			'fax'=>'TEL_HOME_FAX',
			'show_map'=>'',
			'latitude'=>'',
			'longitude'=>'',
			'zoom'=>'',
			'img01'=>'',
			'img01_height'=>'',
			'img01_width'=>'',
			'img02'=>'',
			'img02_height'=>'',
			'img02_width'=>'',
			'file01'=>'',
			'file01name'=>'FileName',
			'file01ext'=>'VERSION',
			'file01size'=>'',
			'body'=>'NOTE',
			'int01'=>'',
			'int02'=>'',
			'int03'=>'',
			'int04'=>'',
			'int05'=>'',
			'int06'=>'',
			'int07'=>'',
			'int08'=>'',
			'int09'=>'',
			'int10'=>'',
			'float01'=>'',
			'float02'=>'',
			'varchar01'=>'N_FAMILY',
			'varchar02'=>'N_GIVEN',
			'varchar03'=>'N_PREFIX',
			'varchar04'=>'N_SUFFIX',
			'varchar05'=>'ORG_0',
			'varchar06'=>'ORG_1',
			'varchar07'=>'ADR_6',
			'varchar08'=>'',
			'varchar09'=>'ADR_COUNTRY',
			'varchar10'=>'SOURCE',
			'text01'=>'',
			'text02'=>'',
			'reservation'=>'',
			'option_value'=>'',
			'weight'=>'',
			'status'=>'',
			'access'=>'',
			'groups'=>'',
			'hits'=>'',
			'comments'=>'',
			'rating'=>'',
			'votes'=>'',
			'downloads'=>'',
			'trackbacks'=>'',
			'pipe_id'=>'',
			'dohtml'=>'',
			'doxcode'=>'',
			'dosmiley'=>'',
			'doimage'=>'',
			'dobr'=>''
		);
		return $keyArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getColumnArray()
	{
		$myts =& MyTextSanitizer::getInstance();
		$keyArray = $this->getColumnKeyArray();
		$columnArray = array();
		$prefix = 'data_';

		foreach ($keyArray as $key=>$value)
		{
			$key = $prefix.$key;
			$value = $myts->addSlashes(xdbaseGetRequest($key));
			$columnArray[$key] = $value;
		}

		return $columnArray;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getColumnOptionArray()
	{
		$optionArray = array();
		$columnArray = $this->getColumnKeyArray();
		$i = 0;
		foreach ($columnArray as $column=>$value)
		{
			if ($value != '')
			{
				$optionArray[$i]['field'] = $value;
				$optionArray[$i]['value'] = $value;
				$optionArray[$i]['type'] = '';
				$optionArray[$i]['selected'] = $column;
				$i++;
			}
		}
		return $optionArray;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getVcardArray($filePath)
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/Contact_Vcard_Parse.php';
		$vcardParser =& new Contact_Vcard_Parse();
		$vcardArray = array();
//		$columnArray = $this->getColumnArray();
		$columnArray = $this->getColumnKeyArray();

//		$vcard = $vcardParser->fromFile($filePath);
		$vcard = $vcardParser->fromFile($filePath, false, 'SJIS');
		$vcardValueArray = $this->setColumn($vcard[0]);

		$vcardArray[0] = array_keys($columnArray);
		$i = 0;
		foreach ($columnArray as $column => $name)
		{
			if (array_key_exists($name, $vcardValueArray))
			{
//				$vcardArray[1][$column] = $vcardValueArray[$name];
				$vcardArray[1][$i] = $vcardValueArray[$name];
			}
			else
			{
//				$vcardArray[1][$column] = '';
				$vcardArray[1][$i] = '';
			}

			if ($column == 'status')
			{
//				$vcardArray[1]['status'] = true;
				$vcardArray[1][$i] = true;
			}
			$i++;
		}

		return $vcardArray;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setColumn($vcard)
	{
		$recordArray = array();

		$lastName = $vcard['N'][0]['value'][0][0];
		$firstName = $vcard['N'][0]['value'][1][0];
		$fullName = $vcard['N'][0]['value'][3][0];
		if ($fullName == '') $fullName = $lastName.' '.$firstName;
		$recordArray['N_FAMILY'] = $lastName; // last name
		$recordArray['N_GIVEN'] = $firstName; // first name
		$recordArray['FN'] = $fullName; // full name
		$recordArray['N_SUFFIX'] = $vcard['N'][0]['value'][4][0]; // suffix
		$recordArray['NICKNAME'] = $vcard['NICKNAME'][0]['value'][0][0]; // nickname
		$recordArray['ORG_0'] = $vcard['ORG'][0]['value'][0][0]; // organization
		$recordArray['ORG_1'] = $vcard['ORG'][0]['value'][1][0]; // department
		$recordArray['NOTE'] = $vcard['NOTE'][0]['value'][0][0]; // note
		$recordArray['BDAY'] = substr($vcard['BDAY'][0]['value'][0][0], 0, 10); // birthdate
//		$recordArray['varchar08'] = ($vcard['X-ABSHOWAS'][0]['value'][0][0] == "COMPANY"); // company

		if (is_array($vcard['EMAIL']))
		{
			foreach ($vcard['EMAIL'] as $email)
			{
				$tmp = array();
				$tmp['label'] = 'WORK';	//default
				if (is_array($email['param']['TYPE']))
				{
					foreach ($email['param']['TYPE'] as $key => $value) $email['param']['TYPE'][$key] = strtoupper($value);
					
					if (in_array('WORK', $email['param']['TYPE'])) $tmp['label'] = 'WORK';
					if (in_array('HOME', $email['param']['TYPE'])) $tmp['label'] = 'HOME';
				}
				if (!empty($email['X-ABLABEL'])) $tmp['label'] = $email['X-ABLABEL']['value'][0][0];
				$recordArray['Email'] = $email['value'][0][0]; // email
			}
		}

		if (is_array($vcard['TEL']))
		{
			foreach ($vcard['TEL'] as $phone)
			{
				$tmp = array();
				$tmp['label'] = 'WORK';	//default
				if(is_array($phone['param']['TYPE']))
				{
					foreach ($phone['param']['TYPE'] as $key => $value) $phone['param']['TYPE'][$key] = strtoupper($value);
					
					if(in_array('WORK', $phone['param']['TYPE'])) $tmp['label'] = 'WORK';
					if(in_array('HOME', $phone['param']['TYPE'])) $tmp['label'] = 'HOME';
					if(in_array('CELL', $phone['param']['TYPE'])) $tmp['label'] = 'CELL';
					if(in_array('MAIN', $phone['param']['TYPE'])) $tmp['label'] = 'MAIN';
					if(in_array('PAGER', $phone['param']['TYPE'])) $tmp['label'] = 'PAGER';
					if(in_array('FAX', $phone['param']['TYPE'])) $tmp['label'] .= ' FAX';
				}
				if(!empty($phone['X-ABLABEL'])) $tmp['label'] = $phone['X-ABLABEL']['value'][0][0];
				$recordArray['Phone'] = $phone['value'][0][0]; // phone
			}
		}

		if (is_array($vcard['ADR']))
		{
			foreach ($vcard['ADR'] as $address)
			{
				$tmp = array();
				$tmp['label'] = 'WORK';	//default
				if (is_array($address['param']['TYPE']))
				{
					foreach ($address['param']['TYPE'] as $key => $value) $address['param']['TYPE'][$key] = strtoupper($value);
					if (in_array('WORK', $address['param']['TYPE'])) $tmp['label'] = 'WORK';
					if (in_array('HOME', $address['param']['TYPE'])) $tmp['label'] = 'HOME';
				}
				if (!empty($address['X-ABLABEL'])) $tmp['label'] = $address['X-ABLABEL']['value'][0][0];
				
	//			$recordArray['pobox'] = $address['value'][0][0]; // pobox
//				$recordArray['ext_adr'] = $address['value'][1][0]; // ext_adr
				$recordArray['ADR_STREET'] = $address['value'][2][0]; // street
				$recordArray['ADR_LOCALITY'] = $address['value'][3][0]; // city
				$recordArray['ADR_REGION'] = $address['value'][4][0]; // state
				$recordArray['ADR_POSTCODE'] = $address['value'][5][0]; // zip
				$recordArray['Country'] = $address['value'][6][0]; // country
//				$recordArray['varchar10']  = $address['X-ABADR']['value'][0][0]; // template
			}
		}

		return $recordArray;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function createVcardFile($rowArray)
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/Contact_Vcard_Build.php';

		if (@function_exists('gzcompress'))
		{
			require_once(XOOPS_ROOT_PATH . '/class/zipdownloader.php');
			$downloader = new XoopsZipDownloader();
		}

		$archiveFileName = _MD_XDBASE_CONST_MODULEDIRNAME.'_Vcard_'.date('Ymd_Hi');

		foreach ($rowArray as $row)
		{
			$vcard =& new Contact_Vcard_Build();

			$fileName = mb_convert_encoding($row['title'], 'SJIS','ASCII,JIS,UTF-8,EUC-JP,SJIS').'.vcf';

			$n_family = $this->convert_UTF8($row['varchar01']);
			$n_given = $this->convert_UTF8($row['varchar02']);
			$n_prefix = $this->convert_UTF8($row['varchar03']);
			$n_suffix = $this->convert_UTF8($row['varchar04']);
			$vcard->setName($n_family, $n_given, '', $n_prefix, $n_suffix);
			$vcard->setFormattedName($this->convert_UTF8($row['title']));
			$vcard->setVersion($row['file01ext']);
			$vcard->setSource($row['varchar10']);
			$vcard->setBirthday(date('Ymd', $row['s_date']));
			$vcard->setNote($this->convert_UTF8($row['body']));

			$adr_street = $this->convert_UTF8($row['street']);
			$adr_locality = $this->convert_UTF8($row['city']);
			$adr_region = $this->convert_UTF8($row['state']);
			$adr_postcode = $this->convert_UTF8($row['zip']);
			$adr_country = $this->convert_UTF8($row['varchar09']);
			$vcard->addAddress('', '', $adr_street, $adr_locality, $adr_region,$adr_postcode, $adr_country);
			$vcard->addTelephone($row['phone']);
			$vcard->addEmail($row['email']);
			$vcard->addNickname($this->convert_UTF8($row['name']));

			$downloader->addBinaryFileData($vcard->fetch(), $fileName);
		}

		ob_end_clean();

		echo $downloader->download($archiveFileName, true);

		return;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function convert_UTF8($str)
	{
//		$convert_str = mb_convert_encoding($str, 'SJIS','ASCII,JIS,UTF-8,EUC-JP,SJIS');
		$convert_str = mb_convert_encoding($str, 'UTF-8','ASCII,JIS,UTF-8,EUC-JP,SJIS');
		return $convert_str;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

?>
