<?php
/**
 * @file
 * @package xdbase
 * @version $Id: ContactXMLHandler.php,v 1.3 2010/02/23 02:38:27 bluemelon Exp $
 */

if (!defined('XDBASE_TRUST_DIRNAME')) exit;

class ContactXMLHandler
{
	var $message = array();
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function ContactXMLHandler()
	{
		$this->__construct();
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function __construct()
	{
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getColumnKeyArray()
	{
		$keyArray = array(
			'did'=>'',
			'cid'=>'',
			'title'=>'c:FormattedName',
			'tag'=>'',
			'pid'=>'',
			'uid'=>'',
			'name'=>'c:NickName',
			'poster_ip'=>'',
			'created_date'=>'c:CreationDate',
			'updated_date'=>'c:ModificationDate',
			'published_date'=>'',
			'expired_date'=>'',
			's_date'=>'',
			'e_date'=>'',
			'password'=>'',
			'url'=>'',
			'email'=>'c:Address',
			'zip'=>'c:PostalCode',
			'state'=>'c:Region',
			'city'=>'c:Locality',
			'street'=>'c:Street',
			'phone'=>'',
			'mobile_phone'=>'',
			'fax'=>'',
			'show_map'=>'',
			'latitude'=>'',
			'longitude'=>'',
			'zoom'=>'',
			'img01'=>'',
			'img01_height'=>'',
			'img01_width'=>'',
			'img02'=>'',
			'img02_height'=>'',
			'img02_width'=>'',
			'file01'=>'',
			'file01name'=>'FileName',
			'file01ext'=>'',
			'file01size'=>'',
			'body'=>'c:Notes',
			'int01'=>'',
			'int02'=>'',
			'int03'=>'',
			'int04'=>'',
			'int05'=>'',
			'int06'=>'',
			'int07'=>'',
			'int08'=>'',
			'int09'=>'',
			'int10'=>'',
			'float01'=>'',
			'float02'=>'',
			'varchar01'=>'c:FamilyName',
			'varchar02'=>'c:GivenName',
			'varchar03'=>'c:Gender',
			'varchar04'=>'MSWABMAPI:PropTag0x8010001F',
			'varchar05'=>'MSWABMAPI:PropTag0x800F001F',
			'varchar06'=>'c:Office',
			'varchar07'=>'c:ContactID',
			'varchar08'=>'c:Company',
			'varchar09'=>'',
			'varchar10'=>'',
			'text01'=>'',
			'text02'=>'',
			'reservation'=>'',
			'option_value'=>'',
			'weight'=>'',
			'status'=>'',
			'access'=>'',
			'groups'=>'',
			'hits'=>'',
			'comments'=>'',
			'rating'=>'',
			'votes'=>'',
			'downloads'=>'',
			'trackbacks'=>'',
			'pipe_id'=>'',
			'dohtml'=>'',
			'doxcode'=>'',
			'dosmiley'=>'',
			'doimage'=>'',
			'dobr'=>''
		);
		return $keyArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	function getColumnArray()
	{
		$myts =& MyTextSanitizer::getInstance();
		$keyArray = $this->getColumnKeyArray();
		$columnArray = array();
		$prefix = 'data_';

		foreach ($keyArray as $key=>$value)
		{
			$key = $prefix.$key;
			$value = $myts->addSlashes(xdbaseGetRequest($key));
			$columnArray[$key] = $value;
		}

		return $columnArray;
	}
*/
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getKeyArray()
	{
		$keyArray = array(
				'FileName',
				'c:contact',
				'c:Gender',
				'c:Notes',
				'c:Extended',
				'c:CreationDate',
				'c:ModificationDate',
				'MSWABMAPI:PropTag0x8010001F',
				'MSWABMAPI:PropTag0x800F001F',
				'c:ContactIDCollection',
				'c:ContactID',
				'c:EmailAddress',
				'c:Address',
				'c:NickName',
				'c:FormattedName',
				'c:FamilyName',
				'c:GivenName',
				'c:PostalCode',
				'c:Region',
				'c:Locality',
				'c:Street',
				'c:LabelCollection',
				'c:Number',
				'c:Office'
			);
		return $keyArray;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	function getContactXMLArrayFromDir($dirPath)
	{
		$columnArray = $this->getColumnKeyArray();
		$xmlArray = array();

		if (!$files = opendir($dirPath)) return false;

		$matchStr = "/(\w+|\W+)\.contact$/";

		$i = 0;
		while (($fileName = readdir($files)) !== false)
		{
			if (preg_match($matchStr, $fileName))
			{
				$xmlFilePath = $filePath . $fileName;
				if (is_file($xmlFilePath))
				{
					$xmlValueArray = $this->getXMLValuefromFile($xmlFilePath);

					foreach ($columnArray as $column=>$xmlName)
					{
						if (array_key_exists($xmlName, $xmlValueArray))
						{
							$xmlArray[$i][$column] = $xmlValueArray[$xmlName];
						}
						else
						{
							$xmlArray[$i][$column] = '';
						}

						if ($column == 'status')
						{
							$vcardArray[$i]['status'] = true;
						}

					}
					$i++;
				}
			}
		}

		closedir($files);

		return $xmlArray;
	}
*/
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getContactXMLArray($filePath)
	{
		$columnArray = $this->getColumnKeyArray();
		$xmlArray = array();

		$xmlValueArray = $this->getXMLValuefromFile($filePath);

		$xmlArray[0] = array_keys($columnArray);

		$i = 0;
		foreach ($columnArray as $column => $xmlName)
		{
			if (array_key_exists($xmlName, $xmlValueArray))
			{
				if ($xmlName == 'c:CreationDate' || $xmlName == 'c:ModificationDate')
				{
					$strDate = $xmlValueArray[$xmlName];
					$year = substr($strDate, 0, 4);
					$month = substr($strDate, 5, 2);
					$day = substr($strDate, 8, 2);
					$hour = substr($strDate, 11, 2);
					$minute = substr($strDate, 14, 2);
					$second = substr($strDate, 17, 2);
//					$xmlArray[1][$column] = mktime($hour, $minute, $second, $month, $day, $year);
					$xmlArray[1][$i] = mktime($hour, $minute, $second, $month, $day, $year);
				}
				else
				{
//					$xmlArray[1][$column] = $xmlValueArray[$xmlName];
					$xmlArray[1][$i] = $xmlValueArray[$xmlName];
				}
			}
			else
			{
//				$xmlArray[1][$column] = '';
				$xmlArray[1][$i] = '';
			}

			if ($column == 'status')
			{
//				$vcardArray[1]['status'] = true;
				$vcardArray[1][$i] = true;
			}
			$i++;
		}

		return $xmlArray;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// use XMLReader
	function getXMLValuefromFile($filename)
	{
		$text = '';
		if (file_exists($filename) && is_readable($filename))
		{
			$text = file_get_contents($filename);
		}

		$reader = new XMLReader;
		$reader->XML($text, null, LIBXML_NOBLANKS);
		$xml = '';
		$nameArray = array();
		$valueArray = array();
		$nodeNameArray = $this->getKeyArray();

		$i = 0;
		$valueArray['FileName'] = mb_convert_encoding(basename($filename), "UTF-8", "SJIS");

		$i++;
		while ($reader->read())
		{
			$value = '';
			if ($reader->nodeType == XMLReader::ELEMENT)
			{
				if ($reader->hasAttributes)
				{
					for ($j = 0; $j < $reader->attributeCount; $j++)
					{
						$reader->moveToAttribute($j);
						if ($reader->nodeType == XMLReader::ELEMENT && in_array($reader->name, $nodeNameArray))
						{
							$name = $reader->name;
							if ($reader->hasValue)
							{
								$value = $reader->value;
							}
							else
							{
								$reader->read();
								if ($reader->nodeType == XMLReader::TEXT)
								{
									$value = $reader->value;
								}
								elseif ($reader->nodeType == XMLReader::ELEMENT)
								{
									$name = $reader->name;
								}
							}
							$valueArray[$name] = $value;
//							$valueArray[$name] = mb_convert_encoding($value, "UTF-8", "EUCJP");
							$i++;
						}
					}
					$reader->moveToElement();
				}
				else
				{
					if ($reader->nodeType == XMLReader::ELEMENT && in_array($reader->name, $nodeNameArray))
					{
						$name = $reader->name;
						if ($reader->hasValue)
						{
							$value = $reader->value;
						}
						else
						{
							$reader->read();
							if ($reader->nodeType == XMLReader::TEXT)
							{
								$value = $reader->value;
							}
							elseif ($reader->nodeType == XMLReader::ELEMENT)
							{
								$name = $reader->name;
							}
						}
						$valueArray[$name] = $value;
//						$valueArray[$name] = mb_convert_encoding($value, "UTF-8", "EUCJP");
						$i++;
					}
				}
			}
			elseif ($reader->nodeType == XMLReader::END_ELEMENT)
			{
			}
			elseif ($reader->nodeType == XMLReader::TEXT)
			{
				$value = $reader->value;
				$valueArray[$name] = $value;
//				$valueArray[$name] = mb_convert_encoding($value, "UTF-8", "EUCJP");
				$i++;
			}
		}
		$reader->close();


		return $valueArray;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function createContactXMLFile($rowArray)
	{
		$archiveFileName = _MD_XDBASE_CONST_MODULEDIRNAME.'_ContactXML_'.date('Ymd_Hi');

		if (@function_exists('gzcompress'))
		{
			require_once(XOOPS_ROOT_PATH . '/class/zipdownloader.php');
			$downloader = new XoopsZipDownloader();
		}

		$text = '';

		foreach ($rowArray as $row)
		{
			$fileName = mb_convert_encoding($row['title'], 'SJIS','ASCII,JIS,UTF-8,EUC-JP,SJIS').'.contact';

			$text = '<?xml version="1.0" encoding="UTF-8"?>'."\n";
			$text .= '<c:contact c:Version="1" xmlns:c="http://schemas.microsoft.com/Contact" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:MSP2P="http://schemas.microsoft.com/Contact/Extended/MSP2P" xmlns:MSWABMAPI="http://schemas.microsoft.com/Contact/Extended/MSWABMAPI">'."\n";
			$text .= '<c:Notes c:Version="2" c:ModificationDate="'.date('Y-m-d').'T'.date('H:i:s').'Z">'.$row['body'].'</c:Notes>'."\n";
			$text .= '<c:CreationDate>'.date('Y-m-d', $row['created_date']).'T'.date('H:i:s', $row['created_date']).'Z'.'</c:CreationDate>'."\n";
			$text .= '<c:Extended>';
			$text .= '<MSWABMAPI:PropTag0x8010001F c:type="string" c:Version="1" c:ModificationDate="'.date('Y-m-d').'T'.date('H:i:s').'Z">'.$row['varchar04'].'</MSWABMAPI:PropTag0x8010001F>';
			$text .= '<MSWABMAPI:PropTag0x800F001F c:type="string" c:Version="2" c:ModificationDate="'.date('Y-m-d').'T'.date('H:i:s').'Z">'.$row['varchar05'].'</MSWABMAPI:PropTag0x800F001F>';
			$text .= '</c:Extended>'."\n";
			$text .= '<c:ContactIDCollection>';
			$text .= '<c:ContactID c:ElementID="b2789c1a-30f7-4c6f-9628-02c5dc980706">';
			$text .= '<c:Value>'.$row['varchar07'].'</c:Value>';
			$text .= '</c:ContactID>';
			$text .= '</c:ContactIDCollection>'."\n";
			$text .= '<c:EmailAddressCollection>'."\n";
			$text .= '<c:EmailAddress c:ElementID="161558c6-a747-4ce1-8912-b06c4e8d445c" c:Version="2" c:ModificationDate="'.date('Y-m-d').'T'.date('H:i:s').'Z">';
			$text .= '<c:Address c:Version="1" c:ModificationDate="'.date('Y-m-d').'T'.date('H:i:s').'Z">'.$row['email'].'</c:Address>';
			$text .= '</c:EmailAddress>';
			$text .= '</c:EmailAddressCollection>'."\n";
			$text .= '<c:NameCollection>'."\n";
			$text .= '<c:Name c:ElementID="c2356be2-1f3d-4f25-8d54-a5e37bfe26b9">'."\n";
			$text .= '<c:NickName>'.$row['name'].'</c:NickName>'."\n";
			$text .= '<c:FormattedName>'.$row['title'].'</c:FormattedName>'."\n";
			$text .= '<c:FamilyName>'.$row['varchar01'].'</c:FamilyName>'."\n";
			$text .= '<c:GivenName>'.$row['varchar02'].'</c:GivenName>'."\n";
			$text .= '</c:Name>'."\n";
			$text .= '</c:NameCollection>'."\n";
			$text .= '<c:PhysicalAddressCollection>'."\n";
			$text .= '<c:PhysicalAddress c:ElementID="a3200e20-babf-4c1a-b444-754b683d8634">'."\n";
			$text .= '<c:PostalCode>'.$row['zip'].'</c:PostalCode>'."\n";
			$text .= '<c:Region>'.$row['state'].'</c:Region>'."\n";
			$text .= '<c:Locality>'.$row['city'].'</c:Locality>'."\n";
			$text .= '<c:Street>'.$row['street'].'</c:Street>'."\n";
			$text .= '<c:LabelCollection>'."\n";
			$text .= '<c:Label>Personal</c:Label>'."\n";
			$text .= '</c:LabelCollection>'."\n";
			$text .= '</c:PhysicalAddress>'."\n";
			$text .= '</c:PhysicalAddressCollection>'."\n";
			$text .= '<c:PositionCollection>'."\n";
			$text .= '<c:Position c:ElementID="53c1bf18-83d4-4768-9e6e-283c6adfdd08">'."\n";
			$text .= '<c:Office>'.$row['varchar06'].'</c:Office>'."\n";
			$text .= '<c:Company>'.$row['varchar08'].'</c:Company>'."\n";
			$text .= '<c:LabelCollection>'."\n";
			$text .= '<c:Label>Business</c:Label>'."\n";
			$text .= '</c:LabelCollection>'."\n";
			$text .= '</c:Position>'."\n";
			$text .= '</c:PositionCollection>'."\n";
			$text .= '<c:PhoneNumberCollection>'."\n";
			$text .= '<c:PhoneNumber c:ElementID="f39b3c33-32ba-4092-88eb-24bea931b414">'."\n";
			$text .= '<c:Number>'.$row['phone'].'</c:Number>'."\n";
			$text .= '<c:LabelCollection>'."\n";
			$text .= '<c:Label>Fax</c:Label>'."\n";
			$text .= '<c:Label>Personal</c:Label>'."\n";
			$text .= '</c:LabelCollection>'."\n";
			$text .= '</c:PhoneNumber>'."\n";
			$text .= '<c:PhoneNumber c:ElementID="d30d7232-3b7b-46e7-a76b-f02336357704">'."\n";
			$text .= '<c:Number>'.$row['phone'].'</c:Number>'."\n";
			$text .= '<c:LabelCollection>'."\n";
			$text .= '<c:Label>Voice</c:Label>'."\n";
			$text .= '<c:Label>Personal</c:Label>'."\n";
			$text .= '</c:LabelCollection>'."\n";
			$text .= '</c:PhoneNumber>'."\n";
			$text .= '</c:PhoneNumberCollection>'."\n";
			$text .= '<c:PhotoCollection>'."\n";
			$text .= '<c:Photo c:ElementID="4f5bd1fa-87b9-4b6e-9414-f0853f310fe6">'."\n";
			$text .= '<c:LabelCollection>'."\n";
			$text .= '<c:Label>UserTile</c:Label>'."\n";
			$text .= '</c:LabelCollection>'."\n";
			$text .= '</c:Photo>'."\n";
			$text .= '</c:PhotoCollection>'."\n";
			$text .= '</c:contact>'."\n";

			$text = mb_convert_encoding($text, 'UTF-8','ASCII,JIS,UTF-8,EUC-JP,SJIS');

			$downloader->addBinaryFileData($text, $fileName);
		}

		ob_end_clean();

		echo $downloader->download($archiveFileName, true);

		return;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}

?>
