<?php
/**
 * @file
 * @package xdbase
 * @version $Id: CatDeleteAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractDeleteAction.class.php';

class Xdbase_Admin_CatDeleteAction extends Xdbase_AbstractDeleteAction
{
	/**
	 * @protected
	 */
	function &_getId()
	{
		$ret = xdbaseGetRequest('cid');
		return $ret;
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'cat');
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.delete_cat');
		$ret =& $this->mActionForm->prepare();
		return $ret;
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);

		$this->mTpl->assign('handler', $this->mObjectHandler);
		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/cat_delete.html');
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=CatList');
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=CatList', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=CatList');
	}

	/**
	 * @protected
	 */
	function _doExecute()
	{
		if ($this->mObjectHandler->delete($this->mObject))
		{
			$db =& Database::getInstance();
			$catTableName = $db->prefix($this->mController->mDirname.'_cat');
			$dataTableName = $db->prefix($this->mController->mDirname.'_data');
			$this->mObjectHandler->setTree();
			$cidArray = $this->mObjectHandler->getAllChildId($this->_getId());
			$catCriteria =& new Xdbase_CriteriaCompo();
			$catCriteria->add(new Xdbase_Criteria('cid', $this->_getId()));
			xoops_notification_deletebyitem($this->mController->mXoopsModule->getVar('mid'), 'cat', $this->_getId());
			// delete sub categories
			if (count($cidArray) > 0)
			{
				foreach ($cidArray as $cid)
				{
					$catCriteria->add(new Xdbase_Criteria('cid', $cid), 'OR');
					xoops_notification_deletebyitem($this->mController->mXoopsModule->getVar('mid'), 'cat', $cid);
				}
			}
			$sql = "DELETE FROM `" . $catTableName . "` WHERE " . $catCriteria->render();
			$result = $db->query($sql);
			if (!$result)
			{
				return XDBASE_FRAME_VIEW_ERROR;
			}

			$sql ="SELECT did FROM `".$dataTableName."`";
			$where = $catCriteria->render();
			if ($where != '')
			{
				$sql .= " WHERE ".$where;
			}

			$result = $db->query($sql);
			if (!$result)
			{
				return XDBASE_FRAME_VIEW_ERROR;
			}

			// delete data
			$didArray = array();
			while (list($did) = $db->fetchRow($result)) $didArray[] = $did;
			$dataCriteria =& new Xdbase_CriteriaCompo();
			if (count($didArray) > 0)
			{
				foreach ($didArray as $did)
				{
					$dataCriteria->add(new Xdbase_Criteria('did', $did), 'OR');
					xoops_comment_delete($this->mController->mXoopsModule->getVar('mid'), $did);
					xoops_notification_deletebyitem($this->mController->mXoopsModule->getVar('mid'), 'data', $did);
				}
			}
			$sql = "DELETE FROM `" . $dataTableName . "` WHERE " . $dataCriteria->render();
			$result = $db->query($sql);
			if (!$result)
			{
				return XDBASE_FRAME_VIEW_ERROR;
			}

			return XDBASE_FRAME_VIEW_SUCCESS;
		}

		return XDBASE_FRAME_VIEW_ERROR;
	}
}

?>
