<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeEditAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_Data_attributeEditAction extends Xdbase_AbstractEditAction
{
	var $mAttributeActionForm = null;

	/**
	 * @protected
	 */
	function _getId()
	{
		return xdbaseGetRequest('aid');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_attribute');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'edit_data_attribute');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->checkPerm();
		$render->setTemplateName($this->mController->mDirname.'_data_attribute_edit.html');
		$xoopsTpl->assign('actionForm', $this->mActionForm);
		#cubson::lazy_load('data', $this->mObject);
		$xoopsTpl->assign('object', $this->mObject);

		$handler =& $this->mController->load('handler', 'data_attribute');
		$xoopsTpl->assign('handler', $handler);

		$dataHandler =& $this->mController->load('handler', 'data');
		$xoopsTpl->assign('dataHandler', $dataHandler);
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeView&aid='.$this->mObject->getShow('aid').'&type='.$this->mObject->getShow('type'));
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
//		$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
		$this->mController->executeRedirect('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'), 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'));
	}


	function _doExecute()
	{
		$this->checkPerm();
		if ($this->mObjectHandler->insert($this->mObject))
		{
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
		return XDBASE_FRAME_VIEW_ERROR;
	}

	function checkPerm()
	{
		$did = $this->mObject->getShow('did');
		$dataHandler =& $this->mController->load('handler', 'data');
		$dataObject =& $dataHandler->get($did);
		$reservation = false;
		if (is_object($dataObject))
		{
			$reservation = $dataObject->getShow('reservation');
		}
		if ($reservation)
		{
			if (!$this->mActionForm->mIsNew)
			{
				if (!$dataHandler->checkData($did))
				{
					$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
				}
				if (_MD_XDBASE_CONST_EDITABLE == false)
				{
					$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
				}
			}
		}
		else
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
		}
	}


}

?>
