<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Xdbase_AbstractListAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractAction.class.php';
require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_PageNavigator.class.php';

class Xdbase_AbstractListAction extends Xdbase_AbstractAction
{
	var $mObjects = array();
	var $mFilter = null;

	/**
	 * @protected
	 */
	function &_getHandler()
	{
	}

	/**
	 * @protected
	 */
	function &_getFilterForm()
	{
	}

	/**
	 * @protected
	 */
	function &_getBaseUrl()
	{
	}

	/**
	 * @protected
	 */
	function &_getPageNavi()
	{
		$navi =& new Xdbase_PageNavigator($this->_getBaseUrl(), XDBASE_PAGENAVI_START);
		return $navi;
	}

	/**
	 * customized
	 */
	function prepare()
	{
		Xdbase_AbstractAction::prepare();

		if ($this->mController->mAdminFlag)
		{
			return true;
		}

		$script_link = "";
		if (_MD_XDBASE_CONST_USEGMAP && _MD_XDBASE_CONST_GMAPKEY != '')
		{
			$script_link .= "\n<script src=\"http://maps.google.co.jp/maps?file=api&amp;hl=ja&amp;v=2.x&amp;key="._MD_XDBASE_CONST_GMAPKEY."\" type=\"text/javascript\" charset=\"utf-8\"></script>";
			$script_link .= "\n<script src=\"".XOOPS_URL."/modules/"._MD_XDBASE_CONST_MODULEDIRNAME."/include/gmap.js\" type=\"text/javascript\" charset=\"utf-8\"></script>";
		}
		if (_MD_XDBASE_CONST_USE_SCRIPT)
		{
			$script_link .= "\n<script src=\"".XOOPS_URL._MD_XDBASE_CONST_PTYPE_PATH."prototype.js\" type=\"text/javascript\"></script>";
			$script_link .= "\n<script src=\"".XOOPS_URL."/modules/"._MD_XDBASE_CONST_MODULEDIRNAME."/include/cookiemanager.js\" type=\"text/javascript\"></script>";
			$script_link .= "\n<script src=\"".XOOPS_URL."/modules/"._MD_XDBASE_CONST_MODULEDIRNAME."/include/xdbase.js\" type=\"text/javascript\"></script>\n";

/*
			$script_link .= "\n<script type=\"text/javascript\">\n";
			$script_link .= "<!--\n";
			$script_link .= "var showXdbaseCategory = false;\n";
			$script_link .= "var showXdbaseTagCloud = false;\n";
			$script_link .= "var showXdbaseTextSearchForm = false;\n";
			$script_link .= "var showXdbaseMap = false;\n";
			$script_link .= "var showXdbaseMap = false;\n";
			if (_MD_XDBASE_CONST_DISPLAYCATNAV)
			{
				$script_link .= "showXdbaseCategory = true;\n";
			}
			if (_MD_XDBASE_CONST_DISPLAYTAGCLOUD)
			{
				$script_link .= "showXdbaseTagCloud = true;\n";
			}
			if (_MD_XDBASE_CONST_DISPLAYFIELDSEARCH)
			{
				$script_link .= "showXdbaseTextSearchForm = true;\n";
			}
			if (_MD_XDBASE_CONST_SHOWGMAPTOP && _MD_XDBASE_CONST_USEGMAP && _MD_XDBASE_CONST_GMAPKEY != '')
			{
				$script_link .= "showXdbaseMap = true;\n";
			}
			$script_link .= "window.onload = xdbaseInitState;\n";
			$script_link .= "//-->\n";
			$script_link .= "</script>\n";
*/

		}

		$this->mTpl->assign('xoops_module_header', $this->mTpl->get_template_vars('xoops_module_header').$script_link);

		return true;
	}

	/**
	 * @public
	 */
	function getDefaultView()
	{
		$this->mFilter =& $this->_getFilterForm();
		$this->mFilter->fetch();

		$this->mFilter->mNavi->setTotalItems($this->mFilter->getTotalItems());
		$handler =& $this->_getHandler();
		$this->mObjects =& $handler->getObjects($this->mFilter->getCriteria());
		return XDBASE_FRAME_VIEW_INDEX;
	}

	/**
	 * @public
	 */
	function execute()
	{
		return $this->getDefaultView();
	}
}

?>
