<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataDeleteAction.class.php,v 1.5 2010/02/23 02:38:27 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractDeleteAction.class.php';

class Xdbase_DataDeleteAction extends Xdbase_AbstractDeleteAction
{
	/**
	 * @protected
	 */
	function &_getId()
	{
		$ret =& xdbaseGetRequest('did');
		return $ret;
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'delete_data');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->checkPerm();

		$GLOBALS['xoopsOption']['template_main'] = $this->mController->mDirname.'_data_delete.html';

		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);

		$handler =& $this->mController->load('handler', 'data');
		$this->mTpl->assign('handler', $handler);
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=DataList');
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=DataList', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=DataList');
	}

	/**
	 * @protected
	 */
	function _doExecute()
	{
		$this->checkPerm();
		if ($this->mObjectHandler->delete($this->mObject)) {
			xoops_comment_delete($this->mController->mXoopsModule->getVar('mid'), $this->_getId());
			xoops_notification_deletebyitem($this->mController->mXoopsModule->getVar('mid'), 'data', $this->_getId());
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
	
		return XDBASE_FRAME_VIEW_ERROR;
	}

	function checkPerm()
	{
		$dataHandler =&$this->_getHandler();
		$did = $this->_getId();
		if (_MD_XDBASE_CONST_SUPERDELETE == false)
		{
			$this->mController->executeRedirect('./index.php?action=DataList', 3, _NOPERM);
		}
		if (!$dataHandler->checkData($did))
		{
			$this->mController->executeRedirect('./index.php?action=DataList', 3, _NOPERM);
		}
	}

}

?>
