<?php
/**
 * Smarty plugin
 * @package xdbase
 * @version $Id$
 */

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     xoops_dhtmltarea
 * Version:  1.0
 * Date:     Jun 6, 2004
 * Author:   minahito
 * Purpose:  cycle through given values
 * Input:    name = form 'name'.
 *           value = preset value. Set raw value without htmlspecialchars().
 *           id = form 'id'. If it's empty, ID is defined automatically by prefix & name.
 *           cols = amount of cols. (default 50)
 *           rows = amount of rows. (default 7)
 * 
 * Examples: {xoops_dhtmltarea name=message cols=40 rows=6 value=$message}
 * -------------------------------------------------------------
 */

define ("XOOPS_DHTMLTAREA_DEFID_PREFIX", "legacy_xoopsform_");
define ("XOOPS_DHTMLTAREA_DEFAULT_COLS", "50");
define ("XOOPS_DHTMLTAREA_DEFAULT_ROWS", "7");

function smarty_function_xdbase_dhtmltarea($params, &$smarty)
{
//	if (!XC_CLASS_EXISTS('xoopsformelement')) {
	if (!class_exists('xoopsformelement')) {
		
		require_once XOOPS_ROOT_PATH . "/class/xoopsformloader.php";
	}
	$form = null;

	if (isset($params['name'])) {
		//
		// Fetch major elements from $params.
		//
		$name = trim($params['name']);
		$class = isset($params['class']) ? trim($params['class']) : null;
		$cols = isset($params['cols']) ? intval($params['cols']) : XOOPS_DHTMLTAREA_DEFAULT_COLS;
		$rows = isset($params['rows']) ? intval($params['rows']) : XOOPS_DHTMLTAREA_DEFAULT_ROWS;
		$value = isset($params['value']) ? htmlspecialchars($params['value'], ENT_QUOTES) : null;
		$id = isset($params['id']) ? trim($params['id']) : XOOPS_DHTMLTAREA_DEFID_PREFIX . $name;

		//
		// Build the object for output.
		//
		$form =& new XoopsFormDhtmlTextArea($name, $name, $value, $rows, $cols);
//		$form->setId($id);
		if ($class != null) {
			$form->setClass($class);
		}
		
		print $form->render();
	}
}

?>
