<?php
class defaultView extends topicView
{
function dispatch(&$context)
{
	require APP_FRAMEWORK_DIR.'/global.php';
	$xoopsOption['template_main'] = $mydirname.'-topic.html';
	require_once XOOPS_ROOT_PATH.'/header.php';
	
	$this->assignHeader(
		array('topic.css', 'respopup.css'), 
		array('respopup.js')
	);
	
	$community = $context->getAttributes('community');
	$topic = $context->getAttributes('topic');
	$comment_count = $context->getAttributes('comment_count');
	
	$this->assignBreadcrumbsList('breadcrumbs_list', $community, $topic);
	
	$this->assignFormHeader('form_res_add', 'post', 'topic', 'res_confirm', true, 
					array('tid' => $topic['id']));
	$this->assignCommunityTopLink('top_link', $community['id'], $community['name']);
	$this->assignUploadFormJS();
	
	$default = $context->getAttributes('default');
	$this->assignXoopsCodeTarea($default['body'], 'body', 60, 8);
	
	$context->assignAttributesToTpl();
	
	$lang = array(
		'topic' => '['.$community['name'].'] '._CM_TOPIC,
		'comment' => _CM_TOPIC_RESPONSE,
		'body' => _CM_TOPIC_RESPONSE,
		'edit_topic' => _CM_TOPIC_EDIT,
		'write_topic' => _CM_TOPIC_WRITE,
		'add_res' => _CM_TOPIC_ADD_RES,
		'comment_deleted' => _CM_TOPIC_COM_DELETED,
		'image' => _CM_TOPIC_IMAGE,
		'image_add' => _CM_TOPIC_IMAGE_ADD,
		'file' => _CM_TOPIC_FILE,
		'file_add' => _CM_TOPIC_FILE_ADD,
		'submit' => _CM_BTN_TOPIC_ADD_RES,
		'delete_comment' => _CM_TOPIC_DEL_RES,
		'comment_count' => sprintf(_CM_TOPIC_COUNT, $comment_count),
	);
	$this->tpl->assign('lang', $lang);
	
	require_once XOOPS_ROOT_PATH.'/footer.php';
}
}
?>
