<?php
class editView extends topicView
{
function dispatch(&$context)
{
	require APP_FRAMEWORK_DIR.'/global.php';
	$xoopsOption['template_main'] = $mydirname.'-topic_edit.html';
	require_once XOOPS_ROOT_PATH.'/header.php';
	
	$commu = $context->getAttributes('community');
	$topic = $context->getAttributes('topic');
	$comment = $context->getAttributes('comment');
	
	$topic_info = array(
		'id' => $topic['id'],
		'name' => $topic['name'],
	);
	$page_title = ($comment['number'] > 0)? _CM_TITLE_TOPIC_RES_EDIT : _CM_TITLE_TOPIC_EDIT;
	
	$this->assignHeader('topic.css');
	
	$this->assignFormHeader('form_edit_topic', 'post', 'topic', 'edit_exec', true,
		array('tid' => $topic['id'], 'n' => $comment['number']), 'TOPIC_EDIT');
	
	$this->assignFormHeader('form_del_topic', 'get', 'topic', 'del', false,
		array('tid' => $topic['id'], 'n' => 0));
	
	$this->assignBreadcrumbsList('breadcrumbs_list', $commu, $topic_info, $page_title);
	
	$this->assignUploadFormJS(count($comment['images']), count($comment['files']));
	
	$this->assignXoopsCodeTarea($comment['body'], 'body', 60, 10);
	
	$context->assignAttributesToTpl();
	
	$lang = array(
		'edit_topic' => $page_title,
		'title' => _CM_TOPIC_TITLE,
		'comment_id' => _CM_TOPIC_RESPONSE_ID,
		'body' => _CM_TOPIC_BODY,
		'image' => _CM_TOPIC_IMAGE,
		'file' => _CM_TOPIC_FILE,
		'image_add' => _CM_TOPIC_IMAGE_ADD,
		'file_add' => _CM_TOPIC_FILE_ADD,
		'submit' => _CM_BTN_TOPIC_EDIT,
		'del' => _CM_IMAGE_DEL,
		'del_topic' => _CM_TOPIC_DEL_DESC,
		'del_image' => _CM_IMAGE_DEL,
		'submit_del' => _CM_BTN_TOPIC_DEL,
	);
	$this->tpl->assign('lang', $lang);
	
	require_once XOOPS_ROOT_PATH.'/footer.php';
}
}
?>
