<?php
class add_confirmAction extends indexAction
{
function dispatch(&$context)
{
	if($this->isGuest()){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$name = $this->getTextRequest('name');
	$cat_id = $this->getIntRequest('category');
	$public_id = $this->getIntRequest('public');
	$info = $this->getTextRequest('info');
	
	$errors = array();
	$commu_handler =& CM_CommunityHandler::getInstance();
	if(!$commu_handler->checkParams(0, $name, $info, $cat_id, $public_id)){
		$errors = $commu_handler->getErrors();
	}
	
	if($public_id < 1 || $public_id > 3){
		$public_id = 1;
	}
	
	$new_community =& $commu_handler->create();
	$new_community->setVar('name', $name);
	$new_community->setVar('info', $info);
	
	$_SESSION['community_name'] = $name;
	$_SESSION['community_cat_id'] = $cat_id;
	$_SESSION['community_public_id'] = $public_id;
	$_SESSION['community_info'] = $info;
	
	$category_handler =& CM_CategoryHandler::getInstance();
	
	// check input : NG
	if(count($errors) > 0){
		$default = array(
			'name' => $new_community->getVar('name', 'f'),
			'info' => $new_community->getVar('info', 'f'),
			'public'.$public_id => ' checked',
		);
		$category_selector = $category_handler->getSelectorHtml('category', $cat_id, _CM_SELBOX_DEFAULT);
		$context->setAttributes('category_selector', $category_selector);
		$context->setAttributes('default', $default);
		$context->setAttributes('errors', $errors);
		return "add";	//  index/addView.php
	}
	
	// check input : OK
	$image_handler =& CM_ImageHandler::getInstance();
	
	$public_desc = array(
		'1' => _CM_INDEX_PUBLIC_L1,
		'2' => _CM_INDEX_PUBLIC_L2,
		'3' => _CM_INDEX_PUBLIC_L3,
	);
	
	$category =& $category_handler->get($cat_id);
	
	$commu_data = array(
		'name' => $new_community->getVar('name', 'p'),
		'category_id' => $cat_id,
		'category' => $category->getVar('name', 'p'),
		'public_id' => $public_id,
		'public' => $public_desc[$public_id],
		'info' => $new_community->getVar('info', 'p'),
		'image' => $image_handler->uploadImageTemp('image'),
	);
	
	$context->setAttributes('commu', $commu_data);
}
//------------------------------------------------------------------------------

}
?>
